/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.email;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.email.EventLogDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventLogDomainCodec
implements MessageCodec<EventLogDomain, EventLogDomain> {
    private static final Logger log = LoggerFactory.getLogger(EventLogDomainCodec.class);

    public void encodeToWire(Buffer buffer, EventLogDomain eventLogDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)eventLogDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public EventLogDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (EventLogDomain)gson.fromJson(jsonStr, EventLogDomain.class);
    }

    public EventLogDomain transform(EventLogDomain eventLogDomain) {
        return eventLogDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

