/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.TransportationTypesMapper;
import cz.airtoy.airshop.domains.TransportationTypesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TransportationTypesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.analyticalaccount,\n\t\tp.code,\n\t\tp.hidden,\n\t\tp.name,\n\t\tp.objversion,\n\t\tp.show_from,\n\t\tp.show_to,\n\t\tp.updated,\n\t\tp.balikobot_shipper,\n\t\tp.balikobot_service_type,\n\t\tp.systems_allowed,\n\t\tp.store_id,\n\t\tp.date_created\n FROM \n\t\tabra.transportation_types p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.show_from::text ~* :mask \n\tOR \n\t\tp.show_to::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.balikobot_shipper::text ~* :mask \n\tOR \n\t\tp.balikobot_service_type::text ~* :mask \n\tOR \n\t\tp.systems_allowed::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.analyticalaccount,\n\t\tp.code,\n\t\tp.hidden,\n\t\tp.name,\n\t\tp.objversion,\n\t\tp.show_from,\n\t\tp.show_to,\n\t\tp.updated,\n\t\tp.balikobot_shipper,\n\t\tp.balikobot_service_type,\n\t\tp.systems_allowed,\n\t\tp.store_id,\n\t\tp.date_created\n FROM \n\t\tabra.view_transportation_types p\n\t\n\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.balikobot_shipper::text ~* :mask \n\tOR \n\t\tp.balikobot_service_type::text ~* :mask \n\tOR \n\t\tp.systems_allowed::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findByMaskValid(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.transportation_types p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.show_from::text ~* :mask \n\tOR \n\t\tp.show_to::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.balikobot_shipper::text ~* :mask \n\tOR \n\t\tp.balikobot_service_type::text ~* :mask \n\tOR \n\t\tp.systems_allowed::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.view_transportation_types p\n\t\n\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.analyticalaccount::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.hidden::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.objversion::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.balikobot_shipper::text ~* :mask \n\tOR \n\t\tp.balikobot_service_type::text ~* :mask \n\tOR \n\t\tp.systems_allowed::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskValidCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  ")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.id = :id")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.analyticalaccount = :analyticalaccount")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.analyticalaccount = :analyticalaccount")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.analyticalaccount = :analyticalaccount")
    public long findListByAnalyticalaccountCount(@Bind(value="analyticalaccount") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.analyticalaccount = :analyticalaccount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByAnalyticalaccount(@Bind(value="analyticalaccount") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.code = :code")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.code = :code")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.hidden = :hidden")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByHidden(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.hidden = :hidden")
    public long findListByHiddenCount(@Bind(value="hidden") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.hidden = :hidden ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByHidden(@Bind(value="hidden") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.name = :name")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.name = :name")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.objversion = :objversion")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByObjversion(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.objversion = :objversion")
    public long findListByObjversionCount(@Bind(value="objversion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.objversion = :objversion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByObjversion(@Bind(value="objversion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_from = :showFrom")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByShowFrom(@Bind(value="showFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_from = :showFrom")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByShowFrom(@Bind(value="showFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.show_from = :showFrom")
    public long findListByShowFromCount(@Bind(value="showFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_from = :showFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByShowFrom(@Bind(value="showFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_to = :showTo")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByShowTo(@Bind(value="showTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_to = :showTo")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByShowTo(@Bind(value="showTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.show_to = :showTo")
    public long findListByShowToCount(@Bind(value="showTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.show_to = :showTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByShowTo(@Bind(value="showTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_shipper = :balikobotShipper")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByBalikobotShipper(@Bind(value="balikobotShipper") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_shipper = :balikobotShipper")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByBalikobotShipper(@Bind(value="balikobotShipper") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.balikobot_shipper = :balikobotShipper")
    public long findListByBalikobotShipperCount(@Bind(value="balikobotShipper") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_shipper = :balikobotShipper ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByBalikobotShipper(@Bind(value="balikobotShipper") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_service_type = :balikobotServiceType")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByBalikobotServiceType(@Bind(value="balikobotServiceType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_service_type = :balikobotServiceType")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByBalikobotServiceType(@Bind(value="balikobotServiceType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.balikobot_service_type = :balikobotServiceType")
    public long findListByBalikobotServiceTypeCount(@Bind(value="balikobotServiceType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.balikobot_service_type = :balikobotServiceType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByBalikobotServiceType(@Bind(value="balikobotServiceType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.systems_allowed = :systemsAllowed")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findBySystemsAllowed(@Bind(value="systemsAllowed") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.systems_allowed = :systemsAllowed")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListBySystemsAllowed(@Bind(value="systemsAllowed") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.systems_allowed = :systemsAllowed")
    public long findListBySystemsAllowedCount(@Bind(value="systemsAllowed") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.systems_allowed = :systemsAllowed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListBySystemsAllowed(@Bind(value="systemsAllowed") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public TransportationTypesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.transportation_types p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.analyticalaccount, p.code, p.hidden, p.name, p.objversion, p.show_from, p.show_to, p.updated, p.balikobot_shipper, p.balikobot_service_type, p.systems_allowed, p.store_id, p.date_created FROM abra.transportation_types p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TransportationTypesMapper.class)
    public List<TransportationTypesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.transportation_types (id, uid, abra_id, analyticalaccount, code, hidden, name, objversion, show_from, show_to, updated, balikobot_shipper, balikobot_service_type, systems_allowed, store_id, date_created) VALUES (:id, :uid, :abraId, :analyticalaccount, :code, :hidden, :name, :objversion, :showFrom, :showTo, :updated, :balikobotShipper, :balikobotServiceType, :systemsAllowed, :storeId, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="analyticalaccount") String var4, @Bind(value="code") String var5, @Bind(value="hidden") Boolean var6, @Bind(value="name") String var7, @Bind(value="objversion") Integer var8, @Bind(value="showFrom") Date var9, @Bind(value="showTo") Date var10, @Bind(value="updated") Date var11, @Bind(value="balikobotShipper") String var12, @Bind(value="balikobotServiceType") String var13, @Bind(value="systemsAllowed") String var14, @Bind(value="storeId") Long var15, @Bind(value="dateCreated") Date var16);

    @SqlUpdate(value="INSERT INTO abra.transportation_types (abra_id, analyticalaccount, code, hidden, name, objversion, show_from, show_to, updated, balikobot_shipper, balikobot_service_type, systems_allowed, store_id, date_created) VALUES (:e.abraId, :e.analyticalaccount, :e.code, :e.hidden, :e.name, :e.objversion, :e.showFrom, :e.showTo, :e.updated, :e.balikobotShipper, :e.balikobotServiceType, :e.systemsAllowed, :e.storeId, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TransportationTypesDomain var1);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE analyticalaccount = :byAnalyticalaccount")
    public int updateByAnalyticalaccount(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byAnalyticalaccount") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE hidden = :byHidden")
    public int updateByHidden(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byHidden") Boolean var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE objversion = :byObjversion")
    public int updateByObjversion(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byObjversion") Integer var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE show_from = :byShowFrom")
    public int updateByShowFrom(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byShowFrom") Date var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE show_to = :byShowTo")
    public int updateByShowTo(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byShowTo") Date var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE balikobot_shipper = :byBalikobotShipper")
    public int updateByBalikobotShipper(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byBalikobotShipper") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE balikobot_service_type = :byBalikobotServiceType")
    public int updateByBalikobotServiceType(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byBalikobotServiceType") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE systems_allowed = :bySystemsAllowed")
    public int updateBySystemsAllowed(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="bySystemsAllowed") String var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.transportation_types SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, analyticalaccount = :e.analyticalaccount, code = :e.code, hidden = :e.hidden, name = :e.name, objversion = :e.objversion, show_from = :e.showFrom, show_to = :e.showTo, updated = :e.updated, balikobot_shipper = :e.balikobotShipper, balikobot_service_type = :e.balikobotServiceType, systems_allowed = :e.systemsAllowed, store_id = :e.storeId, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TransportationTypesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE analyticalaccount = :analyticalaccount")
    public int deleteByAnalyticalaccount(@Bind(value="analyticalaccount") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE hidden = :hidden")
    public int deleteByHidden(@Bind(value="hidden") Boolean var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE objversion = :objversion")
    public int deleteByObjversion(@Bind(value="objversion") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE show_from = :showFrom")
    public int deleteByShowFrom(@Bind(value="showFrom") Date var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE show_to = :showTo")
    public int deleteByShowTo(@Bind(value="showTo") Date var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE balikobot_shipper = :balikobotShipper")
    public int deleteByBalikobotShipper(@Bind(value="balikobotShipper") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE balikobot_service_type = :balikobotServiceType")
    public int deleteByBalikobotServiceType(@Bind(value="balikobotServiceType") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE systems_allowed = :systemsAllowed")
    public int deleteBySystemsAllowed(@Bind(value="systemsAllowed") String var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.transportation_types WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

