/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.OrderSubscriptionMapper;
import cz.airtoy.airshop.dao.mappers.full.OrderSubscriptionFullMapper;
import cz.airtoy.airshop.domains.OrderSubscriptionDomain;
import cz.airtoy.airshop.domains.full.OrderSubscriptionFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface OrderSubscriptionDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.subscription_id,\n\t\tp.subscription_item_id,\n\t\tp.source_order_id,\n\t\tp.order_id,\n\t\tp.index,\n\t\tp.frequency,\n\t\tp.externalnumber,\n\t\tp.opened,\n\t\tp.ordered_again,\n\t\tp.ordered_again_cnt,\n\t\tp.send_on,\n\t\tp.firm,\n\t\tp.city,\n\t\tp.house_number,\n\t\tp.street,\n\t\tp.postcode,\n\t\tp.country,\n\t\tp.country_code,\n\t\tp.email,\n\t\tp.phone,\n\t\tp.phone2,\n\t\tp.data_box,\n\t\tp.display_name,\n\t\tp.gps,\n\t\tp.location,\n\t\tp.recipient,\n\t\tp.short_address,\n\t\tp.zip,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.order_subscription p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.subscription_id::text ~* :mask \n\tOR \n\t\tp.subscription_item_id::text ~* :mask \n\tOR \n\t\tp.source_order_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.frequency::text ~* :mask \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.opened::text ~* :mask \n\tOR \n\t\tp.ordered_again::text ~* :mask \n\tOR \n\t\tp.ordered_again_cnt::text ~* :mask \n\tOR \n\t\tp.send_on::text ~* :mask \n\tOR \n\t\tp.firm::text ~* :mask \n\tOR \n\t\tp.city::text ~* :mask \n\tOR \n\t\tp.house_number::text ~* :mask \n\tOR \n\t\tp.street::text ~* :mask \n\tOR \n\t\tp.postcode::text ~* :mask \n\tOR \n\t\tp.country::text ~* :mask \n\tOR \n\t\tp.country_code::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.phone2::text ~* :mask \n\tOR \n\t\tp.data_box::text ~* :mask \n\tOR \n\t\tp.display_name::text ~* :mask \n\tOR \n\t\tp.gps::text ~* :mask \n\tOR \n\t\tp.location::text ~* :mask \n\tOR \n\t\tp.recipient::text ~* :mask \n\tOR \n\t\tp.short_address::text ~* :mask \n\tOR \n\t\tp.zip::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.order_subscription p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.subscription_id::text ~* :mask \n\tOR \n\t\tp.subscription_item_id::text ~* :mask \n\tOR \n\t\tp.source_order_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.frequency::text ~* :mask \n\tOR \n\t\tp.externalnumber::text ~* :mask \n\tOR \n\t\tp.opened::text ~* :mask \n\tOR \n\t\tp.ordered_again::text ~* :mask \n\tOR \n\t\tp.ordered_again_cnt::text ~* :mask \n\tOR \n\t\tp.send_on::text ~* :mask \n\tOR \n\t\tp.firm::text ~* :mask \n\tOR \n\t\tp.city::text ~* :mask \n\tOR \n\t\tp.house_number::text ~* :mask \n\tOR \n\t\tp.street::text ~* :mask \n\tOR \n\t\tp.postcode::text ~* :mask \n\tOR \n\t\tp.country::text ~* :mask \n\tOR \n\t\tp.country_code::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.phone2::text ~* :mask \n\tOR \n\t\tp.data_box::text ~* :mask \n\tOR \n\t\tp.display_name::text ~* :mask \n\tOR \n\t\tp.gps::text ~* :mask \n\tOR \n\t\tp.location::text ~* :mask \n\tOR \n\t\tp.recipient::text ~* :mask \n\tOR \n\t\tp.short_address::text ~* :mask \n\tOR \n\t\tp.zip::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created, o.abra_stav_objednavky_id, s.name as abra_stav_objednavky_name FROM abra.order_subscription p  LEFT OUTER JOIN abra.orders o ON p.order_id = o.id LEFT OUTER JOIN abra.stav_objednavky s ON o.abra_stav_objednavky_id = s.abra_id WHERE p.source_order_id = :orderId OR p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionFullMapper.class)
    public List<OrderSubscriptionFullDomain> findListBySourceOrderIdOrOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.source_order_id = :orderId OR p.order_id = :orderId")
    public long findListBySourceOrderIdOrOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.source_order_id = :sourceOrderId AND p.index = :index")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findBySourceOrderIdIndex(@Bind(value="sourceOrderId") Long var1, @Bind(value="index") Integer var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p WHERE p.source_order_id IS NULL AND p.index = :index ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySourceNullAndIndex(@Bind(value="index") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p WHERE p.source_order_id IS NULL AND p.index = :index")
    public long findListBySourceNullAndIndexCount(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, COALESCE( (SELECT os.send_on FROM abra.order_subscription os WHERE os.source_order_id = p.order_id AND COALESCE(os.index, 0) = :index ), p.send_on ) AS send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p LEFT OUTER JOIN (SELECT pm.source_order_id, max(pm.index) as maxindex FROM abra.order_subscription pm GROUP BY pm.source_order_id ) foo ON (foo.source_order_id = p.order_id) WHERE p.source_order_id IS NULL AND COALESCE(foo.maxindex, 0) = :index ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySourceNullAndSubOrdersCount(@Bind(value="index") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p LEFT OUTER JOIN (SELECT pm.source_order_id, max(pm.index) as maxindex FROM abra.order_subscription pm GROUP BY pm.source_order_id ) foo ON (foo.source_order_id = p.order_id) WHERE p.source_order_id IS NULL AND COALESCE(foo.maxindex, 0) = :index")
    public long findListBySourceNullAndSubOrdersCountCount(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  ")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.id = :id")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_id = :subscriptionId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_id = :subscriptionId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.subscription_id = :subscriptionId")
    public long findListBySubscriptionIdCount(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_id = :subscriptionId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySubscriptionId(@Bind(value="subscriptionId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_item_id = :subscriptionItemId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findBySubscriptionItemId(@Bind(value="subscriptionItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_item_id = :subscriptionItemId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySubscriptionItemId(@Bind(value="subscriptionItemId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.subscription_item_id = :subscriptionItemId")
    public long findListBySubscriptionItemIdCount(@Bind(value="subscriptionItemId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.subscription_item_id = :subscriptionItemId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySubscriptionItemId(@Bind(value="subscriptionItemId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.source_order_id = :sourceOrderId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findBySourceOrderId(@Bind(value="sourceOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.source_order_id = :sourceOrderId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySourceOrderId(@Bind(value="sourceOrderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.source_order_id = :sourceOrderId")
    public long findListBySourceOrderIdCount(@Bind(value="sourceOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.source_order_id = :sourceOrderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySourceOrderId(@Bind(value="sourceOrderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.index = :index")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.index = :index")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.index = :index")
    public long findListByIndexCount(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.index = :index ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByIndex(@Bind(value="index") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.frequency = :frequency")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByFrequency(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.frequency = :frequency")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByFrequency(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.frequency = :frequency")
    public long findListByFrequencyCount(@Bind(value="frequency") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.frequency = :frequency ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByFrequency(@Bind(value="frequency") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.externalnumber = :externalnumber")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByExternalnumber(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.externalnumber = :externalnumber")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByExternalnumber(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.externalnumber LIKE :externalnumber")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByExternalnumberLike(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.externalnumber = :externalnumber")
    public long findListByExternalnumberCount(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.externalnumber LIKE :externalnumber")
    public long findListByExternalnumberLikeCount(@Bind(value="externalnumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.externalnumber = :externalnumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByExternalnumber(@Bind(value="externalnumber") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.opened = :opened")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByOpened(@Bind(value="opened") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.opened = :opened")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOpened(@Bind(value="opened") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.opened = :opened")
    public long findListByOpenedCount(@Bind(value="opened") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.opened = :opened ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOpened(@Bind(value="opened") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again = :orderedAgain")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByOrderedAgain(@Bind(value="orderedAgain") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again = :orderedAgain")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderedAgain(@Bind(value="orderedAgain") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.ordered_again = :orderedAgain")
    public long findListByOrderedAgainCount(@Bind(value="orderedAgain") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again = :orderedAgain ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderedAgain(@Bind(value="orderedAgain") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again_cnt = :orderedAgainCnt")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByOrderedAgainCnt(@Bind(value="orderedAgainCnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again_cnt = :orderedAgainCnt")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderedAgainCnt(@Bind(value="orderedAgainCnt") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.ordered_again_cnt = :orderedAgainCnt")
    public long findListByOrderedAgainCntCount(@Bind(value="orderedAgainCnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.ordered_again_cnt = :orderedAgainCnt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByOrderedAgainCnt(@Bind(value="orderedAgainCnt") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.send_on = :sendOn")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findBySendOn(@Bind(value="sendOn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.send_on = :sendOn")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySendOn(@Bind(value="sendOn") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.send_on = :sendOn")
    public long findListBySendOnCount(@Bind(value="sendOn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.send_on = :sendOn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListBySendOn(@Bind(value="sendOn") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.firm = :firm")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByFirm(@Bind(value="firm") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.firm = :firm")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByFirm(@Bind(value="firm") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.firm = :firm")
    public long findListByFirmCount(@Bind(value="firm") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.firm = :firm ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByFirm(@Bind(value="firm") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.city = :city")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByCity(@Bind(value="city") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.city = :city")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCity(@Bind(value="city") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.city = :city")
    public long findListByCityCount(@Bind(value="city") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.city = :city ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCity(@Bind(value="city") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.house_number = :houseNumber")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByHouseNumber(@Bind(value="houseNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.house_number = :houseNumber")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByHouseNumber(@Bind(value="houseNumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.house_number = :houseNumber")
    public long findListByHouseNumberCount(@Bind(value="houseNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.house_number = :houseNumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByHouseNumber(@Bind(value="houseNumber") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.street = :street")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByStreet(@Bind(value="street") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.street = :street")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByStreet(@Bind(value="street") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.street = :street")
    public long findListByStreetCount(@Bind(value="street") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.street = :street ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByStreet(@Bind(value="street") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.postcode = :postcode")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByPostcode(@Bind(value="postcode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.postcode = :postcode")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPostcode(@Bind(value="postcode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.postcode = :postcode")
    public long findListByPostcodeCount(@Bind(value="postcode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.postcode = :postcode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPostcode(@Bind(value="postcode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country = :country")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByCountry(@Bind(value="country") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country = :country")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCountry(@Bind(value="country") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.country = :country")
    public long findListByCountryCount(@Bind(value="country") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country = :country ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCountry(@Bind(value="country") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country_code = :countryCode")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByCountryCode(@Bind(value="countryCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country_code = :countryCode")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCountryCode(@Bind(value="countryCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.country_code = :countryCode")
    public long findListByCountryCodeCount(@Bind(value="countryCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.country_code = :countryCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByCountryCode(@Bind(value="countryCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.email = :email")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.email = :email")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.email = :email")
    public long findListByEmailCount(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.email = :email ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByEmail(@Bind(value="email") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.phone = :phone")
    public long findListByPhoneCount(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone = :phone ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPhone(@Bind(value="phone") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone2 = :phone2")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByPhone2(@Bind(value="phone2") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone2 = :phone2")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPhone2(@Bind(value="phone2") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.phone2 = :phone2")
    public long findListByPhone2Count(@Bind(value="phone2") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.phone2 = :phone2 ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByPhone2(@Bind(value="phone2") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.data_box = :dataBox")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByDataBox(@Bind(value="dataBox") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.data_box = :dataBox")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDataBox(@Bind(value="dataBox") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.data_box = :dataBox")
    public long findListByDataBoxCount(@Bind(value="dataBox") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.data_box = :dataBox ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDataBox(@Bind(value="dataBox") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.display_name = :displayName")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByDisplayName(@Bind(value="displayName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.display_name = :displayName")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDisplayName(@Bind(value="displayName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.display_name = :displayName")
    public long findListByDisplayNameCount(@Bind(value="displayName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.display_name = :displayName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDisplayName(@Bind(value="displayName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.gps = :gps")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByGps(@Bind(value="gps") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.gps = :gps")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByGps(@Bind(value="gps") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.gps = :gps")
    public long findListByGpsCount(@Bind(value="gps") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.gps = :gps ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByGps(@Bind(value="gps") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.location = :location")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByLocation(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.location = :location")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByLocation(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.location = :location")
    public long findListByLocationCount(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.location = :location ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByLocation(@Bind(value="location") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.recipient = :recipient")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByRecipient(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.recipient = :recipient")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByRecipient(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.recipient = :recipient")
    public long findListByRecipientCount(@Bind(value="recipient") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.recipient = :recipient ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByRecipient(@Bind(value="recipient") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.short_address = :shortAddress")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByShortAddress(@Bind(value="shortAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.short_address = :shortAddress")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByShortAddress(@Bind(value="shortAddress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.short_address = :shortAddress")
    public long findListByShortAddressCount(@Bind(value="shortAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.short_address = :shortAddress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByShortAddress(@Bind(value="shortAddress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.zip = :zip")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByZip(@Bind(value="zip") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.zip = :zip")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByZip(@Bind(value="zip") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.zip = :zip")
    public long findListByZipCount(@Bind(value="zip") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.zip = :zip ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByZip(@Bind(value="zip") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.note = :note")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public OrderSubscriptionDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.order_subscription p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.subscription_item_id, p.source_order_id, p.order_id, p.index, p.frequency, p.externalnumber, p.opened, p.ordered_again, p.ordered_again_cnt, p.send_on, p.firm, p.city, p.house_number, p.street, p.postcode, p.country, p.country_code, p.email, p.phone, p.phone2, p.data_box, p.display_name, p.gps, p.location, p.recipient, p.short_address, p.zip, p.note, p.date_created FROM abra.order_subscription p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=OrderSubscriptionMapper.class)
    public List<OrderSubscriptionDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.order_subscription (id, uid, subscription_id, subscription_item_id, source_order_id, order_id, index, frequency, externalnumber, opened, ordered_again, ordered_again_cnt, send_on, firm, city, house_number, street, postcode, country, country_code, email, phone, phone2, data_box, display_name, gps, location, recipient, short_address, zip, note, date_created) VALUES (:id, :uid, :subscriptionId, :subscriptionItemId, :sourceOrderId, :orderId, :index, :frequency, :externalnumber, :opened, :orderedAgain, :orderedAgainCnt, :sendOn, :firm, :city, :houseNumber, :street, :postcode, :country, :countryCode, :email, :phone, :phone2, :dataBox, :displayName, :gps, :location, :recipient, :shortAddress, :zip, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="subscriptionId") Long var3, @Bind(value="subscriptionItemId") Long var4, @Bind(value="sourceOrderId") Long var5, @Bind(value="orderId") Long var6, @Bind(value="index") Integer var7, @Bind(value="frequency") Integer var8, @Bind(value="externalnumber") String var9, @Bind(value="opened") Date var10, @Bind(value="orderedAgain") Date var11, @Bind(value="orderedAgainCnt") Integer var12, @Bind(value="sendOn") Date var13, @Bind(value="firm") String var14, @Bind(value="city") String var15, @Bind(value="houseNumber") String var16, @Bind(value="street") String var17, @Bind(value="postcode") String var18, @Bind(value="country") String var19, @Bind(value="countryCode") String var20, @Bind(value="email") String var21, @Bind(value="phone") String var22, @Bind(value="phone2") String var23, @Bind(value="dataBox") String var24, @Bind(value="displayName") String var25, @Bind(value="gps") String var26, @Bind(value="location") String var27, @Bind(value="recipient") String var28, @Bind(value="shortAddress") String var29, @Bind(value="zip") String var30, @Bind(value="note") String var31, @Bind(value="dateCreated") Date var32);

    @SqlUpdate(value="INSERT INTO abra.order_subscription (subscription_id, subscription_item_id, source_order_id, order_id, index, frequency, externalnumber, opened, ordered_again, ordered_again_cnt, send_on, firm, city, house_number, street, postcode, country, country_code, email, phone, phone2, data_box, display_name, gps, location, recipient, short_address, zip, note, date_created) VALUES (:e.subscriptionId, :e.subscriptionItemId, :e.sourceOrderId, :e.orderId, :e.index, :e.frequency, :e.externalnumber, :e.opened, :e.orderedAgain, :e.orderedAgainCnt, :e.sendOn, :e.firm, :e.city, :e.houseNumber, :e.street, :e.postcode, :e.country, :e.countryCode, :e.email, :e.phone, :e.phone2, :e.dataBox, :e.displayName, :e.gps, :e.location, :e.recipient, :e.shortAddress, :e.zip, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") OrderSubscriptionDomain var1);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE subscription_id = :bySubscriptionId")
    public int updateBySubscriptionId(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="bySubscriptionId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE subscription_item_id = :bySubscriptionItemId")
    public int updateBySubscriptionItemId(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="bySubscriptionItemId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE source_order_id = :bySourceOrderId")
    public int updateBySourceOrderId(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="bySourceOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE index = :byIndex")
    public int updateByIndex(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byIndex") Integer var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE frequency = :byFrequency")
    public int updateByFrequency(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byFrequency") Integer var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE externalnumber = :byExternalnumber")
    public int updateByExternalnumber(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byExternalnumber") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE opened = :byOpened")
    public int updateByOpened(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byOpened") Date var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE ordered_again = :byOrderedAgain")
    public int updateByOrderedAgain(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byOrderedAgain") Date var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE ordered_again_cnt = :byOrderedAgainCnt")
    public int updateByOrderedAgainCnt(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byOrderedAgainCnt") Integer var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE send_on = :bySendOn")
    public int updateBySendOn(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="bySendOn") Date var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE firm = :byFirm")
    public int updateByFirm(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byFirm") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE city = :byCity")
    public int updateByCity(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byCity") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE house_number = :byHouseNumber")
    public int updateByHouseNumber(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byHouseNumber") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE street = :byStreet")
    public int updateByStreet(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byStreet") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE postcode = :byPostcode")
    public int updateByPostcode(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byPostcode") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE country = :byCountry")
    public int updateByCountry(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byCountry") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE country_code = :byCountryCode")
    public int updateByCountryCode(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byCountryCode") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE email = :byEmail")
    public int updateByEmail(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byEmail") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE phone = :byPhone")
    public int updateByPhone(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byPhone") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE phone2 = :byPhone2")
    public int updateByPhone2(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byPhone2") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE data_box = :byDataBox")
    public int updateByDataBox(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byDataBox") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE display_name = :byDisplayName")
    public int updateByDisplayName(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byDisplayName") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE gps = :byGps")
    public int updateByGps(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byGps") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE location = :byLocation")
    public int updateByLocation(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byLocation") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE recipient = :byRecipient")
    public int updateByRecipient(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byRecipient") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE short_address = :byShortAddress")
    public int updateByShortAddress(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byShortAddress") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE zip = :byZip")
    public int updateByZip(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byZip") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.order_subscription SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, subscription_item_id = :e.subscriptionItemId, source_order_id = :e.sourceOrderId, order_id = :e.orderId, index = :e.index, frequency = :e.frequency, externalnumber = :e.externalnumber, opened = :e.opened, ordered_again = :e.orderedAgain, ordered_again_cnt = :e.orderedAgainCnt, send_on = :e.sendOn, firm = :e.firm, city = :e.city, house_number = :e.houseNumber, street = :e.street, postcode = :e.postcode, country = :e.country, country_code = :e.countryCode, email = :e.email, phone = :e.phone, phone2 = :e.phone2, data_box = :e.dataBox, display_name = :e.displayName, gps = :e.gps, location = :e.location, recipient = :e.recipient, short_address = :e.shortAddress, zip = :e.zip, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") OrderSubscriptionDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE subscription_id = :subscriptionId")
    public int deleteBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE subscription_item_id = :subscriptionItemId")
    public int deleteBySubscriptionItemId(@Bind(value="subscriptionItemId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE source_order_id = :sourceOrderId")
    public int deleteBySourceOrderId(@Bind(value="sourceOrderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE index = :index")
    public int deleteByIndex(@Bind(value="index") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE frequency = :frequency")
    public int deleteByFrequency(@Bind(value="frequency") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE externalnumber = :externalnumber")
    public int deleteByExternalnumber(@Bind(value="externalnumber") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE opened = :opened")
    public int deleteByOpened(@Bind(value="opened") Date var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE ordered_again = :orderedAgain")
    public int deleteByOrderedAgain(@Bind(value="orderedAgain") Date var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE ordered_again_cnt = :orderedAgainCnt")
    public int deleteByOrderedAgainCnt(@Bind(value="orderedAgainCnt") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE send_on = :sendOn")
    public int deleteBySendOn(@Bind(value="sendOn") Date var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE firm = :firm")
    public int deleteByFirm(@Bind(value="firm") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE city = :city")
    public int deleteByCity(@Bind(value="city") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE house_number = :houseNumber")
    public int deleteByHouseNumber(@Bind(value="houseNumber") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE street = :street")
    public int deleteByStreet(@Bind(value="street") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE postcode = :postcode")
    public int deleteByPostcode(@Bind(value="postcode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE country = :country")
    public int deleteByCountry(@Bind(value="country") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE country_code = :countryCode")
    public int deleteByCountryCode(@Bind(value="countryCode") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE email = :email")
    public int deleteByEmail(@Bind(value="email") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE phone = :phone")
    public int deleteByPhone(@Bind(value="phone") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE phone2 = :phone2")
    public int deleteByPhone2(@Bind(value="phone2") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE data_box = :dataBox")
    public int deleteByDataBox(@Bind(value="dataBox") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE display_name = :displayName")
    public int deleteByDisplayName(@Bind(value="displayName") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE gps = :gps")
    public int deleteByGps(@Bind(value="gps") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE location = :location")
    public int deleteByLocation(@Bind(value="location") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE recipient = :recipient")
    public int deleteByRecipient(@Bind(value="recipient") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE short_address = :shortAddress")
    public int deleteByShortAddress(@Bind(value="shortAddress") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE zip = :zip")
    public int deleteByZip(@Bind(value="zip") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.order_subscription WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

