/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import cz.airtoy.airshop.configuration.ApplicationConfig;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpRequest;
import io.vertx.ext.web.client.HttpResponse;
import io.vertx.ext.web.client.WebClient;
import java.util.Base64;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NewVertxClient
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(NewVertxClient.class);
    private WebClient client = null;
    private static final String BASE_URI = "http://localhost:8080";
    private String url = null;
    private String host = null;
    private Integer port = null;
    private String path = null;
    private String username = null;
    private String password = null;
    private String encoding = null;
    private HttpRequest<Buffer> httpRequest = null;
    public String type = null;
    public String payload = null;
    public Handler<AsyncResult<HttpResponse<Buffer>>> handler = null;

    public NewVertxClient(Vertx vertx) {
        this.createWebClient(vertx, ApplicationConfig.CONNECT_TIMEOUT);
    }

    public NewVertxClient(Vertx vertx, String url) {
        this.createWebClient(vertx, ApplicationConfig.CONNECT_TIMEOUT);
        this.url = url;
    }

    public NewVertxClient(Vertx vertx, String url, String username, String password) {
        this.createWebClient(vertx, ApplicationConfig.CONNECT_TIMEOUT);
        this.registerClientBasicAuth(username, password);
        this.url = url;
    }

    public NewVertxClient(Vertx vertx, String url, String username, String password, Integer timeout) {
        this.createWebClient(vertx, timeout);
        this.registerClientBasicAuth(username, password);
        this.url = url;
    }

    public NewVertxClient(Vertx vertx, String host, Integer port, String path, String username, String password, Integer timeout) {
        this.createWebClient(vertx, timeout);
        this.registerClientBasicAuth(username, password);
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public NewVertxClient(Vertx vertx, String host, Integer port, String path, String username, String password) {
        this.createWebClient(vertx, ApplicationConfig.CONNECT_TIMEOUT);
        this.registerClientBasicAuth(username, password);
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public NewVertxClient(Vertx vertx, String host, Integer port, String path) {
        this.createWebClient(vertx, ApplicationConfig.CONNECT_TIMEOUT);
        this.host = host;
        this.port = port;
        this.path = path;
    }

    public void getJson(Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.getText(handler);
    }

    public void getText(Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.get(this.url) : this.client.get(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue());
            this.addBasicAuth();
            try {
                this.httpRequest.send(handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void delete(Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.delete(this.url) : this.client.delete(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue());
            this.addBasicAuth();
            try {
                this.httpRequest.send(handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void postJson(String post, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        this.payload = post;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.post(this.url) : this.client.post(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue());
            this.addBasicAuth();
            try {
                this.httpRequest.sendBuffer(Buffer.buffer((String)post), handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void postJsonStrAcceptAll(String post, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.postJson(post, handler);
    }

    public void postJsonAcceptJson(String post, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        this.payload = post;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.post(this.url) : this.client.post(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue()).putHeader("Content-Type", "application/json").putHeader("Accept", "application/json");
            this.addBasicAuth();
            try {
                this.httpRequest.sendBuffer(Buffer.buffer((String)post), handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void postJsonAcceptAll(String post, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        this.payload = post;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.post(this.url) : this.client.post(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue()).putHeader("Content-Type", "application/json");
            this.addBasicAuth();
            try {
                this.httpRequest.sendBuffer(Buffer.buffer((String)post), handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void putJsonAcceptJson(String put, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        this.payload = put;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.put(this.url) : this.client.put(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue()).putHeader("Content-Type", "application/json").putHeader("Accept", "application/json");
            this.addBasicAuth();
            try {
                this.httpRequest.sendBuffer(Buffer.buffer((String)put), handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void postXmlAcceptPlain(String post, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        this.handler = handler;
        this.payload = post;
        if (this.client != null) {
            this.httpRequest = this.url != null ? this.client.post(this.url) : this.client.post(this.port.intValue(), this.host, this.path);
            this.httpRequest.timeout((long)ApplicationConfig.READ_LONG_TIMEOUT.intValue()).putHeader("Content-Type", "application/xml").putHeader("Accept", "text/plain");
            this.addBasicAuth();
            try {
                this.httpRequest.sendBuffer(Buffer.buffer((String)post), handler);
            }
            catch (Exception e) {
                log.error("E: " + e.getMessage());
            }
        } else {
            log.error("Client is NULL");
        }
    }

    public void postObjJsonAcceptJson(Object postObj, Handler<AsyncResult<HttpResponse<Buffer>>> handler) {
        String post = null;
        try {
            Gson gson = new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(Date.class, (json, typeOfT, context) -> json == null ? null : new Date(json.getAsLong())).serializeNulls().create();
            post = gson.toJson(postObj);
            this.postJsonAcceptJson(post, handler);
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
    }

    private void createWebClient(Vertx vertx, Integer timeout) {
        this.client = WebClient.create((Vertx)vertx);
    }

    private void registerClientBasicAuth(String username, String password) {
        this.username = username;
        this.password = password;
        this.encoding = Base64.getEncoder().encodeToString((this.username + ":" + this.password).getBytes());
    }

    private void addBasicAuth() {
        if (this.username != null) {
            this.httpRequest.putHeader("Authorization", "Basic " + this.encoding);
        }
    }

    @Override
    public void close() {
        if (this.client != null) {
            this.client.close();
        }
    }
}

