/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import cz.airtoy.airshop.configuration.ApplicationConfig;
import cz.airtoy.airshop.utils.NewVertxClient;
import cz.airtoy.system.domains.Attachment;
import cz.airtoy.system.domains.SendEmail;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.buffer.Buffer;
import io.vertx.ext.web.client.HttpResponse;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventProcessorRoutines {
    private static final Logger log = LoggerFactory.getLogger(EventProcessorRoutines.class);

    public static void sendPdfEmailAttachment(Vertx vertx, String template, String email, String invoiceNumber, String pdfData) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("HTML");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("INVOICE_NUMBER", invoiceNumber);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email (without attachment): " + sendEmail);
        if (pdfData != null) {
            Attachment attachment = new Attachment();
            attachment.setBase64(pdfData);
            Path path = Paths.get(invoiceNumber.replace("/", "-"), new String[0]);
            attachment.setMimetype("application/pdf");
            attachment.setFilename(path.toString() + ".pdf");
            attachment.setName(path.toString());
            attachment.setPath(path.toString() + ".pdf");
            attachment.setSize(Integer.valueOf((int)((double)attachment.getBase64().length() / 1.37) + 814));
            attachment.setType("PDF");
            sendEmail.setAttachments(Collections.singletonList(attachment));
            log.debug("attachment: " + attachment);
        } else {
            log.warn("Cannot send attachment to " + email + " - NULL PDF CONTENT");
        }
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendExcelEmailAttachment(Vertx vertx, String template, String email, String fileName, String excelData) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("HTML");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("FILE_NAME", fileName);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email (without attachment): " + sendEmail);
        if (excelData != null) {
            Attachment attachment = new Attachment();
            attachment.setBase64(excelData);
            attachment.setMimetype("application/vnd.ms-excel");
            attachment.setFilename(fileName);
            attachment.setName(fileName);
            attachment.setPath(fileName);
            attachment.setSize(Integer.valueOf((int)((double)attachment.getBase64().length() / 1.37) + 814));
            attachment.setType("EXCEL");
            sendEmail.setAttachments(Collections.singletonList(attachment));
            log.debug("attachment: " + attachment);
        } else {
            log.warn("Cannot send attachment to " + email + " - NULL EXCEL CONTENT");
        }
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendSystemEmail(Vertx vertx, String template, String email, String subject, String body) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("HTML");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("SUBJECT", subject);
        cacheData.put("BODY", body);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        sendEmail.setSubject(subject);
        log.info("Sending email (without attachment): " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendSms(Vertx vertx, String template, String phone, String invoiceNumber) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(phone);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("SMS");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("INVOICE_NUMBER", invoiceNumber);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending sms: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendSmsWithDataBody(Vertx vertx, String template, String phone, String body) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(phone);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("SMS");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("BODY", body);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending sms: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendSms(Vertx vertx, String template, String phone, String invoiceNumber, String email) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(phone);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("SMS");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("INVOICE_NUMBER", invoiceNumber);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        sendEmail.setSubject(email);
        log.info("Sending sms: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendEmail(Vertx vertx, String template, String email, String invoiceNumber) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("HTML");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("INVOICE_NUMBER", invoiceNumber);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendEmailWithDataSubjectBody(Vertx vertx, String template, String email, String subject, String body) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem("BEER");
        sendEmail.setType("HTML");
        ConcurrentHashMap<String, String> cacheData = new ConcurrentHashMap<String, String>();
        cacheData.put("SUBJECT", subject);
        cacheData.put("BODY", body);
        sendEmail.setData(cacheData);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendEmail(Vertx vertx, String template, String email, String system, ConcurrentHashMap<String, String> data) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        sendEmail.setTemplate(template);
        sendEmail.setSystem(system);
        sendEmail.setType("HTML");
        sendEmail.setData(data);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    public static void sendEmail(Vertx vertx, String template, String email, String system, ConcurrentHashMap<String, String> data, String emailCC, String emailBCC) {
        SendEmail sendEmail = new SendEmail();
        sendEmail.setEmail(email);
        if (emailCC != null && !emailCC.isEmpty()) {
            sendEmail.setEmailCC(emailCC);
        }
        if (emailBCC != null && !emailBCC.isEmpty()) {
            sendEmail.setEmailBCC(emailBCC);
        }
        sendEmail.setTemplate(template);
        sendEmail.setSystem(system);
        sendEmail.setType("HTML");
        sendEmail.setData(data);
        sendEmail.setAddEmailIfNotExists(true);
        log.info("Sending email: " + sendEmail);
        EventProcessorRoutines.processSendEmail(vertx, sendEmail);
    }

    private static void processSendEmail(Vertx vertx, SendEmail sendEmail) {
        try (NewVertxClient client = new NewVertxClient(vertx, "email.airtoy.cz", ApplicationConfig.EP_INTERFACE_PORT, "/api/rest/send");){
            client.postObjJsonAcceptJson(sendEmail, (Handler<AsyncResult<HttpResponse<Buffer>>>)((Handler)ar -> {
                block11: {
                    if (ar.succeeded()) {
                        HttpResponse response = (HttpResponse)ar.result();
                        String content = response.bodyAsString();
                        log.info("Result: code" + response.statusCode() + " message " + response.statusMessage() + " / " + content);
                        if (content != null) {
                            try {
                                JsonObject data = new JsonParser().parse(content).getAsJsonObject();
                                if (data != null) {
                                    log.info(data.toString());
                                    JsonElement el = data.get("status");
                                    if (el != null && !el.isJsonNull()) {
                                        try {
                                            String statusResult = el.getAsString();
                                            if ("OK".equalsIgnoreCase(statusResult != null ? statusResult : "")) {
                                                log.info("OK");
                                                break block11;
                                            }
                                            log.error("Returned status element is not OK [" + statusResult + "]");
                                        }
                                        catch (Exception e) {
                                            log.error("Cannot return result as String " + e.getMessage(), (Throwable)e);
                                        }
                                        break block11;
                                    }
                                    log.error("Returned status element is null");
                                    break block11;
                                }
                                log.error("Returned data is null");
                            }
                            catch (Exception e) {
                                log.error("Exception JSON: " + e.getMessage(), (Throwable)e);
                            }
                        } else {
                            log.error("Returned content is null");
                        }
                    } else {
                        log.error("Cannot connect: " + ar.cause().getMessage());
                    }
                }
            }));
        }
    }
}

