/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.balikobot;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.balikobot.DpdParcelStatusLogMapper;
import cz.airtoy.airshop.domains.balikobot.DpdParcelStatusLogDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DpdParcelStatusLogDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.order_id = :orderId AND p.parcel_event_id = :parcelEventId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByOrderIdParcelEventId(@Bind(value="orderId") Long var1, @Bind(value="parcelEventId") Long var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.order_id,\n\t\tp.balikobot_order_id,\n\t\tp.parcel_ident,\n\t\tp.parcel_event_id,\n\t\tp.created_at,\n\t\tp.stav_objednavky_abra_id,\n\t\tp.stav_objednavky_code,\n\t\tp.status_code,\n\t\tp.status_description,\n\t\tp.service_code,\n\t\tp.processed_at,\n\t\tp.date_created\n FROM \n\t\tbalikobot.dpd_parcel_status_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.balikobot_order_id::text ~* :mask \n\tOR \n\t\tp.parcel_ident::text ~* :mask \n\tOR \n\t\tp.parcel_event_id::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.stav_objednavky_abra_id::text ~* :mask \n\tOR \n\t\tp.stav_objednavky_code::text ~* :mask \n\tOR \n\t\tp.status_code::text ~* :mask \n\tOR \n\t\tp.status_description::text ~* :mask \n\tOR \n\t\tp.service_code::text ~* :mask \n\tOR \n\t\tp.processed_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tbalikobot.dpd_parcel_status_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.balikobot_order_id::text ~* :mask \n\tOR \n\t\tp.parcel_ident::text ~* :mask \n\tOR \n\t\tp.parcel_event_id::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.stav_objednavky_abra_id::text ~* :mask \n\tOR \n\t\tp.stav_objednavky_code::text ~* :mask \n\tOR \n\t\tp.status_code::text ~* :mask \n\tOR \n\t\tp.status_description::text ~* :mask \n\tOR \n\t\tp.service_code::text ~* :mask \n\tOR \n\t\tp.processed_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  ")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.balikobot_order_id = :balikobotOrderId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByBalikobotOrderId(@Bind(value="balikobotOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.balikobot_order_id = :balikobotOrderId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByBalikobotOrderId(@Bind(value="balikobotOrderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.balikobot_order_id = :balikobotOrderId")
    public long findListByBalikobotOrderIdCount(@Bind(value="balikobotOrderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.balikobot_order_id = :balikobotOrderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByBalikobotOrderId(@Bind(value="balikobotOrderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_ident = :parcelIdent")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByParcelIdent(@Bind(value="parcelIdent") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_ident = :parcelIdent")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByParcelIdent(@Bind(value="parcelIdent") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_ident = :parcelIdent")
    public long findListByParcelIdentCount(@Bind(value="parcelIdent") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_ident = :parcelIdent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByParcelIdent(@Bind(value="parcelIdent") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_event_id = :parcelEventId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByParcelEventId(@Bind(value="parcelEventId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_event_id = :parcelEventId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByParcelEventId(@Bind(value="parcelEventId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_event_id = :parcelEventId")
    public long findListByParcelEventIdCount(@Bind(value="parcelEventId") Long var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.parcel_event_id = :parcelEventId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByParcelEventId(@Bind(value="parcelEventId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.created_at = :createdAt")
    public long findListByCreatedAtCount(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.created_at = :createdAt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_abra_id = :stavObjednavkyAbraId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByStavObjednavkyAbraId(@Bind(value="stavObjednavkyAbraId") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_abra_id = :stavObjednavkyAbraId")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStavObjednavkyAbraId(@Bind(value="stavObjednavkyAbraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_abra_id = :stavObjednavkyAbraId")
    public long findListByStavObjednavkyAbraIdCount(@Bind(value="stavObjednavkyAbraId") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_abra_id = :stavObjednavkyAbraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStavObjednavkyAbraId(@Bind(value="stavObjednavkyAbraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_code = :stavObjednavkyCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByStavObjednavkyCode(@Bind(value="stavObjednavkyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_code = :stavObjednavkyCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStavObjednavkyCode(@Bind(value="stavObjednavkyCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_code = :stavObjednavkyCode")
    public long findListByStavObjednavkyCodeCount(@Bind(value="stavObjednavkyCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.stav_objednavky_code = :stavObjednavkyCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStavObjednavkyCode(@Bind(value="stavObjednavkyCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_code = :statusCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByStatusCode(@Bind(value="statusCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_code = :statusCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStatusCode(@Bind(value="statusCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.status_code = :statusCode")
    public long findListByStatusCodeCount(@Bind(value="statusCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_code = :statusCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStatusCode(@Bind(value="statusCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_description = :statusDescription")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByStatusDescription(@Bind(value="statusDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_description = :statusDescription")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStatusDescription(@Bind(value="statusDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.status_description = :statusDescription")
    public long findListByStatusDescriptionCount(@Bind(value="statusDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.status_description = :statusDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByStatusDescription(@Bind(value="statusDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.service_code = :serviceCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByServiceCode(@Bind(value="serviceCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.service_code = :serviceCode")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByServiceCode(@Bind(value="serviceCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.service_code = :serviceCode")
    public long findListByServiceCodeCount(@Bind(value="serviceCode") String var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.service_code = :serviceCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByServiceCode(@Bind(value="serviceCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.processed_at = :processedAt")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByProcessedAt(@Bind(value="processedAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.processed_at = :processedAt")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByProcessedAt(@Bind(value="processedAt") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.processed_at = :processedAt")
    public long findListByProcessedAtCount(@Bind(value="processedAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.processed_at = :processedAt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByProcessedAt(@Bind(value="processedAt") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public DpdParcelStatusLogDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM balikobot.dpd_parcel_status_log p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.order_id, p.balikobot_order_id, p.parcel_ident, p.parcel_event_id, p.created_at, p.stav_objednavky_abra_id, p.stav_objednavky_code, p.status_code, p.status_description, p.service_code, p.processed_at, p.date_created FROM balikobot.dpd_parcel_status_log p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DpdParcelStatusLogMapper.class)
    public List<DpdParcelStatusLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO balikobot.dpd_parcel_status_log (id, order_id, balikobot_order_id, parcel_ident, parcel_event_id, created_at, stav_objednavky_abra_id, stav_objednavky_code, status_code, status_description, service_code, processed_at, date_created) VALUES (:id, :orderId, :balikobotOrderId, :parcelIdent, :parcelEventId, :createdAt, :stavObjednavkyAbraId, :stavObjednavkyCode, :statusCode, :statusDescription, :serviceCode, :processedAt, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="orderId") Long var2, @Bind(value="balikobotOrderId") Long var3, @Bind(value="parcelIdent") String var4, @Bind(value="parcelEventId") Long var5, @Bind(value="createdAt") Date var6, @Bind(value="stavObjednavkyAbraId") String var7, @Bind(value="stavObjednavkyCode") String var8, @Bind(value="statusCode") String var9, @Bind(value="statusDescription") String var10, @Bind(value="serviceCode") String var11, @Bind(value="processedAt") Date var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO balikobot.dpd_parcel_status_log (order_id, balikobot_order_id, parcel_ident, parcel_event_id, created_at, stav_objednavky_abra_id, stav_objednavky_code, status_code, status_description, service_code, processed_at, date_created) VALUES (:e.orderId, :e.balikobotOrderId, :e.parcelIdent, :e.parcelEventId, :e.createdAt, :e.stavObjednavkyAbraId, :e.stavObjednavkyCode, :e.statusCode, :e.statusDescription, :e.serviceCode, :e.processedAt, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") DpdParcelStatusLogDomain var1);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE balikobot_order_id = :byBalikobotOrderId")
    public int updateByBalikobotOrderId(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byBalikobotOrderId") Long var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE parcel_ident = :byParcelIdent")
    public int updateByParcelIdent(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byParcelIdent") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE parcel_event_id = :byParcelEventId")
    public int updateByParcelEventId(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byParcelEventId") Long var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE created_at = :byCreatedAt")
    public int updateByCreatedAt(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byCreatedAt") Date var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE stav_objednavky_abra_id = :byStavObjednavkyAbraId")
    public int updateByStavObjednavkyAbraId(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byStavObjednavkyAbraId") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE stav_objednavky_code = :byStavObjednavkyCode")
    public int updateByStavObjednavkyCode(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byStavObjednavkyCode") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE status_code = :byStatusCode")
    public int updateByStatusCode(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byStatusCode") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE status_description = :byStatusDescription")
    public int updateByStatusDescription(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byStatusDescription") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE service_code = :byServiceCode")
    public int updateByServiceCode(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byServiceCode") String var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE processed_at = :byProcessedAt")
    public int updateByProcessedAt(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byProcessedAt") Date var2);

    @SqlUpdate(value="UPDATE balikobot.dpd_parcel_status_log SET id = :e.id, order_id = :e.orderId, balikobot_order_id = :e.balikobotOrderId, parcel_ident = :e.parcelIdent, parcel_event_id = :e.parcelEventId, created_at = :e.createdAt, stav_objednavky_abra_id = :e.stavObjednavkyAbraId, stav_objednavky_code = :e.stavObjednavkyCode, status_code = :e.statusCode, status_description = :e.statusDescription, service_code = :e.serviceCode, processed_at = :e.processedAt, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") DpdParcelStatusLogDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE balikobot_order_id = :balikobotOrderId")
    public int deleteByBalikobotOrderId(@Bind(value="balikobotOrderId") Long var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE parcel_ident = :parcelIdent")
    public int deleteByParcelIdent(@Bind(value="parcelIdent") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE parcel_event_id = :parcelEventId")
    public int deleteByParcelEventId(@Bind(value="parcelEventId") Long var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE created_at = :createdAt")
    public int deleteByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE stav_objednavky_abra_id = :stavObjednavkyAbraId")
    public int deleteByStavObjednavkyAbraId(@Bind(value="stavObjednavkyAbraId") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE stav_objednavky_code = :stavObjednavkyCode")
    public int deleteByStavObjednavkyCode(@Bind(value="stavObjednavkyCode") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE status_code = :statusCode")
    public int deleteByStatusCode(@Bind(value="statusCode") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE status_description = :statusDescription")
    public int deleteByStatusDescription(@Bind(value="statusDescription") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE service_code = :serviceCode")
    public int deleteByServiceCode(@Bind(value="serviceCode") String var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE processed_at = :processedAt")
    public int deleteByProcessedAt(@Bind(value="processedAt") Date var1);

    @SqlUpdate(value="DELETE FROM balikobot.dpd_parcel_status_log WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

