/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.app;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.app.DeviceLogsMapper;
import cz.airtoy.airshop.domains.app.DeviceLogsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DeviceLogsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.username,\n\t\tp.device_id,\n\t\tp.carrier_info,\n\t\tp.device_model,\n\t\tp.manufacturer,\n\t\tp.device_brand,\n\t\tp.android_version,\n\t\tp.sdk_version,\n\t\tp.app_version,\n\t\tp.serial_number,\n\t\tp.created_at,\n\t\tp.date_created\n FROM \n\t\tapp.device_logs p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.username::text ~* :mask \n\tOR \n\t\tp.device_id::text ~* :mask \n\tOR \n\t\tp.carrier_info::text ~* :mask \n\tOR \n\t\tp.device_model::text ~* :mask \n\tOR \n\t\tp.manufacturer::text ~* :mask \n\tOR \n\t\tp.device_brand::text ~* :mask \n\tOR \n\t\tp.android_version::text ~* :mask \n\tOR \n\t\tp.sdk_version::text ~* :mask \n\tOR \n\t\tp.app_version::text ~* :mask \n\tOR \n\t\tp.serial_number::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.device_logs p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.username::text ~* :mask \n\tOR \n\t\tp.device_id::text ~* :mask \n\tOR \n\t\tp.carrier_info::text ~* :mask \n\tOR \n\t\tp.device_model::text ~* :mask \n\tOR \n\t\tp.manufacturer::text ~* :mask \n\tOR \n\t\tp.device_brand::text ~* :mask \n\tOR \n\t\tp.android_version::text ~* :mask \n\tOR \n\t\tp.sdk_version::text ~* :mask \n\tOR \n\t\tp.app_version::text ~* :mask \n\tOR \n\t\tp.serial_number::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  ")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.id = :id")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.id = :id")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.username = :username")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByUsername(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.username = :username")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByUsername(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.username = :username")
    public long findListByUsernameCount(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.username = :username ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByUsername(@Bind(value="username") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_id = :deviceId")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByDeviceId(@Bind(value="deviceId") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_id = :deviceId")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceId(@Bind(value="deviceId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.device_id = :deviceId")
    public long findListByDeviceIdCount(@Bind(value="deviceId") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_id = :deviceId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceId(@Bind(value="deviceId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.carrier_info = :carrierInfo")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByCarrierInfo(@Bind(value="carrierInfo") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.carrier_info = :carrierInfo")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByCarrierInfo(@Bind(value="carrierInfo") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.carrier_info = :carrierInfo")
    public long findListByCarrierInfoCount(@Bind(value="carrierInfo") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.carrier_info = :carrierInfo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByCarrierInfo(@Bind(value="carrierInfo") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_model = :deviceModel")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByDeviceModel(@Bind(value="deviceModel") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_model = :deviceModel")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceModel(@Bind(value="deviceModel") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.device_model = :deviceModel")
    public long findListByDeviceModelCount(@Bind(value="deviceModel") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_model = :deviceModel ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceModel(@Bind(value="deviceModel") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.manufacturer = :manufacturer")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByManufacturer(@Bind(value="manufacturer") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.manufacturer = :manufacturer")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByManufacturer(@Bind(value="manufacturer") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.manufacturer = :manufacturer")
    public long findListByManufacturerCount(@Bind(value="manufacturer") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.manufacturer = :manufacturer ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByManufacturer(@Bind(value="manufacturer") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_brand = :deviceBrand")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByDeviceBrand(@Bind(value="deviceBrand") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_brand = :deviceBrand")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceBrand(@Bind(value="deviceBrand") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.device_brand = :deviceBrand")
    public long findListByDeviceBrandCount(@Bind(value="deviceBrand") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.device_brand = :deviceBrand ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDeviceBrand(@Bind(value="deviceBrand") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.android_version = :androidVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByAndroidVersion(@Bind(value="androidVersion") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.android_version = :androidVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByAndroidVersion(@Bind(value="androidVersion") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.android_version = :androidVersion")
    public long findListByAndroidVersionCount(@Bind(value="androidVersion") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.android_version = :androidVersion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByAndroidVersion(@Bind(value="androidVersion") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.sdk_version = :sdkVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findBySdkVersion(@Bind(value="sdkVersion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.sdk_version = :sdkVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListBySdkVersion(@Bind(value="sdkVersion") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.sdk_version = :sdkVersion")
    public long findListBySdkVersionCount(@Bind(value="sdkVersion") Integer var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.sdk_version = :sdkVersion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListBySdkVersion(@Bind(value="sdkVersion") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.app_version = :appVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByAppVersion(@Bind(value="appVersion") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.app_version = :appVersion")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByAppVersion(@Bind(value="appVersion") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.app_version = :appVersion")
    public long findListByAppVersionCount(@Bind(value="appVersion") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.app_version = :appVersion ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByAppVersion(@Bind(value="appVersion") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.serial_number = :serialNumber")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findBySerialNumber(@Bind(value="serialNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.serial_number = :serialNumber")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListBySerialNumber(@Bind(value="serialNumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.serial_number = :serialNumber")
    public long findListBySerialNumberCount(@Bind(value="serialNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.serial_number = :serialNumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListBySerialNumber(@Bind(value="serialNumber") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.created_at = :createdAt")
    public long findListByCreatedAtCount(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.created_at = :createdAt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public DeviceLogsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_logs p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.username, p.device_id, p.carrier_info, p.device_model, p.manufacturer, p.device_brand, p.android_version, p.sdk_version, p.app_version, p.serial_number, p.created_at, p.date_created FROM app.device_logs p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogsMapper.class)
    public List<DeviceLogsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.device_logs (id, username, device_id, carrier_info, device_model, manufacturer, device_brand, android_version, sdk_version, app_version, serial_number, created_at, date_created) VALUES (:id, :username, :deviceId, :carrierInfo, :deviceModel, :manufacturer, :deviceBrand, :androidVersion, :sdkVersion, :appVersion, :serialNumber, :createdAt, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="username") String var2, @Bind(value="deviceId") String var3, @Bind(value="carrierInfo") String var4, @Bind(value="deviceModel") String var5, @Bind(value="manufacturer") String var6, @Bind(value="deviceBrand") String var7, @Bind(value="androidVersion") String var8, @Bind(value="sdkVersion") Integer var9, @Bind(value="appVersion") String var10, @Bind(value="serialNumber") String var11, @Bind(value="createdAt") Date var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO app.device_logs (username, device_id, carrier_info, device_model, manufacturer, device_brand, android_version, sdk_version, app_version, serial_number, created_at, date_created) VALUES (:e.username, :e.deviceId, :e.carrierInfo, :e.deviceModel, :e.manufacturer, :e.deviceBrand, :e.androidVersion, :e.sdkVersion, :e.appVersion, :e.serialNumber, :e.createdAt, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") DeviceLogsDomain var1);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE username = :byUsername")
    public int updateByUsername(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byUsername") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE device_id = :byDeviceId")
    public int updateByDeviceId(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byDeviceId") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE carrier_info = :byCarrierInfo")
    public int updateByCarrierInfo(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byCarrierInfo") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE device_model = :byDeviceModel")
    public int updateByDeviceModel(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byDeviceModel") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE manufacturer = :byManufacturer")
    public int updateByManufacturer(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byManufacturer") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE device_brand = :byDeviceBrand")
    public int updateByDeviceBrand(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byDeviceBrand") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE android_version = :byAndroidVersion")
    public int updateByAndroidVersion(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byAndroidVersion") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE sdk_version = :bySdkVersion")
    public int updateBySdkVersion(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="bySdkVersion") Integer var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE app_version = :byAppVersion")
    public int updateByAppVersion(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byAppVersion") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE serial_number = :bySerialNumber")
    public int updateBySerialNumber(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="bySerialNumber") String var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE created_at = :byCreatedAt")
    public int updateByCreatedAt(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byCreatedAt") Date var2);

    @SqlUpdate(value="UPDATE app.device_logs SET id = :e.id, username = :e.username, device_id = :e.deviceId, carrier_info = :e.carrierInfo, device_model = :e.deviceModel, manufacturer = :e.manufacturer, device_brand = :e.deviceBrand, android_version = :e.androidVersion, sdk_version = :e.sdkVersion, app_version = :e.appVersion, serial_number = :e.serialNumber, created_at = :e.createdAt, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") DeviceLogsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE username = :username")
    public int deleteByUsername(@Bind(value="username") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE device_id = :deviceId")
    public int deleteByDeviceId(@Bind(value="deviceId") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE carrier_info = :carrierInfo")
    public int deleteByCarrierInfo(@Bind(value="carrierInfo") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE device_model = :deviceModel")
    public int deleteByDeviceModel(@Bind(value="deviceModel") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE manufacturer = :manufacturer")
    public int deleteByManufacturer(@Bind(value="manufacturer") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE device_brand = :deviceBrand")
    public int deleteByDeviceBrand(@Bind(value="deviceBrand") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE android_version = :androidVersion")
    public int deleteByAndroidVersion(@Bind(value="androidVersion") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE sdk_version = :sdkVersion")
    public int deleteBySdkVersion(@Bind(value="sdkVersion") Integer var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE app_version = :appVersion")
    public int deleteByAppVersion(@Bind(value="appVersion") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE serial_number = :serialNumber")
    public int deleteBySerialNumber(@Bind(value="serialNumber") String var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE created_at = :createdAt")
    public int deleteByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlUpdate(value="DELETE FROM app.device_logs WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

