/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.access;

import cz.airtoy.airshop.domains.AccessListDomain;
import cz.airtoy.airshop.misc.DaoSupportApp;
import io.vertx.core.http.HttpServerRequest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class AirshopAccess {
    private static volatile AirshopAccess INSTANCE;
    private final DaoSupportApp ds;
    private volatile List<AccessListDomain> cachedAccessList = Collections.emptyList();

    private AirshopAccess(DaoSupportApp ds) {
        this.ds = ds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AirshopAccess getInstance(DaoSupportApp ds) {
        if (INSTANCE != null) return INSTANCE;
        Class<AirshopAccess> clazz = AirshopAccess.class;
        synchronized (AirshopAccess.class) {
            if (INSTANCE != null) return INSTANCE;
            INSTANCE = new AirshopAccess(ds);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static AirshopAccess getInstance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("AirshopAccess not initialized. Call getInstance(ds) first.");
        }
        return INSTANCE;
    }

    public void refreshAccessList() {
        block2: {
            try {
                List<AccessListDomain> list = this.ds.getAccessListDbiDao().findListAll();
                this.cachedAccessList = list != null ? new ArrayList<AccessListDomain>(list) : Collections.emptyList();
            }
            catch (Exception e) {
                if (this.cachedAccessList != null) break block2;
                this.cachedAccessList = Collections.emptyList();
            }
        }
    }

    public boolean isClientAllowed(String clientIp) {
        return AirshopAccess.isClientAllowed(clientIp, this.cachedAccessList);
    }

    public static String getClientIp(HttpServerRequest request) {
        if (request == null) {
            return "";
        }
        String clientIp = null;
        try {
            String xff = request.getHeader("X-Forwarded-For");
            if (xff != null && !xff.isEmpty()) {
                clientIp = xff.split(",")[0].trim();
            }
        }
        catch (Exception xff) {
            // empty catch block
        }
        if (clientIp == null || clientIp.isEmpty()) {
            try {
                String xri = request.getHeader("X-Real-IP");
                if (xri != null && !xri.isEmpty()) {
                    clientIp = xri.trim();
                }
            }
            catch (Exception xri) {
                // empty catch block
            }
        }
        if (clientIp == null || clientIp.isEmpty()) {
            try {
                if (request.remoteAddress() != null) {
                    clientIp = request.remoteAddress().host();
                }
            }
            catch (Exception e) {
                try {
                    clientIp = String.valueOf(request.remoteAddress());
                    if (clientIp != null && clientIp.contains("/")) {
                        clientIp = clientIp.substring(clientIp.indexOf(47) + 1);
                    }
                    if (clientIp != null && clientIp.contains(":")) {
                        clientIp = clientIp.split(":")[0];
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        if (clientIp == null) {
            clientIp = "";
        }
        return clientIp;
    }

    public static boolean isClientAllowed(String clientIp, List<AccessListDomain> accessList) {
        if (clientIp == null || clientIp.isEmpty()) {
            return false;
        }
        ArrayList<String> deny = new ArrayList<String>();
        ArrayList<String> allow = new ArrayList<String>();
        if (accessList != null) {
            for (AccessListDomain d : accessList) {
                try {
                    deny.addAll(AirshopAccess.splitRules(d.getDenyIpAddress()));
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    allow.addAll(AirshopAccess.splitRules(d.getAllowIpAddress()));
                }
                catch (Exception exception) {}
            }
        }
        if (AirshopAccess.ipMatchesAny(clientIp, deny)) {
            return false;
        }
        if (allow.isEmpty()) {
            return true;
        }
        return AirshopAccess.ipMatchesAny(clientIp, allow);
    }

    static List<String> splitRules(String s) {
        String[] parts;
        ArrayList<String> out = new ArrayList<String>();
        if (s == null) {
            return out;
        }
        for (String p : parts = s.split("[;,\\s]+")) {
            String v;
            if (p == null || (v = p.trim()).isEmpty()) continue;
            out.add(v);
        }
        return out;
    }

    static boolean ipMatchesAny(String ip, List<String> rules) {
        if (rules == null || rules.isEmpty()) {
            return false;
        }
        for (String rule : rules) {
            if (!AirshopAccess.ipMatchesRule(ip, rule)) continue;
            return true;
        }
        return false;
    }

    static boolean ipMatchesRule(String ip, String rule) {
        if (ip == null || rule == null) {
            return false;
        }
        String r = rule.trim();
        if (r.isEmpty()) {
            return false;
        }
        if ("*".equals(r)) {
            return true;
        }
        if (r.endsWith(".*")) {
            String prefix = r.substring(0, r.length() - 1);
            return ip.startsWith(prefix);
        }
        if (r.contains("/")) {
            try {
                return AirshopAccess.ipv4InCidr(ip, r);
            }
            catch (Exception ignore) {
                return false;
            }
        }
        return ip.equals(r);
    }

    static boolean ipv4InCidr(String ip, String cidr) {
        if (ip == null || cidr == null) {
            return false;
        }
        if (ip.contains(":")) {
            return false;
        }
        String[] parts = cidr.split("/");
        if (parts.length != 2) {
            return false;
        }
        long ipLong = AirshopAccess.ipv4ToLong(ip);
        long baseLong = AirshopAccess.ipv4ToLong(parts[0]);
        if (ipLong < 0L || baseLong < 0L) {
            return false;
        }
        int prefix = Integer.parseInt(parts[1]);
        long mask = prefix == 0 ? 0L : 0xFFFFFFFFL << 32 - prefix & 0xFFFFFFFFL;
        return (ipLong & mask) == (baseLong & mask);
    }

    static long ipv4ToLong(String ip) {
        if (ip == null) {
            return -1L;
        }
        String[] parts = ip.trim().split("\\.");
        if (parts.length != 4) {
            return -1L;
        }
        long result = 0L;
        for (int i = 0; i < 4; ++i) {
            try {
                int octet = Integer.parseInt(parts[i]);
                if (octet < 0 || octet > 255) {
                    return -1L;
                }
                result = result << 8 | (long)(octet & 0xFF);
                continue;
            }
            catch (NumberFormatException e) {
                return -1L;
            }
        }
        return result;
    }
}

