/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLConnection;
import java.time.Duration;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FtpUtils {
    private static final Logger log = LoggerFactory.getLogger(FtpUtils.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void sendStreamAsFileToFtp(String targetFileName, String data, String fcFtpHost, String fcFtpUsername, String fcFtpPassword) {
        block20: {
            log.info(String.format("Sending DATA[%d] as %s to %s@%s", data.length(), targetFileName, fcFtpUsername, fcFtpHost));
            FTPClient client = new FTPClient();
            try (ByteArrayInputStream targetStream = new ByteArrayInputStream(data.getBytes());){
                FTPFile[] ftpFiles;
                client.setControlKeepAliveTimeout(Duration.ofMinutes(5L));
                client.setControlKeepAliveReplyTimeout(Duration.ofMinutes(5L));
                client.setDataTimeout(Duration.ofMinutes(5L));
                client.connect(fcFtpHost);
                client.login(fcFtpUsername, fcFtpPassword);
                client.enterLocalPassiveMode();
                client.setFileType(2);
                client.storeFile(targetFileName, (InputStream)targetStream);
                for (FTPFile ftpFile : ftpFiles = client.listFiles()) {
                    System.out.println(String.format("File: %s", ftpFile));
                }
            }
            try {
                if (client.isConnected()) {
                    client.logout();
                    client.disconnect();
                }
                break block20;
            }
            catch (Exception e) {
                log.error(String.format("Exception %s", e.getMessage()));
            }
            break block20;
            catch (Exception e) {
                try {
                    log.error(String.format("Exception %s", e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (client.isConnected()) {
                            client.logout();
                            client.disconnect();
                        }
                    }
                    catch (Exception e2) {
                        log.error(String.format("Exception %s", e2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (client.isConnected()) {
                        client.logout();
                        client.disconnect();
                    }
                }
                catch (Exception e3) {
                    log.error(String.format("Exception %s", e3.getMessage()));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public static void dropFileFromFtp(String targetFileName, String fcFtpHost, String fcFtpUsername, String fcFtpPassword) {
        block15: {
            FTPClient client;
            block14: {
                log.info(String.format("Dropping FILE %s from %s@%s", targetFileName, fcFtpUsername, fcFtpHost));
                client = new FTPClient();
                client.connect(fcFtpHost);
                client.login(fcFtpUsername, fcFtpPassword);
                if (client.deleteFile(targetFileName)) {
                    log.info(String.format("File %s deleted from %s", targetFileName, fcFtpHost));
                    break block14;
                }
                log.info(String.format("Cannot delete file %s from %s", targetFileName, fcFtpHost));
            }
            try {
                if (client.isConnected()) {
                    client.logout();
                    client.disconnect();
                }
                break block15;
            }
            catch (Exception e) {
                log.error(String.format("Exception %s", e.getMessage()));
            }
            break block15;
            catch (Exception e) {
                try {
                    log.error(String.format("Exception %s", e.getMessage()));
                }
                catch (Throwable throwable) {
                    try {
                        if (client.isConnected()) {
                            client.logout();
                            client.disconnect();
                        }
                    }
                    catch (Exception e2) {
                        log.error(String.format("Exception %s", e2.getMessage()));
                    }
                    throw throwable;
                }
                try {
                    if (client.isConnected()) {
                        client.logout();
                        client.disconnect();
                    }
                }
                catch (Exception e3) {
                    log.error(String.format("Exception %s", e3.getMessage()));
                }
            }
        }
    }

    public static String getUrlContents(String theUrl) {
        log.info(String.format("Getting DATA from %s", theUrl));
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(theUrl);
            URLConnection urlConnection = url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line + "\n");
            }
            bufferedReader.close();
        }
        catch (Exception e) {
            log.error(String.format("Exception getting url content from %s : %s", theUrl, e.getMessage()), (Throwable)e);
        }
        return content.toString();
    }

    public static boolean saveUrlContents(String theUrl, String targetFilePath) {
        log.info(String.format("Downloading DATA from %s to %s", theUrl, targetFilePath));
        StringBuilder content = new StringBuilder();
        try {
            String line;
            URL url = new URL(theUrl);
            URLConnection urlConnection = url.openConnection();
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(urlConnection.getInputStream()));
            while ((line = bufferedReader.readLine()) != null) {
                content.append(line + "\n");
            }
            bufferedReader.close();
            try {
                File file = new File(targetFilePath);
                try (BufferedWriter writer = new BufferedWriter(new FileWriter(file));){
                    writer.append(content.toString());
                    log.info(String.format("Writing content file %s", targetFilePath));
                }
                return true;
            }
            catch (Exception e) {
                log.error(String.format("Exception writing content to file: %s %s", targetFilePath, e.getMessage()), (Throwable)e);
            }
        }
        catch (Exception e) {
            log.error(String.format("Exception saving url content from %s to file %s : %s", theUrl, targetFilePath, e.getMessage()), (Throwable)e);
        }
        return false;
    }
}

