/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.RentalPortfolioMapper;
import cz.airtoy.airshop.domains.renting.RentalPortfolioDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface RentalPortfolioDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\t  p.id,\n\t\tp.uid,\n\t\tp.target_commodity_id,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.cnt,\n\t\tp.deposit_amount,\n\t\tp.ord,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.rental_portfolio p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.rental_portfolio p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  ")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.id = :id")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.id = :id")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.target_commodity_id = :targetCommodityId")
    public long findListByTargetCommodityIdCount(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.target_commodity_id = :targetCommodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.code = :code")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.code = :code")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.cnt = :cnt")
    public long findListByCntCount(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.cnt = :cnt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByCnt(@Bind(value="cnt") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.deposit_amount = :depositAmount")
    public long findListByDepositAmountCount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.deposit_amount = :depositAmount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.note = :note")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.note = :note")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public RentalPortfolioDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.rental_portfolio p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.rental_portfolio p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=RentalPortfolioMapper.class)
    public List<RentalPortfolioDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.rental_portfolio (id, uid, target_commodity_id, abra_id, plu, code, cnt, deposit_amount, ord, date_updated, note, date_created) VALUES (:id, :uid, :targetCommodityId, :abraId, :plu, :code, :cnt, :depositAmount, :ord, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="targetCommodityId") Long var3, @Bind(value="abraId") String var4, @Bind(value="plu") String var5, @Bind(value="code") String var6, @Bind(value="cnt") Integer var7, @Bind(value="depositAmount") Double var8, @Bind(value="ord") Integer var9, @Bind(value="dateUpdated") Date var10, @Bind(value="note") String var11, @Bind(value="dateCreated") Date var12);

    @SqlUpdate(value="INSERT INTO renting.rental_portfolio (target_commodity_id, abra_id, plu, code, cnt, deposit_amount, ord, date_updated, note, date_created) VALUES (:e.targetCommodityId, :e.abraId, :e.plu, :e.code, :e.cnt, :e.depositAmount, :e.ord, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") RentalPortfolioDomain var1);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_commodity_id = :byTargetCommodityId")
    public int updateByTargetCommodityId(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byTargetCommodityId") Long var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE cnt = :byCnt")
    public int updateByCnt(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byCnt") Integer var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE deposit_amount = :byDepositAmount")
    public int updateByDepositAmount(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byDepositAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.rental_portfolio SET id = :e.id, uid = :e.uid, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") RentalPortfolioDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE target_commodity_id = :targetCommodityId")
    public int deleteByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE cnt = :cnt")
    public int deleteByCnt(@Bind(value="cnt") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE deposit_amount = :depositAmount")
    public int deleteByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.rental_portfolio WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

