/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.SalesRequestItemsMapper;
import cz.airtoy.airshop.domains.SalesRequestItemsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SalesRequestItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.sales_request_id,\n\t\tp.status,\n\t\tp.store_id,\n\t\tp.order_id,\n\t\tp.order_items_id,\n\t\tp.plu,\n\t\tp.ean,\n\t\tp.store_cards_id,\n\t\tp.quantity,\n\t\tp.new_quantity,\n\t\tp.date_for,\n\t\tp.date_planned_receive,\n\t\tp.date_received,\n\t\tp.date_finished,\n\t\tp.updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.sales_request_items p\n\t  LEFT OUTER JOIN abra.store_cards sc ON (sc.id = p.store_cards_id)\n\t\n\t\tWHERE \n\t\tsc.name::text ~* :mask \n\tOR \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.sales_request_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.sales_request_items p\n\t  LEFT OUTER JOIN abra.store_cards sc ON (sc.id = p.store_cards_id)\n\t\n\t\tWHERE \n\t\tsc.name::text ~* :mask \n\tOR \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.sales_request_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.sales_request_id,\n\t\tp.status,\n\t\tp.store_id,\n\t\tp.order_id,\n\t\tp.order_items_id,\n\t\tp.plu,\n\t\tp.ean,\n\t\tp.store_cards_id,\n\t\tp.quantity,\n\t\tp.new_quantity,\n\t\tp.date_for,\n\t\tp.date_planned_receive,\n\t\tp.date_received,\n\t\tp.date_finished,\n\t\tp.updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.sales_request_items p\n\t  LEFT OUTER JOIN abra.store_cards sc ON (sc.id = p.store_cards_id)\n\tWHERE \n\t  (CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = p.status END) \n AND \t  (CASE WHEN :salesRequestId = '-1' THEN TRUE ELSE :salesRequestId = p.sales_request_id END) \n AND \t  (CASE WHEN :storeId = '-1' THEN TRUE ELSE :storeId = p.store_id END) \n AND \t(\t\t\tsc.name::text ~* :mask \n\tOR \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.sales_request_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findByMaskSpecial(@Bind(value="status") String var1, @Bind(value="salesRequestId") Long var2, @Bind(value="storeId") Long var3, @Bind(value="mask") String var4, @Bind(value="offset") int var5, @Bind(value="limit") int var6, @Define(value="order") String var7, @Define(value="sort") String var8);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.sales_request_items p\n\t  LEFT OUTER JOIN abra.store_cards sc ON (sc.id = p.store_cards_id)\n\tWHERE \n\t  (CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = p.status END) \n AND \t  (CASE WHEN :salesRequestId = '-1' THEN TRUE ELSE :salesRequestId = p.sales_request_id END) \n AND \t  (CASE WHEN :storeId = '-1' THEN TRUE ELSE :storeId = p.store_id END) \n AND \t(\t\t\tsc.name::text ~* :mask \n\tOR \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.sales_request_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.order_items_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.ean::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.new_quantity::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n ) \n")
    public long findByMaskSpecialCount(@Bind(value="status") String var1, @Bind(value="salesRequestId") Long var2, @Bind(value="storeId") Long var3, @Bind(value="mask") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  ")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.sales_request_id = :salesRequestId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findBySalesRequestId(@Bind(value="salesRequestId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.sales_request_id = :salesRequestId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListBySalesRequestId(@Bind(value="salesRequestId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.sales_request_id = :salesRequestId")
    public long findListBySalesRequestIdCount(@Bind(value="salesRequestId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.sales_request_id = :salesRequestId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListBySalesRequestId(@Bind(value="salesRequestId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.status = :status")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_items_id = :orderItemsId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_items_id = :orderItemsId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.order_items_id = :orderItemsId")
    public long findListByOrderItemsIdCount(@Bind(value="orderItemsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.order_items_id = :orderItemsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByOrderItemsId(@Bind(value="orderItemsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.ean = :ean")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByEan(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.ean = :ean")
    public long findListByEanCount(@Bind(value="ean") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.ean = :ean ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByEan(@Bind(value="ean") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByQuantity(@Bind(value="quantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.new_quantity = :newQuantity")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.new_quantity = :newQuantity")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.new_quantity = :newQuantity")
    public long findListByNewQuantityCount(@Bind(value="newQuantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.new_quantity = :newQuantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByNewQuantity(@Bind(value="newQuantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_for = :dateFor")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByDateFor(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_for = :dateFor")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateFor(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.date_for = :dateFor")
    public long findListByDateForCount(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_for = :dateFor ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateFor(@Bind(value="dateFor") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_planned_receive = :datePlannedReceive")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_planned_receive = :datePlannedReceive")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.date_planned_receive = :datePlannedReceive")
    public long findListByDatePlannedReceiveCount(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_planned_receive = :datePlannedReceive ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.date_received = :dateReceived")
    public long findListByDateReceivedCount(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_received = :dateReceived ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.date_finished = :dateFinished")
    public long findListByDateFinishedCount(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_finished = :dateFinished ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public SalesRequestItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.sales_request_id, p.status, p.store_id, p.order_id, p.order_items_id, p.plu, p.ean, p.store_cards_id, p.quantity, p.new_quantity, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestItemsMapper.class)
    public List<SalesRequestItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.sales_request_items (id, uid, sales_request_id, status, store_id, order_id, order_items_id, plu, ean, store_cards_id, quantity, new_quantity, date_for, date_planned_receive, date_received, date_finished, updated, note, date_created) VALUES (:id, :uid, :salesRequestId, :status, :storeId, :orderId, :orderItemsId, :plu, :ean, :storeCardsId, :quantity, :newQuantity, :dateFor, :datePlannedReceive, :dateReceived, :dateFinished, :updated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="salesRequestId") Long var3, @Bind(value="status") String var4, @Bind(value="storeId") Long var5, @Bind(value="orderId") Long var6, @Bind(value="orderItemsId") Long var7, @Bind(value="plu") String var8, @Bind(value="ean") String var9, @Bind(value="storeCardsId") Long var10, @Bind(value="quantity") Double var11, @Bind(value="newQuantity") Double var12, @Bind(value="dateFor") Date var13, @Bind(value="datePlannedReceive") Date var14, @Bind(value="dateReceived") Date var15, @Bind(value="dateFinished") Date var16, @Bind(value="updated") Date var17, @Bind(value="note") String var18, @Bind(value="dateCreated") Date var19);

    @SqlUpdate(value="INSERT INTO abra.sales_request_items (sales_request_id, status, store_id, order_id, order_items_id, plu, ean, store_cards_id, quantity, new_quantity, date_for, date_planned_receive, date_received, date_finished, updated, note, date_created) VALUES (:e.salesRequestId, :e.status, :e.storeId, :e.orderId, :e.orderItemsId, :e.plu, :e.ean, :e.storeCardsId, :e.quantity, :e.newQuantity, :e.dateFor, :e.datePlannedReceive, :e.dateReceived, :e.dateFinished, :e.updated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SalesRequestItemsDomain var1);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE sales_request_id = :bySalesRequestId")
    public int updateBySalesRequestId(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="bySalesRequestId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE order_items_id = :byOrderItemsId")
    public int updateByOrderItemsId(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byOrderItemsId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE ean = :byEan")
    public int updateByEan(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byQuantity") Double var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE new_quantity = :byNewQuantity")
    public int updateByNewQuantity(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byNewQuantity") Double var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_for = :byDateFor")
    public int updateByDateFor(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byDateFor") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_planned_receive = :byDatePlannedReceive")
    public int updateByDatePlannedReceive(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byDatePlannedReceive") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_received = :byDateReceived")
    public int updateByDateReceived(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byDateReceived") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_finished = :byDateFinished")
    public int updateByDateFinished(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byDateFinished") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request_items SET id = :e.id, uid = :e.uid, sales_request_id = :e.salesRequestId, status = :e.status, store_id = :e.storeId, order_id = :e.orderId, order_items_id = :e.orderItemsId, plu = :e.plu, ean = :e.ean, store_cards_id = :e.storeCardsId, quantity = :e.quantity, new_quantity = :e.newQuantity, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SalesRequestItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE sales_request_id = :salesRequestId")
    public int deleteBySalesRequestId(@Bind(value="salesRequestId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE order_items_id = :orderItemsId")
    public int deleteByOrderItemsId(@Bind(value="orderItemsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE ean = :ean")
    public int deleteByEan(@Bind(value="ean") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Double var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE new_quantity = :newQuantity")
    public int deleteByNewQuantity(@Bind(value="newQuantity") Double var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE date_for = :dateFor")
    public int deleteByDateFor(@Bind(value="dateFor") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE date_planned_receive = :datePlannedReceive")
    public int deleteByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE date_received = :dateReceived")
    public int deleteByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE date_finished = :dateFinished")
    public int deleteByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

