/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.AccessListMapper;
import cz.airtoy.airshop.domains.AccessListDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AccessListDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.type,\n\t\tp.name,\n\t\tp.description,\n\t\tp.allow_ip_address,\n\t\tp.deny_ip_address,\n\t\tp.date_created\n FROM \n\t\tsystem.access_list p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.allow_ip_address::text ~* :mask \n\tOR \n\t\tp.deny_ip_address::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.access_list p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.allow_ip_address::text ~* :mask \n\tOR \n\t\tp.deny_ip_address::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  ")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.id = :id")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.id = :id")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.type = :type")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.type = :type")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.name = :name")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.name = :name")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.description = :description")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.description = :description")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.allow_ip_address = :allowIpAddress")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByAllowIpAddress(@Bind(value="allowIpAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.allow_ip_address = :allowIpAddress")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByAllowIpAddress(@Bind(value="allowIpAddress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.allow_ip_address = :allowIpAddress")
    public long findListByAllowIpAddressCount(@Bind(value="allowIpAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.allow_ip_address = :allowIpAddress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByAllowIpAddress(@Bind(value="allowIpAddress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.deny_ip_address = :denyIpAddress")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByDenyIpAddress(@Bind(value="denyIpAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.deny_ip_address = :denyIpAddress")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDenyIpAddress(@Bind(value="denyIpAddress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.deny_ip_address = :denyIpAddress")
    public long findListByDenyIpAddressCount(@Bind(value="denyIpAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.deny_ip_address = :denyIpAddress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDenyIpAddress(@Bind(value="denyIpAddress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AccessListMapper.class)
    public AccessListDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.access_list p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.name, p.description, p.allow_ip_address, p.deny_ip_address, p.date_created FROM system.access_list p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AccessListMapper.class)
    public List<AccessListDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.access_list (id, uid, type, name, description, allow_ip_address, deny_ip_address, date_created) VALUES (:id, :uid, :type, :name, :description, :allowIpAddress, :denyIpAddress, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="type") String var3, @Bind(value="name") String var4, @Bind(value="description") String var5, @Bind(value="allowIpAddress") String var6, @Bind(value="denyIpAddress") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO system.access_list (type, name, description, allow_ip_address, deny_ip_address, date_created) VALUES (:e.type, :e.name, :e.description, :e.allowIpAddress, :e.denyIpAddress, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") AccessListDomain var1);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") AccessListDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") AccessListDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") AccessListDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") AccessListDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") AccessListDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE allow_ip_address = :byAllowIpAddress")
    public int updateByAllowIpAddress(@BindBean(value="e") AccessListDomain var1, @Bind(value="byAllowIpAddress") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE deny_ip_address = :byDenyIpAddress")
    public int updateByDenyIpAddress(@BindBean(value="e") AccessListDomain var1, @Bind(value="byDenyIpAddress") String var2);

    @SqlUpdate(value="UPDATE system.access_list SET id = :e.id, uid = :e.uid, type = :e.type, name = :e.name, description = :e.description, allow_ip_address = :e.allowIpAddress, deny_ip_address = :e.denyIpAddress, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") AccessListDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE allow_ip_address = :allowIpAddress")
    public int deleteByAllowIpAddress(@Bind(value="allowIpAddress") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE deny_ip_address = :denyIpAddress")
    public int deleteByDenyIpAddress(@Bind(value="denyIpAddress") String var1);

    @SqlUpdate(value="DELETE FROM system.access_list WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

