/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.AbraCallsMapper;
import cz.airtoy.airshop.domains.AbraCallsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AbraCallsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.method,\n\t\tp.path,\n\t\tp.uri,\n\t\tp.remote_address,\n\t\tp.headers,\n\t\tp.body,\n\t\tp.abra_id,\n\t\tp.payload,\n\t\tp.object,\n\t\tp.object_id,\n\t\tp.type,\n\t\tp.eb_addr,\n\t\tp.attempts,\n\t\tp.date_received,\n\t\tp.date_repeat,\n\t\tp.date_processed,\n\t\tp.date_confirmed,\n\t\tp.date_created,\n\t\tp.progress\n FROM \n\t\tabra.abra_calls p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.method::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.uri::text ~* :mask \n\tOR \n\t\tp.remote_address::text ~* :mask \n\tOR \n\t\tp.headers::text ~* :mask \n\tOR \n\t\tp.body::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.payload::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.eb_addr::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_repeat::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_confirmed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.progress::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.abra_calls p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.method::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.uri::text ~* :mask \n\tOR \n\t\tp.remote_address::text ~* :mask \n\tOR \n\t\tp.headers::text ~* :mask \n\tOR \n\t\tp.body::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.payload::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.eb_addr::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_repeat::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_confirmed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.progress::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.id = :id")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.id = :id")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.method = :method AND p.uri = :uri AND p.remote_address LIKE :remoteAddress AND p.headers LIKE :headers AND p.date_created >= NOW() - interval '1m' ORDER BY p.id ASC LIMIT 1")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByMethodUriRemoteAddressLikeHeadersLikeLast(@Bind(value="method") String var1, @Bind(value="uri") String var2, @Bind(value="remoteAddress") String var3, @Bind(value="headers") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.method = :method AND p.uri = :uri AND p.remote_address LIKE :remoteAddress AND p.date_created >= NOW() - interval '1m' ORDER BY p.id ASC LIMIT 1")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByMethodUriRemoteAddressLikeLast(@Bind(value="method") String var1, @Bind(value="uri") String var2, @Bind(value="remoteAddress") String var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.body IS NULL AND p.method = :method AND p.uri = :uri AND p.remote_address LIKE :remoteAddress AND p.headers LIKE :headerLike AND p.date_created >= NOW() - interval '10m' ORDER BY p.id ASC LIMIT 1")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByBodyIsNullMethodUriRemoteAddressLikeHeaderLikeLast10min(@Bind(value="method") String var1, @Bind(value="uri") String var2, @Bind(value="remoteAddress") String var3, @Bind(value="headerLike") String var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.method = :method")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByMethod(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.method = :method")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByMethod(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.method = :method")
    public long findListByMethodCount(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.method = :method ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByMethod(@Bind(value="method") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.path = :path")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.path = :path")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uri = :uri")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByUri(@Bind(value="uri") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uri = :uri")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByUri(@Bind(value="uri") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.uri = :uri")
    public long findListByUriCount(@Bind(value="uri") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.uri = :uri ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByUri(@Bind(value="uri") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.remote_address = :remoteAddress")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByRemoteAddress(@Bind(value="remoteAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.remote_address = :remoteAddress")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByRemoteAddress(@Bind(value="remoteAddress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.remote_address = :remoteAddress")
    public long findListByRemoteAddressCount(@Bind(value="remoteAddress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.remote_address = :remoteAddress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByRemoteAddress(@Bind(value="remoteAddress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.headers = :headers")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByHeaders(@Bind(value="headers") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.headers = :headers")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByHeaders(@Bind(value="headers") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.headers = :headers")
    public long findListByHeadersCount(@Bind(value="headers") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.headers = :headers ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByHeaders(@Bind(value="headers") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.body = :body")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByBody(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.body = :body")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByBody(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.body = :body")
    public long findListByBodyCount(@Bind(value="body") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.body = :body ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByBody(@Bind(value="body") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.payload = :payload")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByPayload(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.payload = :payload")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByPayload(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.payload = :payload")
    public long findListByPayloadCount(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.payload = :payload ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByPayload(@Bind(value="payload") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object = :object")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object = :object")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.object = :object")
    public long findListByObjectCount(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object = :object ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByObject(@Bind(value="object") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.object_id = :objectId")
    public long findListByObjectIdCount(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.object_id = :objectId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByObjectId(@Bind(value="objectId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.type = :type")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.type = :type")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.eb_addr = :ebAddr")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.eb_addr = :ebAddr")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.eb_addr = :ebAddr")
    public long findListByEbAddrCount(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.eb_addr = :ebAddr ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByEbAddr(@Bind(value="ebAddr") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.attempts = :attempts")
    public long findListByAttemptsCount(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.attempts = :attempts ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByAttempts(@Bind(value="attempts") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.date_received = :dateReceived")
    public long findListByDateReceivedCount(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_received = :dateReceived ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_repeat = :dateRepeat")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_repeat = :dateRepeat")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.date_repeat = :dateRepeat")
    public long findListByDateRepeatCount(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_repeat = :dateRepeat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateRepeat(@Bind(value="dateRepeat") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.date_processed = :dateProcessed")
    public long findListByDateProcessedCount(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_processed = :dateProcessed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_confirmed = :dateConfirmed")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_confirmed = :dateConfirmed")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.date_confirmed = :dateConfirmed")
    public long findListByDateConfirmedCount(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_confirmed = :dateConfirmed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateConfirmed(@Bind(value="dateConfirmed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.progress = :progress")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public AbraCallsDomain findByProgress(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.progress = :progress")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByProgress(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_calls p  WHERE p.progress = :progress")
    public long findListByProgressCount(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.method, p.path, p.uri, p.remote_address, p.headers, p.body, p.abra_id, p.payload, p.object, p.object_id, p.type, p.eb_addr, p.attempts, p.date_received, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress FROM abra.abra_calls p  WHERE p.progress = :progress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCallsMapper.class)
    public List<AbraCallsDomain> findListByProgress(@Bind(value="progress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.abra_calls (id, uid, method, path, uri, remote_address, headers, body, abra_id, payload, object, object_id, type, eb_addr, attempts, date_received, date_repeat, date_processed, date_confirmed, date_created, progress) VALUES (:id, :uid, :method, :path, :uri, :remoteAddress, :headers, :body, :abraId, :payload, :object, :objectId, :type, :ebAddr, :attempts, :dateReceived, :dateRepeat, :dateProcessed, :dateConfirmed, :dateCreated, :progress)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="method") String var3, @Bind(value="path") String var4, @Bind(value="uri") String var5, @Bind(value="remoteAddress") String var6, @Bind(value="headers") String var7, @Bind(value="body") String var8, @Bind(value="abraId") String var9, @Bind(value="payload") String var10, @Bind(value="object") String var11, @Bind(value="objectId") Long var12, @Bind(value="type") String var13, @Bind(value="ebAddr") String var14, @Bind(value="attempts") Integer var15, @Bind(value="dateReceived") Date var16, @Bind(value="dateRepeat") Date var17, @Bind(value="dateProcessed") Date var18, @Bind(value="dateConfirmed") Date var19, @Bind(value="dateCreated") Date var20, @Bind(value="progress") String var21);

    @SqlUpdate(value="INSERT INTO abra.abra_calls (method, path, uri, remote_address, headers, body, abra_id, payload, object, object_id, type, eb_addr, attempts, date_received, date_repeat, date_processed, date_confirmed, date_created, progress) VALUES (:e.method, :e.path, :e.uri, :e.remoteAddress, :e.headers, :e.body, :e.abraId, :e.payload, :e.object, :e.objectId, :e.type, :e.ebAddr, :e.attempts, :e.dateReceived, :e.dateRepeat, :e.dateProcessed, :e.dateConfirmed, :e.dateCreated, :e.progress)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") AbraCallsDomain var1);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE id = :byId")
    public int updateById(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE method = :byMethod")
    public int updateByMethod(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byMethod") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE uri = :byUri")
    public int updateByUri(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byUri") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE remote_address = :byRemoteAddress")
    public int updateByRemoteAddress(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byRemoteAddress") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE headers = :byHeaders")
    public int updateByHeaders(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byHeaders") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE body = :byBody")
    public int updateByBody(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byBody") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE payload = :byPayload")
    public int updateByPayload(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byPayload") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE object = :byObject")
    public int updateByObject(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byObject") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE object_id = :byObjectId")
    public int updateByObjectId(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byObjectId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE type = :byType")
    public int updateByType(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE eb_addr = :byEbAddr")
    public int updateByEbAddr(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byEbAddr") String var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE attempts = :byAttempts")
    public int updateByAttempts(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byAttempts") Integer var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE date_received = :byDateReceived")
    public int updateByDateReceived(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byDateReceived") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE date_repeat = :byDateRepeat")
    public int updateByDateRepeat(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byDateRepeat") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE date_processed = :byDateProcessed")
    public int updateByDateProcessed(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byDateProcessed") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE date_confirmed = :byDateConfirmed")
    public int updateByDateConfirmed(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byDateConfirmed") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_calls SET id = :e.id, uid = :e.uid, method = :e.method, path = :e.path, uri = :e.uri, remote_address = :e.remoteAddress, headers = :e.headers, body = :e.body, abra_id = :e.abraId, payload = :e.payload, object = :e.object, object_id = :e.objectId, type = :e.type, eb_addr = :e.ebAddr, attempts = :e.attempts, date_received = :e.dateReceived, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress WHERE progress = :byProgress")
    public int updateByProgress(@BindBean(value="e") AbraCallsDomain var1, @Bind(value="byProgress") String var2);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE method = :method")
    public int deleteByMethod(@Bind(value="method") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE uri = :uri")
    public int deleteByUri(@Bind(value="uri") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE remote_address = :remoteAddress")
    public int deleteByRemoteAddress(@Bind(value="remoteAddress") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE headers = :headers")
    public int deleteByHeaders(@Bind(value="headers") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE body = :body")
    public int deleteByBody(@Bind(value="body") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE payload = :payload")
    public int deleteByPayload(@Bind(value="payload") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE object = :object")
    public int deleteByObject(@Bind(value="object") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE object_id = :objectId")
    public int deleteByObjectId(@Bind(value="objectId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE eb_addr = :ebAddr")
    public int deleteByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE attempts = :attempts")
    public int deleteByAttempts(@Bind(value="attempts") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE date_received = :dateReceived")
    public int deleteByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE date_repeat = :dateRepeat")
    public int deleteByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE date_processed = :dateProcessed")
    public int deleteByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE date_confirmed = :dateConfirmed")
    public int deleteByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_calls WHERE progress = :progress")
    public int deleteByProgress(@Bind(value="progress") String var1);
}

