/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import cz.airtoy.airshop.utils.domains.KeycloakAuthResult;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.auth.User;
import io.vertx.ext.auth.oauth2.KeycloakHelper;
import io.vertx.ext.auth.oauth2.impl.OAuth2TokenImpl;
import io.vertx.ext.web.RoutingContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeycloakAuthUtils {
    private static final Logger log = LoggerFactory.getLogger(KeycloakAuthUtils.class);

    public static KeycloakAuthResult auth(RoutingContext context, User user) {
        String accessToken;
        KeycloakAuthResult result = new KeycloakAuthResult();
        if (user != null) {
            if (user instanceof OAuth2TokenImpl) {
                JsonObject token;
                OAuth2TokenImpl theUser = (OAuth2TokenImpl)user;
                log.info(String.format("found %s", theUser.principal().toString()));
                String accessToken2 = KeycloakHelper.rawAccessToken((JsonObject)theUser.principal());
                if (accessToken2 != null && (token = KeycloakHelper.parseToken((String)accessToken2)) != null) {
                    result = new KeycloakAuthResult(token);
                }
            } else {
                log.warn(String.format("User not OAuth2TokenImpl %s", user.getClass().toString()));
            }
        }
        if (!result.isAuthorized() && context.user() != null && context.user().principal() != null && (accessToken = KeycloakHelper.rawAccessToken((JsonObject)context.user().principal())) != null) {
            JsonObject token = KeycloakHelper.parseToken((String)accessToken);
            result = new KeycloakAuthResult(token);
        }
        return result;
    }

    public static KeycloakAuthResult auth(User user) {
        KeycloakAuthResult result = new KeycloakAuthResult();
        if (user != null) {
            if (user instanceof OAuth2TokenImpl) {
                JsonObject token;
                OAuth2TokenImpl theUser = (OAuth2TokenImpl)user;
                log.info(String.format("found %s", theUser.principal().toString()));
                String accessToken = KeycloakHelper.rawAccessToken((JsonObject)theUser.principal());
                if (accessToken != null && (token = KeycloakHelper.parseToken((String)accessToken)) != null) {
                    result = new KeycloakAuthResult(token);
                }
            } else {
                log.warn(String.format("User not OAuth2TokenImpl %s", user.getClass().toString()));
            }
        }
        return result;
    }

    public static KeycloakAuthResult auth(RoutingContext context) {
        String accessToken;
        KeycloakAuthResult result = new KeycloakAuthResult();
        if (context.user() != null && context.user().principal() != null && (accessToken = KeycloakHelper.rawAccessToken((JsonObject)context.user().principal())) != null) {
            JsonObject token = KeycloakHelper.parseToken((String)accessToken);
            result = new KeycloakAuthResult(token);
        }
        return result;
    }
}

