/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cz.airtoy.airshop.domains.FirmsDomain;
import cz.airtoy.airshop.domains.OrderItemsDomain;
import cz.airtoy.airshop.domains.OrdersDomain;
import cz.airtoy.airshop.integration.FirmsIntegration;
import cz.airtoy.airshop.integration.OrderItemsIntegration;
import cz.airtoy.airshop.integration.common.BaseIntegration;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrdersIntegration
extends BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(OrdersIntegration.class);

    public static OrdersDomain convert(JsonObject data) {
        JsonArray rowsAsJsonArray;
        OrdersDomain d = new OrdersDomain();
        d.setAbraId(OrdersIntegration.getAsString(data, "id"));
        d.setAccountingtype(OrdersIntegration.getAsInt(data, "accountingtype"));
        d.setAddressId(OrdersIntegration.getAsString(data, "address_id"));
        d.setAmount(OrdersIntegration.getAsDouble(data, "amount"));
        d.setAmountwithoutvat(OrdersIntegration.getAsDouble(data, "amountwithoutvat"));
        d.setBankaccountId(OrdersIntegration.getAsString(data, "bankaccount_id"));
        d.setCapacity(OrdersIntegration.getAsDouble(data, "capacity"));
        d.setCapacityunit(OrdersIntegration.getAsInt(data, "capacityunit"));
        d.setClassid(OrdersIntegration.getAsString(data, "classid"));
        d.setClosed(OrdersIntegration.getAsBoolean(data, "closed"));
        d.setCoef(OrdersIntegration.getAsInt(data, "coef"));
        d.setConfirmed(OrdersIntegration.getAsBoolean(data, "confirmed"));
        d.setConstsymbolId(OrdersIntegration.getAsString(data, "constsymbol_id"));
        d.setDateCorrectedat(OrdersIntegration.getAsTimestamp(data, "correctedat$date"));
        d.setCorrectedbyId(OrdersIntegration.getAsString(data, "correctedby_id"));
        d.setCountryId(OrdersIntegration.getAsString(data, "country_id"));
        d.setDateCreatedat(OrdersIntegration.getAsTimestamp(data, "createdat$date"));
        d.setCreatedbyId(OrdersIntegration.getAsString(data, "createdby_id"));
        d.setCurrencyId(OrdersIntegration.getAsString(data, "currency_id"));
        d.setCurrrate(OrdersIntegration.getAsDouble(data, "currrate"));
        d.setCurrrateinfo(OrdersIntegration.getAsString(data, "currrateinfo"));
        d.setDealercategoryId(OrdersIntegration.getAsString(data, "dealercategory_id"));
        d.setDealerdiscount(OrdersIntegration.getAsInt(data, "dealerdiscount"));
        d.setDealerdiscountkind(OrdersIntegration.getAsInt(data, "dealerdiscountkind"));
        d.setDescription(OrdersIntegration.getAsString(data, "description"));
        d.setDirty(OrdersIntegration.getAsBoolean(data, "dirty"));
        d.setDiscountcalckind(OrdersIntegration.getAsInt(data, "discountcalckind"));
        d.setDisplayname(OrdersIntegration.getAsString(data, "displayname"));
        d.setDateDocdate(OrdersIntegration.getAsTimestamp(data, "docdate$date"));
        d.setDocqueueId(OrdersIntegration.getAsString(data, "docqueue_id"));
        d.setDocumentdiscount(OrdersIntegration.getAsInt(data, "documentdiscount"));
        d.setDonotrecalculateunitprice(OrdersIntegration.getAsBoolean(data, "donotrecalculateunitprice"));
        d.setExternalnumber(OrdersIntegration.getAsString(data, "externalnumber"));
        d.setFinancialdiscount(OrdersIntegration.getAsInt(data, "financialdiscount"));
        d.setFirmId(OrdersIntegration.getAsString(data, "firm_id"));
        d.setFirmofficeId(OrdersIntegration.getAsString(data, "firmoffice_id"));
        d.setFrozendiscounts(OrdersIntegration.getAsBoolean(data, "frozendiscounts"));
        d.setIntrastatdeliverytermId(OrdersIntegration.getAsString(data, "intrastatdeliveryterm_id"));
        d.setIntrastattransactiontypeId(OrdersIntegration.getAsString(data, "intrastattransactiontype_id"));
        d.setIntrastattransportationtypeId(OrdersIntegration.getAsString(data, "intrastattransportationtype_id"));
        d.setIsaccounted(OrdersIntegration.getAsBoolean(data, "isaccounted"));
        d.setIsaccountedlatervat(OrdersIntegration.getAsBoolean(data, "isaccountedlatervat"));
        d.setIsavailablefordelivery(OrdersIntegration.getAsBoolean(data, "isavailablefordelivery"));
        d.setIsfinancialdiscount(OrdersIntegration.getAsBoolean(data, "isfinancialdiscount"));
        d.setIsreversechargedeclared(OrdersIntegration.getAsBoolean(data, "isreversechargedeclared"));
        d.setIsrowdiscount(OrdersIntegration.getAsBoolean(data, "isrowdiscount"));
        d.setLocalamount(OrdersIntegration.getAsDouble(data, "localamount"));
        d.setLocalamountwithoutvat(OrdersIntegration.getAsDouble(data, "localamountwithoutvat"));
        d.setLocalcoef(OrdersIntegration.getAsInt(data, "localcoef"));
        d.setLocalrefcurrencyId(OrdersIntegration.getAsString(data, "localrefcurrency_id"));
        d.setLocalroundingamount(OrdersIntegration.getAsDouble(data, "localroundingamount"));
        d.setLocalvatamount(OrdersIntegration.getAsDouble(data, "localvatamount"));
        d.setLocalzoneId(OrdersIntegration.getAsString(data, "localzone_id"));
        d.setMargin(OrdersIntegration.getAsDouble(data, "margin"));
        d.setNewrelateddocumentId(OrdersIntegration.getAsString(data, "newrelateddocument_id"));
        d.setNewrelatedtype(OrdersIntegration.getAsInt(data, "newrelatedtype"));
        d.setObjversion(OrdersIntegration.getAsInt(data, "objversion"));
        d.setOnlywholeorder(OrdersIntegration.getAsBoolean(data, "onlywholeorder"));
        d.setOrdnumber(OrdersIntegration.getAsInt(data, "ordnumber"));
        d.setPaymenttypeId(OrdersIntegration.getAsString(data, "paymenttype_id"));
        d.setPeriodId(OrdersIntegration.getAsString(data, "period_id"));
        d.setPersonId(OrdersIntegration.getAsString(data, "person_id"));
        d.setPriceprecision(OrdersIntegration.getAsInt(data, "priceprecision"));
        d.setPricesbyref(OrdersIntegration.getAsBoolean(data, "pricesbyref"));
        d.setPriceswithvat(OrdersIntegration.getAsBoolean(data, "priceswithvat"));
        d.setQuantitydiscountkind(OrdersIntegration.getAsInt(data, "quantitydiscountkind"));
        d.setRefcurrencyId(OrdersIntegration.getAsString(data, "refcurrency_id"));
        d.setRefcurrrate(OrdersIntegration.getAsInt(data, "refcurrrate"));
        d.setRevidedId(OrdersIntegration.getAsString(data, "revided_id"));
        d.setRevision(OrdersIntegration.getAsInt(data, "revision"));
        d.setRevisionauthorId(OrdersIntegration.getAsString(data, "revisionauthor_id"));
        d.setDateRevisiondate(OrdersIntegration.getAsTimestamp(data, "revisiondate$date"));
        d.setRevisiondescription(OrdersIntegration.getAsString(data, "revisiondescription"));
        d.setRoundingamount(OrdersIntegration.getAsDouble(data, "roundingamount"));
        d.setStoreprice(OrdersIntegration.getAsDouble(data, "storeprice"));
        d.setTotaldiscountamount(OrdersIntegration.getAsDouble(data, "totaldiscountamount"));
        d.setTotalrounding(OrdersIntegration.getAsInt(data, "totalrounding"));
        d.setTradetype(OrdersIntegration.getAsInt(data, "tradetype"));
        d.setTradetypedescription(OrdersIntegration.getAsString(data, "tradetypedescription"));
        d.setTransportationtypeId(OrdersIntegration.getAsString(data, "transportationtype_id"));
        d.setVatamount(OrdersIntegration.getAsDouble(data, "vatamount"));
        d.setVatcountryId(OrdersIntegration.getAsString(data, "vatcountry_id"));
        d.setVatdocument(OrdersIntegration.getAsBoolean(data, "vatdocument"));
        d.setVatfromaboveprecision(OrdersIntegration.getAsInt(data, "vatfromaboveprecision"));
        d.setVatfromabovetype(OrdersIntegration.getAsInt(data, "vatfromabovetype"));
        d.setVatrounding(OrdersIntegration.getAsInt(data, "vatrounding"));
        d.setWeight(OrdersIntegration.getAsDouble(data, "weight"));
        d.setWeightunit(OrdersIntegration.getAsInt(data, "weightunit"));
        d.setAbraAddress1Id(OrdersIntegration.getAsString(data, "x_address1_id"));
        d.setAbraAddress2Id(OrdersIntegration.getAsString(data, "x_address2_id"));
        d.setAbraContacted(OrdersIntegration.getAsBoolean(data, "x_contacted"));
        d.setAbraEndeddate(OrdersIntegration.getAsTimestamp(data, "x_endeddate"));
        d.setAbraParams(OrdersIntegration.getAsString(data, "x_params"));
        d.setAbraPdBbBranches(OrdersIntegration.getAsString(data, "x_pd_bb_branches"));
        d.setAbraPdBbModul(OrdersIntegration.getAsString(data, "x_pd_bb_modul"));
        d.setAbraPdBbServices(OrdersIntegration.getAsString(data, "x_pd_bb_services"));
        d.setAbraPdStatus(OrdersIntegration.getAsInt(data, "x_pd_status"));
        d.setAbraStavObjednavkyId(OrdersIntegration.getAsString(data, "x_stav_objednavky_id"));
        d.setAbraStorno(OrdersIntegration.getAsBoolean(data, "x_storno"));
        d.setAbraUlozNazevPobocky(OrdersIntegration.getAsString(data, "x_uloz_nazev_pobocky"));
        d.setAbraUlozPobocka(OrdersIntegration.getAsString(data, "x_uloz_pobocka"));
        d.setAbraUlozPrepravniSluzba(OrdersIntegration.getAsString(data, "x_uloz_prepravni_sluzba"));
        d.setZoneId(OrdersIntegration.getAsString(data, "zone_id"));
        d.setPmstateId(OrdersIntegration.getAsString(data, "pmstate_id"));
        d.setResponsibleuserId(OrdersIntegration.getAsString(data, "responsibleuser_id"));
        d.setResponsibleroleId(OrdersIntegration.getAsString(data, "responsiblerole_id"));
        d.setAbraZasilkPobocka(OrdersIntegration.getAsString(data, "x_zasilk_pobocka"));
        d.setAbraZasilkAdresaPobocky(OrdersIntegration.getAsString(data, "x_zasilk_adresa_pobocky"));
        d.setAbraEmailSent(OrdersIntegration.getAsBoolean(data, "x_email_sent") != false ? "A" : "N");
        d.setAbraPaid(OrdersIntegration.getAsBoolean(data, "x_paid") != false ? "A" : "N");
        d.setAbraPaiddate(OrdersIntegration.getAsTimestamp(data, "x_paiddate"));
        d.setSource(OrdersIntegration.getAsString(data, "source"));
        d.setAbraBillOfDeliveryId(OrdersIntegration.getAsString(data, "x_billofdelivery_id"));
        d.setRows(new ArrayList<OrderItemsDomain>());
        JsonElement rows = data.get("rows");
        if (rows != null && (rowsAsJsonArray = rows.getAsJsonArray()) != null) {
            for (JsonElement jsonElement : rowsAsJsonArray) {
                JsonObject obj = jsonElement.getAsJsonObject();
                d.getRows().add(OrderItemsIntegration.convert(obj));
            }
        }
        return d;
    }

    public static OrdersDomain convertComplete(JsonObject data) {
        JsonArray rowsAsJsonArray;
        OrdersDomain d = new OrdersDomain();
        d.setAbraId(OrdersIntegration.getAsString(data, "id"));
        d.setAccountingtype(OrdersIntegration.getAsInt(data, "accountingtype"));
        try {
            d.setAddressId(OrdersIntegration.getAsString(data, "address_id"));
        }
        catch (Exception e) {
            d.setAddressId(OrdersIntegration.getAsString(data, "address_id"));
        }
        d.setAmount(OrdersIntegration.getAsDouble(data, "amount"));
        d.setAmountwithoutvat(OrdersIntegration.getAsDouble(data, "amountwithoutvat"));
        d.setBankaccountId(OrdersIntegration.getAsString(data, "bankaccount_id"));
        d.setCapacity(OrdersIntegration.getAsDouble(data, "capacity"));
        d.setCapacityunit(OrdersIntegration.getAsInt(data, "capacityunit"));
        d.setClassid(OrdersIntegration.getAsString(data, "classid"));
        d.setClosed(OrdersIntegration.getAsBoolean(data, "closed"));
        d.setCoef(OrdersIntegration.getAsInt(data, "coef"));
        d.setConfirmed(OrdersIntegration.getAsBoolean(data, "confirmed"));
        d.setConstsymbolId(OrdersIntegration.getAsString(data, "constsymbol_id"));
        d.setDateCorrectedat(OrdersIntegration.getAsTimestamp(data, "correctedat$date"));
        d.setCorrectedbyId(OrdersIntegration.getAsString(data, "correctedby_id"));
        d.setCountryId(OrdersIntegration.getAsString(data, "country_id"));
        d.setDateCreatedat(OrdersIntegration.getAsTimestamp(data, "createdat$date"));
        d.setCreatedbyId(OrdersIntegration.getAsString(data, "createdby_id"));
        d.setCurrencyId(OrdersIntegration.getAsString(data, "currency_id"));
        d.setCurrrate(OrdersIntegration.getAsDouble(data, "currrate"));
        d.setCurrrateinfo(OrdersIntegration.getAsString(data, "currrateinfo"));
        d.setDealercategoryId(OrdersIntegration.getAsString(data, "dealercategory_id"));
        d.setDealerdiscount(OrdersIntegration.getAsInt(data, "dealerdiscount"));
        d.setDealerdiscountkind(OrdersIntegration.getAsInt(data, "dealerdiscountkind"));
        d.setDescription(OrdersIntegration.getAsString(data, "description"));
        d.setDirty(OrdersIntegration.getAsBoolean(data, "dirty"));
        d.setDiscountcalckind(OrdersIntegration.getAsInt(data, "discountcalckind"));
        d.setDisplayname(OrdersIntegration.getAsString(data, "displayname"));
        d.setDateDocdate(OrdersIntegration.getAsTimestamp(data, "docdate$date"));
        d.setDocqueueId(OrdersIntegration.getAsString(data, "docqueue_id"));
        d.setDocumentdiscount(OrdersIntegration.getAsInt(data, "documentdiscount"));
        d.setDonotrecalculateunitprice(OrdersIntegration.getAsBoolean(data, "donotrecalculateunitprice"));
        d.setExternalnumber(OrdersIntegration.getAsString(data, "externalnumber"));
        d.setFinancialdiscount(OrdersIntegration.getAsInt(data, "financialdiscount"));
        try {
            d.setFirmId(OrdersIntegration.getAsString(data, "firm_id"));
            FirmsDomain firmId = FirmsIntegration.convertFromOrder("firm_id", data);
            d.setFirm(firmId);
        }
        catch (Exception e) {
            d.setFirmId(OrdersIntegration.getAsString(data, "firm_id"));
        }
        d.setFirmofficeId(OrdersIntegration.getAsString(data, "firmoffice_id"));
        d.setFrozendiscounts(OrdersIntegration.getAsBoolean(data, "frozendiscounts"));
        d.setIntrastatdeliverytermId(OrdersIntegration.getAsString(data, "intrastatdeliveryterm_id"));
        d.setIntrastattransactiontypeId(OrdersIntegration.getAsString(data, "intrastattransactiontype_id"));
        d.setIntrastattransportationtypeId(OrdersIntegration.getAsString(data, "intrastattransportationtype_id"));
        d.setIsaccounted(OrdersIntegration.getAsBoolean(data, "isaccounted"));
        d.setIsaccountedlatervat(OrdersIntegration.getAsBoolean(data, "isaccountedlatervat"));
        d.setIsavailablefordelivery(OrdersIntegration.getAsBoolean(data, "isavailablefordelivery"));
        d.setIsfinancialdiscount(OrdersIntegration.getAsBoolean(data, "isfinancialdiscount"));
        d.setIsreversechargedeclared(OrdersIntegration.getAsBoolean(data, "isreversechargedeclared"));
        d.setIsrowdiscount(OrdersIntegration.getAsBoolean(data, "isrowdiscount"));
        d.setLocalamount(OrdersIntegration.getAsDouble(data, "localamount"));
        d.setLocalamountwithoutvat(OrdersIntegration.getAsDouble(data, "localamountwithoutvat"));
        d.setLocalcoef(OrdersIntegration.getAsInt(data, "localcoef"));
        d.setLocalrefcurrencyId(OrdersIntegration.getAsString(data, "localrefcurrency_id"));
        d.setLocalroundingamount(OrdersIntegration.getAsDouble(data, "localroundingamount"));
        d.setLocalvatamount(OrdersIntegration.getAsDouble(data, "localvatamount"));
        d.setLocalzoneId(OrdersIntegration.getAsString(data, "localzone_id"));
        d.setMargin(OrdersIntegration.getAsDouble(data, "margin"));
        d.setNewrelateddocumentId(OrdersIntegration.getAsString(data, "newrelateddocument_id"));
        d.setNewrelatedtype(OrdersIntegration.getAsInt(data, "newrelatedtype"));
        d.setObjversion(OrdersIntegration.getAsInt(data, "objversion"));
        d.setOnlywholeorder(OrdersIntegration.getAsBoolean(data, "onlywholeorder"));
        d.setOrdnumber(OrdersIntegration.getAsInt(data, "ordnumber"));
        d.setPaymenttypeId(OrdersIntegration.getAsString(data, "paymenttype_id"));
        d.setPeriodId(OrdersIntegration.getAsString(data, "period_id"));
        d.setPersonId(OrdersIntegration.getAsString(data, "person_id"));
        d.setPriceprecision(OrdersIntegration.getAsInt(data, "priceprecision"));
        d.setPricesbyref(OrdersIntegration.getAsBoolean(data, "pricesbyref"));
        d.setPriceswithvat(OrdersIntegration.getAsBoolean(data, "priceswithvat"));
        d.setQuantitydiscountkind(OrdersIntegration.getAsInt(data, "quantitydiscountkind"));
        d.setRefcurrencyId(OrdersIntegration.getAsString(data, "refcurrency_id"));
        d.setRefcurrrate(OrdersIntegration.getAsInt(data, "refcurrrate"));
        d.setRevidedId(OrdersIntegration.getAsString(data, "revided_id"));
        d.setRevision(OrdersIntegration.getAsInt(data, "revision"));
        d.setRevisionauthorId(OrdersIntegration.getAsString(data, "revisionauthor_id"));
        d.setDateRevisiondate(OrdersIntegration.getAsTimestamp(data, "revisiondate$date"));
        d.setRevisiondescription(OrdersIntegration.getAsString(data, "revisiondescription"));
        d.setRoundingamount(OrdersIntegration.getAsDouble(data, "roundingamount"));
        d.setStoreprice(OrdersIntegration.getAsDouble(data, "storeprice"));
        d.setTotaldiscountamount(OrdersIntegration.getAsDouble(data, "totaldiscountamount"));
        d.setTotalrounding(OrdersIntegration.getAsInt(data, "totalrounding"));
        d.setTradetype(OrdersIntegration.getAsInt(data, "tradetype"));
        d.setTradetypedescription(OrdersIntegration.getAsString(data, "tradetypedescription"));
        d.setTransportationtypeId(OrdersIntegration.getAsString(data, "transportationtype_id"));
        d.setVatamount(OrdersIntegration.getAsDouble(data, "vatamount"));
        d.setVatcountryId(OrdersIntegration.getAsString(data, "vatcountry_id"));
        d.setVatdocument(OrdersIntegration.getAsBoolean(data, "vatdocument"));
        d.setVatfromaboveprecision(OrdersIntegration.getAsInt(data, "vatfromaboveprecision"));
        d.setVatfromabovetype(OrdersIntegration.getAsInt(data, "vatfromabovetype"));
        d.setVatrounding(OrdersIntegration.getAsInt(data, "vatrounding"));
        d.setWeight(OrdersIntegration.getAsDouble(data, "weight"));
        d.setWeightunit(OrdersIntegration.getAsInt(data, "weightunit"));
        d.setAbraAddress1Id(OrdersIntegration.getAsString(data, "x_address1_id"));
        d.setAbraAddress2Id(OrdersIntegration.getAsString(data, "x_address2_id"));
        d.setAbraContacted(OrdersIntegration.getAsBoolean(data, "x_contacted"));
        d.setAbraEndeddate(OrdersIntegration.getAsTimestamp(data, "x_endeddate"));
        d.setAbraParams(OrdersIntegration.getAsString(data, "x_params"));
        d.setAbraPdBbBranches(OrdersIntegration.getAsString(data, "x_pd_bb_branches"));
        d.setAbraPdBbModul(OrdersIntegration.getAsString(data, "x_pd_bb_modul"));
        d.setAbraPdBbServices(OrdersIntegration.getAsString(data, "x_pd_bb_services"));
        d.setAbraPdStatus(OrdersIntegration.getAsInt(data, "x_pd_status"));
        d.setAbraStavObjednavkyId(OrdersIntegration.getAsString(data, "x_stav_objednavky_id"));
        d.setAbraStorno(OrdersIntegration.getAsBoolean(data, "x_storno"));
        d.setAbraUlozNazevPobocky(OrdersIntegration.getAsString(data, "x_uloz_nazev_pobocky"));
        d.setAbraUlozPobocka(OrdersIntegration.getAsString(data, "x_uloz_pobocka"));
        d.setAbraUlozPrepravniSluzba(OrdersIntegration.getAsString(data, "x_uloz_prepravni_sluzba"));
        d.setZoneId(OrdersIntegration.getAsString(data, "zone_id"));
        d.setPmstateId(OrdersIntegration.getAsString(data, "pmstate_id"));
        d.setResponsibleuserId(OrdersIntegration.getAsString(data, "responsibleuser_id"));
        d.setResponsibleroleId(OrdersIntegration.getAsString(data, "responsiblerole_id"));
        d.setAbraZasilkPobocka(OrdersIntegration.getAsString(data, "x_zasilk_pobocka"));
        d.setAbraZasilkAdresaPobocky(OrdersIntegration.getAsString(data, "x_zasilk_adresa_pobocky"));
        d.setAbraEmailSent(OrdersIntegration.getAsBoolean(data, "x_email_sent") != null ? (OrdersIntegration.getAsBoolean(data, "x_email_sent").booleanValue() ? "A" : "N") : null);
        d.setAbraPaid(OrdersIntegration.getAsBoolean(data, "x_paid") != null ? (OrdersIntegration.getAsBoolean(data, "x_paid").booleanValue() ? "A" : "N") : null);
        d.setAbraPaiddate(OrdersIntegration.getAsTimestamp(data, "x_paiddate"));
        d.setAbraBillOfDeliveryId(OrdersIntegration.getAsString(data, "x_billofdelivery_id"));
        d.setRows(new ArrayList<OrderItemsDomain>());
        JsonElement rows = data.get("rows");
        if (rows != null && (rowsAsJsonArray = rows.getAsJsonArray()) != null) {
            for (JsonElement jsonElement : rowsAsJsonArray) {
                JsonObject obj = jsonElement.getAsJsonObject();
                d.getRows().add(OrderItemsIntegration.convert(obj));
            }
        }
        return d;
    }
}

