/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.common;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseMapper {
    private static final Logger log = LoggerFactory.getLogger(BaseMapper.class);

    protected static Long getLong(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Long nValue = resultSet.getLong(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Long) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static String getString(ResultSet resultSet, String columnName) throws SQLException {
        try {
            String nValue = resultSet.getString(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (String) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Timestamp getTimestamp(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Timestamp nValue = resultSet.getTimestamp(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Timestamp) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Boolean getBoolean(ResultSet resultSet, String columnName) throws SQLException {
        try {
            boolean nValue = resultSet.getBoolean(columnName);
            return resultSet.wasNull() ? null : Boolean.valueOf(nValue);
        }
        catch (Exception e) {
            log.error(String.format("Column (Boolean) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Date getDate(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Date nValue = resultSet.getDate(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Date) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Integer getInt(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Integer nValue = resultSet.getInt(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Integer) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Double getDouble(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Double nValue = resultSet.getDouble(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Double) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static Float getFloat(ResultSet resultSet, String columnName) throws SQLException {
        try {
            Float nValue = Float.valueOf(resultSet.getFloat(columnName));
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (Float) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }

    protected static BigDecimal getBigDecimal(ResultSet resultSet, String columnName) throws SQLException {
        try {
            BigDecimal nValue = resultSet.getBigDecimal(columnName);
            return resultSet.wasNull() ? null : nValue;
        }
        catch (Exception e) {
            log.error(String.format("Column (BigDecimal) [%s] is not present in ResultSet %s", columnName, e.getMessage()));
            return null;
        }
    }
}

