/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.ContractItemsMapper;
import cz.airtoy.airshop.dao.mappers.renting.full.ContractItemsFullMapper;
import cz.airtoy.airshop.domains.renting.ContractItemsDomain;
import cz.airtoy.airshop.domains.renting.full.ContractItemsFullDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ContractItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.contract_id,\n\t\tp.target_commodity_id,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.cnt,\n\t\tp.deposit_amount,\n\t\tp.ord,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.contract_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.contract_id::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.contract_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.contract_id::text ~* :mask \n\tOR \n\t\tp.target_commodity_id::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.cnt::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  ")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.contract_id = :contractId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByContractId(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT    p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created  FROM    renting.contract_items p   WHERE    p.contract_id = :contractId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByContractId(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.contract_id = :contractId")
    public long findListByContractIdCount(@Bind(value="contractId") Long var1);

    @SqlQuery(value="SELECT    p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created, \t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(tcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n            SELECT \n            \t  tc.id AS \"id\",\n            \t\ttc.uid AS \"uid\",\n            \t\ttc.source AS \"source\",\n            \t\ttc.abra_id AS \"abraId\",\n            \t\ttc.plu AS \"plu\",\n            \t\ttc.code AS \"code\",\n            \t\ttc.shipping_weight AS \"shippingWeight\",\n            \t\ttc.external_record_id AS \"externalRecordId\",\n            \t\ttc.disabled AS \"disabled\",\n            \t\ttc.ord AS \"ord\",\n            \t\ttc.manufacturer_id AS \"manufacturerId\",\n            \t\ttc.external_stock_availability_id AS \"externalStockAvailabilityId\",\n            \t\ttc.external_charge_id AS \"externalChargeId\",\n            \t\ttc.vat AS \"vat\",\n            \t\ttc.language_name AS \"languageName\",\n            \t\ttc.name AS \"name\",\n            \t\ttc.alternative_name AS \"alternativeName\",\n            \t\ttc.annotation AS \"annotation\",\n            \t\ttc.description AS \"description\",\n            \t\ttc.meta_title AS \"metaTitle\",\n            \t\ttc.meta_description AS \"metaDescription\",\n            \t\ttc.meta_key_words AS \"metaKeyWords\",\n            \t\ttc.path AS \"path\",\n            \t\ttc.enabled AS \"enabled\",\n            \t\ttc.commodity_keg_size_id AS \"commodityKegSizeId\",\n            \t\ttc.price_amount_purchase_retail AS \"priceAmountPurchaseRetail\",\n            \t\ttc.price_amount_purchase_wholesale AS \"priceAmountPurchaseWholesale\",\n            \t\ttc.price_amount_sale_retail AS \"priceAmountSaleRetail\",\n            \t\ttc.price_amount_sale_wholesale AS \"priceAmountSaleWholesale\",\n            \t\ttc.volume AS \"volume\",\n            \t\ttc.on_order AS \"onOrder\",\n            \t\ttc.date_order AS \"dateOrder\",\n            \t\ttc.date_delivery AS \"dateDelivery\",\n            \t\ttc.date_updated AS \"dateUpdated\",\n            \t\ttc.note AS \"note\",\n            \t\ttc.date_created AS \"dateCreated\"\n             FROM \n            \t\tdata.target_commodity tc\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\ttc.id = p.target_commodity_id\n           ) tcfoo\n          )\n\t\t\t   )::TEXT AS targetCommodities,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(rpfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n            SELECT \n             \t  rp.id AS \"id\",\n             \t\trp.uid AS \"uid\",\n             \t\trp.target_commodity_id AS \"targetCommodityId\",\n             \t\trp.abra_id AS \"abraId\",\n             \t\trp.plu AS \"plu\",\n             \t\trp.code AS \"code\",\n             \t\trp.cnt AS \"cnt\",\n             \t\trp.deposit_amount AS \"depositAmount\",\n             \t\trp.ord AS \"ord\",\n             \t\trp.date_updated AS \"dateUpdated\",\n             \t\trp.note AS \"note\",\n             \t\trp.date_created AS \"dateCreated\"\n              FROM \n             \t\trenting.rental_portfolio rp\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\trp.target_commodity_id = p.target_commodity_id\n           ) rpfoo\n          )\n\t\t\t   )::TEXT AS rentalPortfolio\n FROM    renting.contract_items p  WHERE    p.contract_id = :contractId  ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsFullMapper.class)
    public List<ContractItemsFullDomain> findListByContractId(@Bind(value="contractId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.target_commodity_id = :targetCommodityId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.target_commodity_id = :targetCommodityId")
    public long findListByTargetCommodityIdCount(@Bind(value="targetCommodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.target_commodity_id = :targetCommodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByTargetCommodityId(@Bind(value="targetCommodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.code = :code")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.code = :code")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.cnt = :cnt")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByCnt(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.cnt = :cnt")
    public long findListByCntCount(@Bind(value="cnt") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.cnt = :cnt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByCnt(@Bind(value="cnt") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.deposit_amount = :depositAmount")
    public long findListByDepositAmountCount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.deposit_amount = :depositAmount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public ContractItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.contract_id, p.target_commodity_id, p.abra_id, p.plu, p.code, p.cnt, p.deposit_amount, p.ord, p.date_updated, p.note, p.date_created FROM renting.contract_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractItemsMapper.class)
    public List<ContractItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.contract_items (id, uid, contract_id, target_commodity_id, abra_id, plu, code, cnt, deposit_amount, ord, date_updated, note, date_created) VALUES (:id, :uid, :contractId, :targetCommodityId, :abraId, :plu, :code, :cnt, :depositAmount, :ord, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="contractId") Long var3, @Bind(value="targetCommodityId") Long var4, @Bind(value="abraId") String var5, @Bind(value="plu") String var6, @Bind(value="code") String var7, @Bind(value="cnt") Integer var8, @Bind(value="depositAmount") Double var9, @Bind(value="ord") Integer var10, @Bind(value="dateUpdated") Date var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO renting.contract_items (contract_id, target_commodity_id, abra_id, plu, code, cnt, deposit_amount, ord, date_updated, note, date_created) VALUES (:e.contractId, :e.targetCommodityId, :e.abraId, :e.plu, :e.code, :e.cnt, :e.depositAmount, :e.ord, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ContractItemsDomain var1);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE contract_id = :byContractId")
    public int updateByContractId(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byContractId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_commodity_id = :byTargetCommodityId")
    public int updateByTargetCommodityId(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byTargetCommodityId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE cnt = :byCnt")
    public int updateByCnt(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byCnt") Integer var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE deposit_amount = :byDepositAmount")
    public int updateByDepositAmount(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byDepositAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.contract_items SET id = :e.id, uid = :e.uid, contract_id = :e.contractId, target_commodity_id = :e.targetCommodityId, abra_id = :e.abraId, plu = :e.plu, code = :e.code, cnt = :e.cnt, deposit_amount = :e.depositAmount, ord = :e.ord, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ContractItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE contract_id = :contractId")
    public int deleteByContractId(@Bind(value="contractId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE target_commodity_id = :targetCommodityId")
    public int deleteByTargetCommodityId(@Bind(value="targetCommodityId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE cnt = :cnt")
    public int deleteByCnt(@Bind(value="cnt") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE deposit_amount = :depositAmount")
    public int deleteByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

