/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.app;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.app.DeviceLogEntriesMapper;
import cz.airtoy.airshop.domains.app.DeviceLogEntriesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface DeviceLogEntriesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.device_log_id,\n\t\tp.timestamp_str,\n\t\tp.pid,\n\t\tp.tid,\n\t\tp.log_level,\n\t\tp.message,\n\t\tp.line,\n\t\tp.created_at,\n\t\tp.date_created\n FROM \n\t\tapp.device_log_entries p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.device_log_id::text ~* :mask \n\tOR \n\t\tp.timestamp_str::text ~* :mask \n\tOR \n\t\tp.pid::text ~* :mask \n\tOR \n\t\tp.tid::text ~* :mask \n\tOR \n\t\tp.log_level::text ~* :mask \n\tOR \n\t\tp.message::text ~* :mask \n\tOR \n\t\tp.line::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.device_log_entries p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.device_log_id::text ~* :mask \n\tOR \n\t\tp.timestamp_str::text ~* :mask \n\tOR \n\t\tp.pid::text ~* :mask \n\tOR \n\t\tp.tid::text ~* :mask \n\tOR \n\t\tp.log_level::text ~* :mask \n\tOR \n\t\tp.message::text ~* :mask \n\tOR \n\t\tp.line::text ~* :mask \n\tOR \n\t\tp.created_at::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  ")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.id = :id")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.id = :id")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.device_log_id = :deviceLogId")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByDeviceLogId(@Bind(value="deviceLogId") Long var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.device_log_id = :deviceLogId")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByDeviceLogId(@Bind(value="deviceLogId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.device_log_id = :deviceLogId")
    public long findListByDeviceLogIdCount(@Bind(value="deviceLogId") Long var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.device_log_id = :deviceLogId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByDeviceLogId(@Bind(value="deviceLogId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.timestamp_str = :timestampStr")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByTimestampStr(@Bind(value="timestampStr") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.timestamp_str = :timestampStr")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByTimestampStr(@Bind(value="timestampStr") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.timestamp_str = :timestampStr")
    public long findListByTimestampStrCount(@Bind(value="timestampStr") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.timestamp_str = :timestampStr ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByTimestampStr(@Bind(value="timestampStr") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.pid = :pid")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByPid(@Bind(value="pid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.pid = :pid")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByPid(@Bind(value="pid") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.pid = :pid")
    public long findListByPidCount(@Bind(value="pid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.pid = :pid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByPid(@Bind(value="pid") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.tid = :tid")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByTid(@Bind(value="tid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.tid = :tid")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByTid(@Bind(value="tid") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.tid = :tid")
    public long findListByTidCount(@Bind(value="tid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.tid = :tid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByTid(@Bind(value="tid") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.log_level = :logLevel")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByLogLevel(@Bind(value="logLevel") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.log_level = :logLevel")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByLogLevel(@Bind(value="logLevel") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.log_level = :logLevel")
    public long findListByLogLevelCount(@Bind(value="logLevel") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.log_level = :logLevel ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByLogLevel(@Bind(value="logLevel") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.message = :message")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByMessage(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.message = :message")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByMessage(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.message = :message")
    public long findListByMessageCount(@Bind(value="message") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.message = :message ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByMessage(@Bind(value="message") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.line = :line")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByLine(@Bind(value="line") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.line = :line")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByLine(@Bind(value="line") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.line = :line")
    public long findListByLineCount(@Bind(value="line") String var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.line = :line ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByLine(@Bind(value="line") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.created_at = :createdAt")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.created_at = :createdAt")
    public long findListByCreatedAtCount(@Bind(value="createdAt") Date var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.created_at = :createdAt ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByCreatedAt(@Bind(value="createdAt") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public DeviceLogEntriesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.device_log_entries p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.device_log_id, p.timestamp_str, p.pid, p.tid, p.log_level, p.message, p.line, p.created_at, p.date_created FROM app.device_log_entries p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=DeviceLogEntriesMapper.class)
    public List<DeviceLogEntriesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.device_log_entries (id, device_log_id, timestamp_str, pid, tid, log_level, message, line, created_at, date_created) VALUES (:id, :deviceLogId, :timestampStr, :pid, :tid, :logLevel, :message, :line, :createdAt, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="deviceLogId") Long var2, @Bind(value="timestampStr") String var3, @Bind(value="pid") Integer var4, @Bind(value="tid") Integer var5, @Bind(value="logLevel") String var6, @Bind(value="message") String var7, @Bind(value="line") String var8, @Bind(value="createdAt") Date var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO app.device_log_entries (device_log_id, timestamp_str, pid, tid, log_level, message, line, created_at, date_created) VALUES (:e.deviceLogId, :e.timestampStr, :e.pid, :e.tid, :e.logLevel, :e.message, :e.line, :e.createdAt, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") DeviceLogEntriesDomain var1);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE device_log_id = :byDeviceLogId")
    public int updateByDeviceLogId(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byDeviceLogId") Long var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE timestamp_str = :byTimestampStr")
    public int updateByTimestampStr(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byTimestampStr") String var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE pid = :byPid")
    public int updateByPid(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byPid") Integer var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE tid = :byTid")
    public int updateByTid(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byTid") Integer var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE log_level = :byLogLevel")
    public int updateByLogLevel(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byLogLevel") String var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE message = :byMessage")
    public int updateByMessage(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byMessage") String var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE line = :byLine")
    public int updateByLine(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byLine") String var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE created_at = :byCreatedAt")
    public int updateByCreatedAt(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byCreatedAt") Date var2);

    @SqlUpdate(value="UPDATE app.device_log_entries SET id = :e.id, device_log_id = :e.deviceLogId, timestamp_str = :e.timestampStr, pid = :e.pid, tid = :e.tid, log_level = :e.logLevel, message = :e.message, line = :e.line, created_at = :e.createdAt, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") DeviceLogEntriesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE device_log_id = :deviceLogId")
    public int deleteByDeviceLogId(@Bind(value="deviceLogId") Long var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE timestamp_str = :timestampStr")
    public int deleteByTimestampStr(@Bind(value="timestampStr") String var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE pid = :pid")
    public int deleteByPid(@Bind(value="pid") Integer var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE tid = :tid")
    public int deleteByTid(@Bind(value="tid") Integer var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE log_level = :logLevel")
    public int deleteByLogLevel(@Bind(value="logLevel") String var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE message = :message")
    public int deleteByMessage(@Bind(value="message") String var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE line = :line")
    public int deleteByLine(@Bind(value="line") String var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE created_at = :createdAt")
    public int deleteByCreatedAt(@Bind(value="createdAt") Date var1);

    @SqlUpdate(value="DELETE FROM app.device_log_entries WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

