/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.CommodityMapper;
import cz.airtoy.airshop.dao.mappers.data.full.CommodityFullMapper;
import cz.airtoy.airshop.domains.data.CommodityDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CommodityDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.commodity p\n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :source = 'ALL' THEN TRUE ELSE ( p.source = :source ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="disabled") String var2, @Bind(value="source") String var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.commodity p\n\t\n\tWHERE \n\t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END) \n AND \t  (CASE WHEN :source = 'ALL' THEN TRUE ELSE ( p.source = :source ) END) \n AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1, @Bind(value="disabled") String var2, @Bind(value="source") String var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  ")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT \t  p.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tmf.name as manufacturer,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.enabled,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.commodity_id AS \"commodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\",\n             \t\tnull AS \"mallId\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.category dc\n\t\t              JOIN data.commodity_category dcc ON (dc.id = dcc.category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM data.commodity p \n LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityFullMapper.class)
    public CommodityDomain findByIdFull(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT  p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created  FROM data.commodity p  JOIN data.commodity_category cc ON (cc.commodity_id = p.id) \tWHERE \t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END)  AND    cc.category_id = :categoryId AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByCategoryId(@Bind(value="categoryId") Long var1, @Bind(value="disabled") String var2, @Bind(value="mask") String var3);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  JOIN data.commodity_category cc ON (cc.commodity_id = p.id) \tWHERE \t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END)  AND    cc.category_id = :categoryId AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n")
    public long findListByCategoryIdCount(@Bind(value="categoryId") Long var1, @Bind(value="disabled") String var2, @Bind(value="mask") String var3);

    @SqlQuery(value="SELECT  p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created  FROM data.commodity p  JOIN data.commodity_category cc ON (cc.commodity_id = p.id) \tWHERE \t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END)  AND    cc.category_id = :categoryId AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByCategoryId(@Bind(value="categoryId") Long var1, @Bind(value="disabled") String var2, @Bind(value="mask") String var3, @Bind(value="offset") int var4, @Bind(value="limit") int var5, @Define(value="order") String var6, @Define(value="sort") String var7);

    @SqlQuery(value="SELECT \t  p.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.abra_id,\n\t\tp.plu,\n\t\tp.code,\n\t\tp.shipping_weight,\n\t\tp.external_record_id,\n\t\tp.disabled,\n\t\tp.ord,\n\t\tmf.name as manufacturer,\n\t\tp.manufacturer_id,\n\t\tp.external_stock_availability_id,\n\t\tp.external_charge_id,\n\t\tp.vat,\n\t\tp.language_name,\n\t\tp.name,\n\t\tp.alternative_name,\n\t\tp.annotation,\n\t\tp.description,\n\t\tp.meta_title,\n\t\tp.meta_description,\n\t\tp.meta_key_words,\n\t\tp.path,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcvfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n\t                dcv.id,\n\t            \t  dcv.uid,\n\t            \t  dcv.commodity_id AS \"commodityId\",\n\t            \t  dcv.manufacturer_id as \"manufacturerId\",\n\t            \t  dcv.vat,\n\t            \t  dcv.language_name AS \"languageName\",\n\t            \t  dcv.name,\n\t            \t  dcv.alternative_name AS \"alternativeName\",\n\t            \t  dcv.annotation,\n\t            \t  dcv.description,\n\t            \t  dcv.meta_title AS \"metaTitle\",\n\t            \t  dcv.meta_description AS \"metaDescription\",\n\t            \t  dcv.meta_key_words AS \"metaKeyWords\",\n\t            \t  dcv.path,\n\t            \t  dcv.date_updated AS \"dateUpdated\",\n\t            \t  dcv.note,\n\t            \t  dcv.date_created AS \"dateCreated\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.commodity_variant dcv\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcv.commodity_id = p.id\n        \t\t\t\t\t) dcvfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS variants,\n\t   to_json(\n\t\t   array(\n\t\t\t\t   SELECT\n\t\t\t\t\t\t  to_json(dcfoo.*)\n\t\t\t\t   FROM\n\t\t\t\t\t\t(\n\t\t\t\t\t\t\tSELECT \n             \t  dc.id,\n             \t\tdc.uid,\n             \t\tdc.source,\n             \t\tdc.disabled,\n             \t\tdc.ord,\n             \t\tdc.external_record_id AS \"externalRecordId\",\n             \t\tdc.external_record_parent_id AS \"externalRecordParentId\",\n             \t\tdc.language_name AS \"languageName\",\n             \t\tdc.parent_category_id AS \"parentCategoryId\",\n             \t\tdc.depth,\n             \t\tdc.ident,\n             \t\tdc.name,\n             \t\tdc.alternative_name AS \"alternativeName\",\n             \t\tdc.description,\n             \t\tdc.alternative_description AS \"alternativeDescription\",\n             \t\tdc.rank,\n             \t\tdc.meta_title AS \"metaTitle\",\n             \t\tdc.meta_description AS \"metaDescription\",\n             \t\tdc.meta_key_words AS \"metaKeyWords\",\n             \t\tdc.enabled,\n             \t\tdc.date_updated AS \"dateUpdated\",\n             \t\tdc.note,\n             \t\tdc.date_created AS \"dateCreated\",\n             \t\tnull AS \"mallId\"\n\t\t\t\t\t\t\tFROM \n\t\t\t\t\t\t\t\t\tdata.category dc\n\t\t              JOIN data.commodity_category dcc ON (dc.id = dcc.category_id)\n\t\t\t\t\t\t\tWHERE \n\t\t\t\t\t\t\t\t\tdcc.commodity_id = p.id\n        \t\t\t\t\t) dcfoo\n\t\t\t\t\t   )\n\t\t\t   )::TEXT AS categories\n FROM data.commodity p  JOIN data.commodity_category cc ON (cc.commodity_id = p.id)  LEFT OUTER JOIN data.manufacturer mf ON (mf.id = p.manufacturer_id) \n\tWHERE \t  (CASE WHEN :disabled = 'ALL' THEN TRUE ELSE ( p.disabled = (CASE WHEN :disabled = '1' THEN 1 ELSE 0 END) ) END)  AND    cc.category_id = :categoryId AND ( \t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.plu::text ~* :mask \n\tOR \n\t\tp.code::text ~* :mask \n\tOR \n\t\tp.shipping_weight::text ~* :mask \n\tOR \n\t\tp.external_record_id::text ~* :mask \n\tOR \n\t\tp.disabled::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.manufacturer_id::text ~* :mask \n\tOR \n\t\tp.external_stock_availability_id::text ~* :mask \n\tOR \n\t\tp.external_charge_id::text ~* :mask \n\tOR \n\t\tp.vat::text ~* :mask \n\tOR \n\t\tp.language_name::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.alternative_name::text ~* :mask \n\tOR \n\t\tp.annotation::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.meta_title::text ~* :mask \n\tOR \n\t\tp.meta_description::text ~* :mask \n\tOR \n\t\tp.meta_key_words::text ~* :mask \n\tOR \n\t\tp.path::text ~* :mask \n\tOR \n\t\tp.enabled::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\t) \n")
    @RegisterRowMapper(value=CommodityFullMapper.class)
    public List<CommodityDomain> findListByCategoryIdFull(@Bind(value="categoryId") Long var1, @Bind(value="disabled") String var2, @Bind(value="mask") String var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.source = :source AND p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findBySourceExternalRecordId(@Bind(value="source") String var1, @Bind(value="externalRecordId") String var2);

    @SqlUpdate(value="UPDATE\n    data.commodity cu\nSET ord = subquery.ord_natural\nFROM (SELECT c.id,\n             c.plu,\n             c.name,\n             coalesce(ford.qty, 0) as cnt,\n             ROW_NUMBER()\n             OVER (ORDER BY ford.abra_exportnullquantity ASC, (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC, c.date_created DESC) as ord_natural\n      FROM data.commodity c\n               LEFT OUTER JOIN (SELECT sc.code, sc.abra_exportnullquantity, SUM(scq.quantity) as qty\n                                FROM abra.store_cards_quantity scq\n                                         JOIN abra.store_cards sc ON (scq.storecard_id = sc.abra_id)\n                                GROUP BY sc.code, sc.abra_exportnullquantity) ford ON (ford.code = c.plu)\n      WHERE c.source = 'BEERSHOP'\n      ORDER BY ford.abra_exportnullquantity ASC, (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC, c.date_created DESC) AS subquery\nWHERE cu.id = subquery.id")
    public int updateCommoditySourceBeershopOrdRules();

    @SqlUpdate(value="UPDATE\n    data.commodity cu\nSET ord = subquery.ord_natural\nFROM (SELECT c.id,\n             c.plu,\n             c.name,\n             coalesce(ford.qty, 0) as cnt,\n             ROW_NUMBER()\n             OVER (ORDER BY ford.abra_exportnullquantity ASC, (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC, c.date_created DESC) as ord_natural\n      FROM data.commodity c\n               LEFT OUTER JOIN (SELECT sc.code, sc.abra_exportnullquantity, SUM(scq.quantity) as qty\n                                FROM abra.store_cards_quantity scq\n                                         JOIN abra.store_cards sc ON (scq.storecard_id = sc.abra_id)\n                                GROUP BY sc.code, sc.abra_exportnullquantity) ford ON (ford.code = c.plu)\n      WHERE c.source = 'BEERSHOPEU'\n      ORDER BY ford.abra_exportnullquantity ASC, (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC, c.date_created DESC) AS subquery\nWHERE cu.id = subquery.id")
    public int updateCommoditySourceBeershopEuOrdRules();

    @SqlUpdate(value="UPDATE\n    data.commodity cu\nSET ord = subquery.ord_natural\nFROM (SELECT c.id,\n             c.plu,\n             c.name,\n             coalesce(ford.qty, 0) as cnt,\n             ROW_NUMBER()\n             OVER (ORDER BY                      ford.abra_exportnullquantity ASC,                      (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC,                      (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 1 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 1) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 2 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 2) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 3 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 3) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 4 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 4) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 5 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 5) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 6 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 6) ELSE '' END) ASC,\n                     (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 7 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 7) ELSE '' END) ASC,\n                      (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 8 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 8) ELSE '' END) ASC,\n                      c.date_created DESC) as ord_natural\n      FROM data.commodity c\n               LEFT OUTER JOIN (SELECT sc.code, sc.abra_exportnullquantity, SUM(scq.quantity) as qty\n                                FROM abra.store_cards_quantity scq\n                                         JOIN abra.store_cards sc ON (scq.storecard_id = sc.abra_id)\n                                GROUP BY sc.code, sc.abra_exportnullquantity) ford ON (ford.code = c.plu)\n      WHERE c.source = 'DELIKATESY'\n      ORDER BY                    ford.abra_exportnullquantity ASC,                    (case when coalesce(ford.qty, 0) > 1 then 0 else 1 end) ASC,                    (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 1 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 1) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 2 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 2) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 3 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 3) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 4 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 4) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 5 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 5) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 6 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 6) ELSE '' END) ASC,\n                   (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 7 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 7) ELSE '' END) ASC,\n                    (CASE WHEN ARRAY_LENGTH(REGEXP_SPLIT_TO_ARRAY(REPLACE(trim(c.name), '  ', ' '), ' '), 1) >= 8 THEN SPLIT_PART(REPLACE(trim(c.name), '  ', ' '), ' ', 8) ELSE '' END) ASC,\n                    c.date_created DESC) AS subquery\nWHERE cu.id = subquery.id")
    public int updateCommoditySourceDelikatesyOrdRules();

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.plu = :plu AND p.source = :source")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByPluSource(@Bind(value="plu") String var1, @Bind(value="source") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.source = :source")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.source = :source")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.plu = :plu")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByPlu(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.plu = :plu")
    public long findListByPluCount(@Bind(value="plu") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.plu = :plu ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByPlu(@Bind(value="plu") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.code = :code")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.code = :code")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByCode(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.code = :code")
    public long findListByCodeCount(@Bind(value="code") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.code = :code ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByCode(@Bind(value="code") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.shipping_weight = :shippingWeight")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.shipping_weight = :shippingWeight")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.shipping_weight = :shippingWeight")
    public long findListByShippingWeightCount(@Bind(value="shippingWeight") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.shipping_weight = :shippingWeight ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByShippingWeight(@Bind(value="shippingWeight") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_record_id = :externalRecordId AND p.source = :bySource")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByExternalRecordIdAndSource(@Bind(value="externalRecordId") String var1, @Bind(value="bySource") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_record_id = :externalRecordId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.external_record_id = :externalRecordId")
    public long findListByExternalRecordIdCount(@Bind(value="externalRecordId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_record_id = :externalRecordId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalRecordId(@Bind(value="externalRecordId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.disabled = :disabled")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDisabled(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.disabled = :disabled")
    public long findListByDisabledCount(@Bind(value="disabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.disabled = :disabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDisabled(@Bind(value="disabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.manufacturer_id = :manufacturerId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.manufacturer_id = :manufacturerId")
    public long findListByEanCount(@Bind(value="manufacturerId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.manufacturer_id = :manufacturerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByManufacturer(@Bind(value="manufacturerId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId")
    public long findListByExternalStockAvailabilityIdCount(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_stock_availability_id = :externalStockAvailabilityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_charge_id = :externalChargeId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_charge_id = :externalChargeId")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.external_charge_id = :externalChargeId")
    public long findListByExternalChargeIdCount(@Bind(value="externalChargeId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.external_charge_id = :externalChargeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByExternalChargeId(@Bind(value="externalChargeId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.vat = :vat")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByVat(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.vat = :vat")
    public long findListByVatCount(@Bind(value="vat") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.vat = :vat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByVat(@Bind(value="vat") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.language_name = :languageName")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByLanguageName(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.language_name = :languageName")
    public long findListByLanguageNameCount(@Bind(value="languageName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.language_name = :languageName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByLanguageName(@Bind(value="languageName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.name = :name")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.name = :name")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.alternative_name = :alternativeName")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.alternative_name = :alternativeName")
    public long findListByAlternativeNameCount(@Bind(value="alternativeName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.alternative_name = :alternativeName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAlternativeName(@Bind(value="alternativeName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.annotation = :annotation")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAnnotation(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.annotation = :annotation")
    public long findListByAnnotationCount(@Bind(value="annotation") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.annotation = :annotation ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByAnnotation(@Bind(value="annotation") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.description = :description")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.description = :description")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_title = :metaTitle")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.meta_title = :metaTitle")
    public long findListByMetaTitleCount(@Bind(value="metaTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_title = :metaTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaTitle(@Bind(value="metaTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_description = :metaDescription")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.meta_description = :metaDescription")
    public long findListByMetaDescriptionCount(@Bind(value="metaDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_description = :metaDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaDescription(@Bind(value="metaDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_key_words = :metaKeyWords")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.meta_key_words = :metaKeyWords")
    public long findListByMetaKeyWordsCount(@Bind(value="metaKeyWords") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.meta_key_words = :metaKeyWords ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByMetaKeyWords(@Bind(value="metaKeyWords") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.path = :path")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.path = :path")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByPath(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.path = :path")
    public long findListByPathCount(@Bind(value="path") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.path = :path ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByPath(@Bind(value="path") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.enabled = :enabled")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByEnabled(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.enabled = :enabled")
    public long findListByEnabledCount(@Bind(value="enabled") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.enabled = :enabled ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByEnabled(@Bind(value="enabled") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityMapper.class)
    public CommodityDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.abra_id, p.plu, p.code, p.shipping_weight, p.external_record_id, p.disabled, p.ord, p.manufacturer_id, p.external_stock_availability_id, p.external_charge_id, p.vat, p.language_name, p.name, p.alternative_name, p.annotation, p.description, p.meta_title, p.meta_description, p.meta_key_words, p.path, p.enabled, p.date_updated, p.note, p.date_created FROM data.commodity p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityMapper.class)
    public List<CommodityDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.commodity (id, uid, source, abra_id, plu, code, shipping_weight, external_record_id, disabled, ord, manufacturer_id, external_stock_availability_id, external_charge_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, enabled, date_updated, note, date_created) VALUES (:id, :uid, :source, :abraId, :plu, :code, :shippingWeight, :externalRecordId, :disabled, :ord, :manufacturerId, :externalStockAvailabilityId, :externalChargeId, :vat, :languageName, :name, :alternativeName, :annotation, :description, :metaTitle, :metaDescription, :metaKeyWords, :path, :enabled, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="source") String var3, @Bind(value="abraId") String var4, @Bind(value="plu") String var5, @Bind(value="code") String var6, @Bind(value="shippingWeight") Double var7, @Bind(value="externalRecordId") String var8, @Bind(value="disabled") Integer var9, @Bind(value="ord") Integer var10, @Bind(value="manufacturerId") String var11, @Bind(value="externalStockAvailabilityId") String var12, @Bind(value="externalChargeId") String var13, @Bind(value="vat") Double var14, @Bind(value="languageName") String var15, @Bind(value="name") String var16, @Bind(value="alternativeName") String var17, @Bind(value="annotation") String var18, @Bind(value="description") String var19, @Bind(value="metaTitle") String var20, @Bind(value="metaDescription") String var21, @Bind(value="metaKeyWords") String var22, @Bind(value="path") String var23, @Bind(value="enabled") Integer var24, @Bind(value="dateUpdated") Date var25, @Bind(value="note") String var26, @Bind(value="dateCreated") Date var27);

    @SqlUpdate(value="INSERT INTO data.commodity (source, abra_id, plu, code, shipping_weight, external_record_id, disabled, ord, manufacturer_id, external_stock_availability_id, external_charge_id, vat, language_name, name, alternative_name, annotation, description, meta_title, meta_description, meta_key_words, path, enabled, date_updated, note, date_created) VALUES (:e.source, :e.abraId, :e.plu, :e.code, :e.shippingWeight, :e.externalRecordId, :e.disabled, :e.ord, :e.manufacturerId, :e.externalStockAvailabilityId, :e.externalChargeId, :e.vat, :e.languageName, :e.name, :e.alternativeName, :e.annotation, :e.description, :e.metaTitle, :e.metaDescription, :e.metaKeyWords, :e.path, :e.enabled, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") CommodityDomain var1);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") CommodityDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") CommodityDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") CommodityDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") CommodityDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE plu = :byPlu")
    public int updateByPlu(@BindBean(value="e") CommodityDomain var1, @Bind(value="byPlu") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE code = :byCode")
    public int updateByCode(@BindBean(value="e") CommodityDomain var1, @Bind(value="byCode") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE shipping_weight = :byShippingWeight")
    public int updateByShippingWeight(@BindBean(value="e") CommodityDomain var1, @Bind(value="byShippingWeight") Double var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_record_id = :byExternalRecordId")
    public int updateByExternalRecordId(@BindBean(value="e") CommodityDomain var1, @Bind(value="byExternalRecordId") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE disabled = :byDisabled")
    public int updateByDisabled(@BindBean(value="e") CommodityDomain var1, @Bind(value="byDisabled") Integer var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") CommodityDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE manufacturer_id = :byEan")
    public int updateByManufacturer(@BindBean(value="e") CommodityDomain var1, @Bind(value="byEan") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_stock_availability_id = :byExternalStockAvailabilityId")
    public int updateByExternalStockAvailabilityId(@BindBean(value="e") CommodityDomain var1, @Bind(value="byExternalStockAvailabilityId") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE external_charge_id = :byExternalChargeId")
    public int updateByExternalChargeId(@BindBean(value="e") CommodityDomain var1, @Bind(value="byExternalChargeId") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE vat = :byVat")
    public int updateByVat(@BindBean(value="e") CommodityDomain var1, @Bind(value="byVat") Double var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE language_name = :byLanguageName")
    public int updateByLanguageName(@BindBean(value="e") CommodityDomain var1, @Bind(value="byLanguageName") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") CommodityDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE alternative_name = :byAlternativeName")
    public int updateByAlternativeName(@BindBean(value="e") CommodityDomain var1, @Bind(value="byAlternativeName") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE annotation = :byAnnotation")
    public int updateByAnnotation(@BindBean(value="e") CommodityDomain var1, @Bind(value="byAnnotation") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") CommodityDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_title = :byMetaTitle")
    public int updateByMetaTitle(@BindBean(value="e") CommodityDomain var1, @Bind(value="byMetaTitle") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_description = :byMetaDescription")
    public int updateByMetaDescription(@BindBean(value="e") CommodityDomain var1, @Bind(value="byMetaDescription") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE meta_key_words = :byMetaKeyWords")
    public int updateByMetaKeyWords(@BindBean(value="e") CommodityDomain var1, @Bind(value="byMetaKeyWords") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE path = :byPath")
    public int updateByPath(@BindBean(value="e") CommodityDomain var1, @Bind(value="byPath") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE enabled = :byEnabled")
    public int updateByEnabled(@BindBean(value="e") CommodityDomain var1, @Bind(value="byEnabled") Integer var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") CommodityDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") CommodityDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.commodity SET id = :e.id, uid = :e.uid, source = :e.source, abra_id = :e.abraId, plu = :e.plu, code = :e.code, shipping_weight = :e.shippingWeight, external_record_id = :e.externalRecordId, disabled = :e.disabled, ord = :e.ord, manufacturer_id = :e.manufacturerId, external_stock_availability_id = :e.externalStockAvailabilityId, external_charge_id = :e.externalChargeId, vat = :e.vat, language_name = :e.languageName, name = :e.name, alternative_name = :e.alternativeName, annotation = :e.annotation, description = :e.description, meta_title = :e.metaTitle, meta_description = :e.metaDescription, meta_key_words = :e.metaKeyWords, path = :e.path, enabled = :e.enabled, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") CommodityDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE plu = :plu")
    public int deleteByPlu(@Bind(value="plu") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE code = :code")
    public int deleteByCode(@Bind(value="code") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE shipping_weight = :shippingWeight")
    public int deleteByShippingWeight(@Bind(value="shippingWeight") Double var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE external_record_id = :externalRecordId")
    public int deleteByExternalRecordId(@Bind(value="externalRecordId") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE disabled = :disabled")
    public int deleteByDisabled(@Bind(value="disabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE manufacturer_id = :manufacturerId")
    public int deleteByManufacturer(@Bind(value="manufacturerId") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE external_stock_availability_id = :externalStockAvailabilityId")
    public int deleteByExternalStockAvailabilityId(@Bind(value="externalStockAvailabilityId") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE external_charge_id = :externalChargeId")
    public int deleteByExternalChargeId(@Bind(value="externalChargeId") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE vat = :vat")
    public int deleteByVat(@Bind(value="vat") Double var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE language_name = :languageName")
    public int deleteByLanguageName(@Bind(value="languageName") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE alternative_name = :alternativeName")
    public int deleteByAlternativeName(@Bind(value="alternativeName") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE annotation = :annotation")
    public int deleteByAnnotation(@Bind(value="annotation") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE meta_title = :metaTitle")
    public int deleteByMetaTitle(@Bind(value="metaTitle") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE meta_description = :metaDescription")
    public int deleteByMetaDescription(@Bind(value="metaDescription") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE meta_key_words = :metaKeyWords")
    public int deleteByMetaKeyWords(@Bind(value="metaKeyWords") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE path = :path")
    public int deleteByPath(@Bind(value="path") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE enabled = :enabled")
    public int deleteByEnabled(@Bind(value="enabled") Integer var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

