/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.CommodityCategoryMapper;
import cz.airtoy.airshop.domains.data.CommodityCategoryDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CommodityCategoryDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.commodity_id,\n\t\tp.category_id,\n\t\tp.date_updated,\n\t\tp.main,\n\t\tp.date_created\n FROM \n\t\tdata.commodity_category p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.category_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.main::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.commodity_category p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.category_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.main::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  ")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.commodity_id = :commodityId AND p.category_id = :categoryId")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByIdCommodityIdcategoryId(@Bind(value="commodityId") Long var1, @Bind(value="categoryId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.commodity_id = :commodityId")
    public long findListByCommodityIdCount(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.commodity_id = :commodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByCommodityId(@Bind(value="commodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.category_id = :categoryId")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.category_id = :categoryId")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.category_id = :categoryId")
    public long findListByCategoryIdCount(@Bind(value="categoryId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.category_id = :categoryId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByCategoryId(@Bind(value="categoryId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.main = :main")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByMain(@Bind(value="main") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.main = :main")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByMain(@Bind(value="main") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.main = :main")
    public long findListByMainCount(@Bind(value="main") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.main = :main ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByMain(@Bind(value="main") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public CommodityCategoryDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_category p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.category_id, p.date_updated, p.main, p.date_created FROM data.commodity_category p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityCategoryMapper.class)
    public List<CommodityCategoryDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.commodity_category (id, uid, commodity_id, category_id, date_updated, main, date_created) VALUES (:id, :uid, :commodityId, :categoryId, :dateUpdated, :main, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="commodityId") Long var3, @Bind(value="categoryId") Long var4, @Bind(value="dateUpdated") Date var5, @Bind(value="main") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO data.commodity_category (commodity_id, category_id, date_updated, main, date_created) VALUES (:e.commodityId, :e.categoryId, :e.dateUpdated, :e.main, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") CommodityCategoryDomain var1);

    @SqlUpdate(value="INSERT INTO data.commodity_category (uid, commodity_id, category_id, date_updated, main, date_created) VALUES (:e.uid, :e.commodityId, :e.categoryId, :e.dateUpdated, :e.main, :e.dateCreated)")
    @GetGeneratedKeys
    public long insertWithUid(@BindBean(value="e") CommodityCategoryDomain var1);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE commodity_id = :byCommodityId")
    public int updateByCommodityId(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byCommodityId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE category_id = :byCategoryId")
    public int updateByCategoryId(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byCategoryId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE main = :byMain")
    public int updateByMain(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byMain") String var2);

    @SqlUpdate(value="UPDATE data.commodity_category SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, category_id = :e.categoryId, date_updated = :e.dateUpdated, main = :e.main, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") CommodityCategoryDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE commodity_id = :commodityId")
    public int deleteByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE category_id = :categoryId")
    public int deleteByCategoryId(@Bind(value="categoryId") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE main = :main")
    public int deleteByMain(@Bind(value="main") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_category WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

