/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.AppProfilesMapper;
import cz.airtoy.airshop.domains.AppProfilesDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AppProfilesDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.ident,\n\t\tp.partner_id,\n\t\tp.status,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.app_profiles p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.app_profiles p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.id = :id")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.id = :id")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.ident = :ident AND p.partner_id = :partnerId")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByIdentPartnerId(@Bind(value="ident") String var1, @Bind(value="partnerId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.status = :status")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.status = :status")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.note = :note")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.note = :note")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public AppProfilesDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.app_profiles p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.ident, p.partner_id, p.status, p.date_updated, p.note, p.date_created FROM app.app_profiles p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AppProfilesMapper.class)
    public List<AppProfilesDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.app_profiles (id, uid, ident, partner_id, status, date_updated, note, date_created) VALUES (:id, :uid, :ident, :partnerId, :status, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="ident") String var3, @Bind(value="partnerId") Long var4, @Bind(value="status") String var5, @Bind(value="dateUpdated") Date var6, @Bind(value="note") String var7, @Bind(value="dateCreated") Date var8);

    @SqlUpdate(value="INSERT INTO app.app_profiles (ident, partner_id, status, date_updated, note, date_created) VALUES (:e.ident, :e.partnerId, :e.status, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") AppProfilesDomain var1);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.app_profiles SET id = :e.id, uid = :e.uid, ident = :e.ident, partner_id = :e.partnerId, status = :e.status, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") AppProfilesDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.app_profiles WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

