/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import cz.airtoy.airshop.domains.FirmOfficesDomain;
import cz.airtoy.airshop.domains.FirmsDomain;
import cz.airtoy.airshop.integration.AddressesIntegration;
import cz.airtoy.airshop.integration.FirmOfficesIntegration;
import cz.airtoy.airshop.integration.common.BaseIntegration;
import java.util.Collections;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmsIntegration
extends BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(FirmsIntegration.class);

    public static FirmsDomain convert(JsonObject data) {
        FirmsDomain d = new FirmsDomain();
        d.setAbraId(FirmsIntegration.getAsString(data, "id"));
        d.setAfterdueterm(FirmsIntegration.getAsInt(data, "afterdueterm"));
        d.setAfterduetermenabled(FirmsIntegration.getAsBoolean(data, "afterduetermenabled"));
        d.setBodycode(FirmsIntegration.getAsString(data, "bodycode"));
        d.setCheckcredit(FirmsIntegration.getAsBoolean(data, "checkcredit"));
        d.setClassid(FirmsIntegration.getAsString(data, "classid"));
        d.setCode(FirmsIntegration.getAsString(data, "code"));
        d.setComment(FirmsIntegration.getAsString(data, "comment"));
        d.setCommercialsagreement(FirmsIntegration.getAsInt(data, "commercialsagreement"));
        d.setCommunicationtypeId(FirmsIntegration.getAsString(data, "communicationtype_id"));
        d.setDateCorrectedat(FirmsIntegration.getAsTimestamp(data, "correctedat$date"));
        d.setCorrectedbyId(FirmsIntegration.getAsString(data, "correctedby_id"));
        d.setDateCreatedat(FirmsIntegration.getAsTimestamp(data, "createdat$date"));
        d.setCreatedbyId(FirmsIntegration.getAsString(data, "createdby_id"));
        d.setCredit(FirmsIntegration.getAsDouble(data, "credit"));
        d.setCurrencyId(FirmsIntegration.getAsString(data, "currency_id"));
        d.setDealercategoryId(FirmsIntegration.getAsString(data, "dealercategory_id"));
        d.setDealerdiscount(FirmsIntegration.getAsDouble(data, "dealerdiscount"));
        d.setDealerdiscountkind(FirmsIntegration.getAsInt(data, "dealerdiscountkind"));
        d.setDisplayname(FirmsIntegration.getAsString(data, "displayname"));
        d.setDueterm(FirmsIntegration.getAsInt(data, "dueterm"));
        d.setEinvoiceformat(FirmsIntegration.getAsInt(data, "einvoiceformat"));
        d.setElecposagreementref(FirmsIntegration.getAsString(data, "elecposagreementref"));
        d.setElectronicaddress(AddressesIntegration.convert(FirmsIntegration.getAsObject(data, "electronicaddress_id")));
        d.setElectronicaddressId(d.getElectronicaddress() != null ? d.getElectronicaddress().getAbraId() : null);
        d.setEmployeecountId(FirmsIntegration.getAsString(data, "employeecount_id"));
        d.setEoriidentnumber(FirmsIntegration.getAsString(data, "eoriidentnumber"));
        d.setEquitycapitalId(FirmsIntegration.getAsString(data, "equitycapital_id"));
        d.setFirmId(FirmsIntegration.getAsString(data, "firm_id"));
        d.setGdprvaliditysuspended(FirmsIntegration.getAsBoolean(data, "gdprvaliditysuspended"));
        d.setHidden(FirmsIntegration.getAsBoolean(data, "hidden"));
        d.setDateImportdatafromaresat(FirmsIntegration.getAsTimestamp(data, "importdatafromaresat$date"));
        d.setInitialfirmpersonFirstname(FirmsIntegration.getAsString(data, "initialfirmperson_firstname"));
        d.setInitialfirmpersonId(FirmsIntegration.getAsString(data, "initialfirmperson_id"));
        d.setInitialfirmpersonLastname(FirmsIntegration.getAsString(data, "initialfirmperson_lastname"));
        d.setInitialfirmpersonSuffix(FirmsIntegration.getAsString(data, "initialfirmperson_suffix"));
        d.setInitialfirmpersonTitle(FirmsIntegration.getAsString(data, "initialfirmperson_title"));
        d.setInsolvencycheckresult(FirmsIntegration.getAsInt(data, "insolvencycheckresult"));
        d.setInsolvencycheckresultastext(FirmsIntegration.getAsString(data, "insolvencycheckresultastext"));
        d.setDateInsolvencylastcheckdatetime(FirmsIntegration.getAsTimestamp(data, "insolvencylastcheckdatetime$date"));
        d.setInvoicingdelivery(FirmsIntegration.getAsInt(data, "invoicingdelivery"));
        d.setIsregistered(FirmsIntegration.getAsBoolean(data, "isregistered"));
        d.setK0(FirmsIntegration.getAsString(data, "k0"));
        d.setK1(FirmsIntegration.getAsString(data, "k1"));
        d.setK10(FirmsIntegration.getAsString(data, "k10"));
        d.setK11(FirmsIntegration.getAsString(data, "k11"));
        d.setK12(FirmsIntegration.getAsString(data, "k12"));
        d.setK13(FirmsIntegration.getAsString(data, "k13"));
        d.setK14(FirmsIntegration.getAsString(data, "k14"));
        d.setK15(FirmsIntegration.getAsString(data, "k15"));
        d.setK2(FirmsIntegration.getAsString(data, "k2"));
        d.setK3(FirmsIntegration.getAsString(data, "k3"));
        d.setK4(FirmsIntegration.getAsString(data, "k4"));
        d.setK5(FirmsIntegration.getAsString(data, "k5"));
        d.setK6(FirmsIntegration.getAsString(data, "k6"));
        d.setK7(FirmsIntegration.getAsString(data, "k7"));
        d.setK8(FirmsIntegration.getAsString(data, "k8"));
        d.setK9(FirmsIntegration.getAsString(data, "k9"));
        d.setLegalperson(FirmsIntegration.getAsBoolean(data, "legalperson"));
        d.setLegalstatusId(FirmsIntegration.getAsString(data, "legalstatus_id"));
        d.setMainnacecodeId(FirmsIntegration.getAsString(data, "mainnacecode_id"));
        d.setMajorcorrection(FirmsIntegration.getAsBoolean(data, "majorcorrection"));
        d.setName(FirmsIntegration.getAsString(data, "name"));
        d.setNewfirmmode(FirmsIntegration.getAsInt(data, "newfirmmode"));
        d.setNote(FirmsIntegration.getAsString(data, "note"));
        d.setNpbirthnumber(FirmsIntegration.getAsString(data, "npbirthnumber"));
        d.setNpforename(FirmsIntegration.getAsString(data, "npforename"));
        d.setNpresidencepermitnumber(FirmsIntegration.getAsString(data, "npresidencepermitnumber"));
        d.setNpsurname(FirmsIntegration.getAsString(data, "npsurname"));
        d.setNptitle(FirmsIntegration.getAsString(data, "nptitle"));
        d.setObjversion(FirmsIntegration.getAsInt(data, "objversion"));
        d.setOrgidentnumber(FirmsIntegration.getAsString(data, "orgidentnumber"));
        d.setOwnershiptypeId(FirmsIntegration.getAsString(data, "ownershiptype_id"));
        d.setPaymenttypeId(FirmsIntegration.getAsString(data, "paymenttype_id"));
        d.setPayremdescription(FirmsIntegration.getAsString(data, "payremdescription"));
        d.setPayremenforcestateId(FirmsIntegration.getAsString(data, "payremenforcestate_id"));
        d.setDatePayremexcldateto(FirmsIntegration.getAsTimestamp(data, "payremexcldateto$date"));
        d.setPayremexclreason(FirmsIntegration.getAsString(data, "payremexclreason"));
        d.setDatePayremfirstsetdate(FirmsIntegration.getAsTimestamp(data, "payremfirstsetdate$date"));
        d.setPayremhandedover(FirmsIntegration.getAsBoolean(data, "payremhandedover"));
        d.setPayrempersonId(FirmsIntegration.getAsString(data, "payremperson_id"));
        d.setPenaltypercent(FirmsIntegration.getAsInt(data, "penaltypercent"));
        d.setPictureId(FirmsIntegration.getAsString(data, "picture_id"));
        d.setPrefilldiscountkind(FirmsIntegration.getAsBoolean(data, "prefilldiscountkind"));
        d.setPrefixcode(FirmsIntegration.getAsString(data, "prefixcode"));
        d.setPriceId(FirmsIntegration.getAsString(data, "price_id"));
        d.setPricelistId(FirmsIntegration.getAsString(data, "pricelist_id"));
        d.setProfitId(FirmsIntegration.getAsString(data, "profit_id"));
        d.setQuantitydiscountkind(FirmsIntegration.getAsInt(data, "quantitydiscountkind"));
        d.setDateRegisterdate(FirmsIntegration.getAsTimestamp(data, "registerdate$date"));
        d.setRegisterfileref(FirmsIntegration.getAsString(data, "registerfileref"));
        d.setRegisterkeptat(FirmsIntegration.getAsString(data, "registerkeptat"));
        d.setResidenceaddress(AddressesIntegration.convert(FirmsIntegration.getAsObject(data, "residenceaddress_id")));
        d.setResidenceaddressId(d.getResidenceaddress() != null ? d.getResidenceaddress().getAbraId() : null);
        d.setStateconsolidationunit(FirmsIntegration.getAsBoolean(data, "stateconsolidationunit"));
        d.setStoreId(FirmsIntegration.getAsString(data, "store_id"));
        d.setSuffixcode(FirmsIntegration.getAsString(data, "suffixcode"));
        d.setTaxidentnumber(FirmsIntegration.getAsString(data, "taxidentnumber"));
        d.setTurnoverId(FirmsIntegration.getAsString(data, "turnover_id"));
        d.setDateUnreliablecheckdate(FirmsIntegration.getAsTimestamp(data, "unreliablecheckdate$date"));
        d.setDateUnreliabledate(FirmsIntegration.getAsTimestamp(data, "unreliabledate$date"));
        d.setUnreliablestatus(FirmsIntegration.getAsInt(data, "unreliablestatus"));
        d.setUnreliablestatusastext(FirmsIntegration.getAsString(data, "unreliablestatusastext"));
        d.setVatcountryId(FirmsIntegration.getAsString(data, "vatcountry_id"));
        d.setVatidentnumber(FirmsIntegration.getAsString(data, "vatidentnumber"));
        d.setVatidentnumberstatus(FirmsIntegration.getAsInt(data, "vatidentnumberstatus"));
        d.setVatidentnumberstatusastext(FirmsIntegration.getAsString(data, "vatidentnumberstatusastext"));
        d.setVatpayor(FirmsIntegration.getAsBoolean(data, "vatpayor"));
        d.setVieschecklastresponsedatetime(FirmsIntegration.getAsTimestamp(data, "vieschecklastresponsedatetime"));
        d.setWwwaddress(FirmsIntegration.getAsString(data, "wwwaddress"));
        d.setAbraExternalfirmid(FirmsIntegration.getAsString(data, "x_externalfirmid"));
        JsonArray firmoffices = FirmsIntegration.getAsObjectArray(data, "firmoffices");
        if (firmoffices != null && firmoffices.size() > 0) {
            d.setFirmOfficesDomainList(FirmOfficesIntegration.convert(firmoffices));
        }
        return d;
    }

    public static FirmsDomain convertFromOrder(String prefix, JsonObject data) {
        FirmsDomain d = new FirmsDomain();
        d.setAbraId(FirmsIntegration.getAsString(data, "firm_id"));
        d.setCode(FirmsIntegration.getAsString(data, prefix + ".code"));
        d.setName(FirmsIntegration.getAsString(data, prefix + ".name"));
        d.setOrgidentnumber(FirmsIntegration.getAsString(data, prefix + ".orgidentnumber"));
        d.setResidenceaddressId(FirmsIntegration.getAsString(data, prefix + ".residenceaddress_id"));
        d.setResidenceaddress(AddressesIntegration.convertFromOrder(prefix + ".residenceaddress_id", data));
        d.setVatidentnumber(FirmsIntegration.getAsString(data, prefix + ".vatidentnumber"));
        FirmOfficesDomain firmOfficesDomain = FirmOfficesIntegration.convertFromOrder("firmoffice_id", data);
        d.setFirmOfficesDomainList(Collections.singletonList(firmOfficesDomain));
        return d;
    }
}

