/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.data;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.data.CommodityDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommodityDomainCodec
implements MessageCodec<CommodityDomain, CommodityDomain> {
    private static final Logger log = LoggerFactory.getLogger(CommodityDomainCodec.class);

    public void encodeToWire(Buffer buffer, CommodityDomain commodityDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)commodityDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public CommodityDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (CommodityDomain)gson.fromJson(jsonStr, CommodityDomain.class);
    }

    public CommodityDomain transform(CommodityDomain commodityDomain) {
        return commodityDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

