/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.InvoiceDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InvoiceDomainCodec
implements MessageCodec<InvoiceDomain, InvoiceDomain> {
    private static final Logger log = LoggerFactory.getLogger(InvoiceDomainCodec.class);

    public void encodeToWire(Buffer buffer, InvoiceDomain invoiceDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)invoiceDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public InvoiceDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (InvoiceDomain)gson.fromJson(jsonStr, InvoiceDomain.class);
    }

    public InvoiceDomain transform(InvoiceDomain invoiceDomain) {
        return invoiceDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

