/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.upgates;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.upgates.WarehouseStoreCardsMapper;
import cz.airtoy.airshop.domains.upgates.WarehouseStoreCardsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface WarehouseStoreCardsDbiDao
extends BaseDao {
    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET location_name = 'FORCE ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), date_synced = NULL, date_changed = NOW(), ident = NULL WHERE storecard_code = :byStorecardCode")
    public int updateForceSyncBeerByStorecardCode(@Bind(value="byStorecardCode") String var1);

    @SqlUpdate(value="UPDATE upgatesdeli.warehouse_store_cards SET location_name = 'FORCE ' || TO_CHAR(NOW(), 'YYYY-MM-DD HH24:MI:SS'), date_synced = NULL, date_changed = NOW(), ident = NULL WHERE storecard_code = :byStorecardCode")
    public int updateForceSyncDeliByStorecardCode(@Bind(value="byStorecardCode") String var1);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.abra_id,\n\t\tp.store_code,\n\t\tp.store_id,\n\t\tp.storecard_id,\n\t\tp.storecard_code,\n\t\tp.store_cards_id,\n\t\tp.quantity,\n\t\tp.location_code,\n\t\tp.location_name,\n\t\tp.date_synced,\n\t\tp.date_changed,\n\t\tp.date_updated,\n\t\tp.date_created,\n\t\tp.version,\n\t\tp.ident\n FROM \n\t\tupgates.warehouse_store_cards p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.store_code::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.storecard_code::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.location_code::text ~* :mask \n\tOR \n\t\tp.location_name::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tupgates.warehouse_store_cards p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.store_code::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.storecard_code::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.location_code::text ~* :mask \n\tOR \n\t\tp.location_name::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  ")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_code = :storeCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByStoreCode(@Bind(value="storeCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_code = :storeCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreCode(@Bind(value="storeCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.store_code = :storeCode")
    public long findListByStoreCodeCount(@Bind(value="storeCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_code = :storeCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreCode(@Bind(value="storeCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.storecard_id = :storecardId")
    public long findListByStorecardIdCount(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_id = :storecardId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStorecardId(@Bind(value="storecardId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_code = :storecardCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_code = :storecardCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.storecard_code = :storecardCode")
    public long findListByStorecardCodeCount(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.storecard_code = :storecardCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStorecardCode(@Bind(value="storecardCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByQuantity(@Bind(value="quantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_code = :locationCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByLocationCode(@Bind(value="locationCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_code = :locationCode")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByLocationCode(@Bind(value="locationCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.location_code = :locationCode")
    public long findListByLocationCodeCount(@Bind(value="locationCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_code = :locationCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByLocationCode(@Bind(value="locationCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_name = :locationName")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByLocationName(@Bind(value="locationName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_name = :locationName")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByLocationName(@Bind(value="locationName") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.location_name = :locationName")
    public long findListByLocationNameCount(@Bind(value="locationName") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.location_name = :locationName ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByLocationName(@Bind(value="locationName") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.date_synced = :dateSynced")
    public long findListByDateSyncedCount(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_synced = :dateSynced ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.version = :version")
    public long findListByVersionCount(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.version = :version ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByVersion(@Bind(value="version") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public WarehouseStoreCardsDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.abra_id, p.store_code, p.store_id, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.location_code, p.location_name, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsMapper.class)
    public List<WarehouseStoreCardsDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards (id, uid, abra_id, store_code, store_id, storecard_id, storecard_code, store_cards_id, quantity, location_code, location_name, date_synced, date_changed, date_updated, date_created, version, ident) VALUES (:id, :uid, :abraId, :storeCode, :storeId, :storecardId, :storecardCode, :storeCardsId, :quantity, :locationCode, :locationName, :dateSynced, :dateChanged, :dateUpdated, :dateCreated, :version, :ident)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="abraId") String var3, @Bind(value="storeCode") String var4, @Bind(value="storeId") Long var5, @Bind(value="storecardId") String var6, @Bind(value="storecardCode") String var7, @Bind(value="storeCardsId") Long var8, @Bind(value="quantity") Double var9, @Bind(value="locationCode") String var10, @Bind(value="locationName") String var11, @Bind(value="dateSynced") Date var12, @Bind(value="dateChanged") Date var13, @Bind(value="dateUpdated") Date var14, @Bind(value="dateCreated") Date var15, @Bind(value="version") Integer var16, @Bind(value="ident") String var17);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards (abra_id, store_code, store_id, storecard_id, storecard_code, store_cards_id, quantity, location_code, location_name, date_synced, date_changed, date_updated, date_created, version, ident) VALUES (:e.abraId, :e.storeCode, :e.storeId, :e.storecardId, :e.storecardCode, :e.storeCardsId, :e.quantity, :e.locationCode, :e.locationName, :e.dateSynced, :e.dateChanged, :e.dateUpdated, :e.dateCreated, :e.version, :e.ident)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") WarehouseStoreCardsDomain var1);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE id = :byId")
    public int updateById(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE store_code = :byStoreCode")
    public int updateByStoreCode(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byStoreCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE storecard_id = :byStorecardId")
    public int updateByStorecardId(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byStorecardId") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE storecard_code = :byStorecardCode")
    public int updateByStorecardCode(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byStorecardCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byQuantity") Double var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE location_code = :byLocationCode")
    public int updateByLocationCode(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byLocationCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE location_name = :byLocationName")
    public int updateByLocationName(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byLocationName") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_synced = :byDateSynced")
    public int updateByDateSynced(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byDateSynced") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE version = :byVersion")
    public int updateByVersion(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byVersion") Integer var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards SET id = :e.id, uid = :e.uid, abra_id = :e.abraId, store_code = :e.storeCode, store_id = :e.storeId, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, location_code = :e.locationCode, location_name = :e.locationName, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") WarehouseStoreCardsDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE store_code = :storeCode")
    public int deleteByStoreCode(@Bind(value="storeCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE storecard_id = :storecardId")
    public int deleteByStorecardId(@Bind(value="storecardId") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE storecard_code = :storecardCode")
    public int deleteByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Double var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE location_code = :locationCode")
    public int deleteByLocationCode(@Bind(value="locationCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE location_name = :locationName")
    public int deleteByLocationName(@Bind(value="locationName") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE date_synced = :dateSynced")
    public int deleteByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE version = :version")
    public int deleteByVersion(@Bind(value="version") Integer var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);
}

