/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.fc;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.fc.SeqAddressMapper;
import cz.airtoy.airshop.domains.fc.SeqAddressDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SeqAddressDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.source,\n\t\tp.orderid,\n\t\tp.email,\n\t\tp.addressid,\n\t\tp.date_created\n FROM \n\t\tfc.seq_address p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.orderid::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.addressid::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tfc.seq_address p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.orderid::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.addressid::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.source = :source AND p.orderid = :orderid AND p.email = :email AND p.addressid = :addressid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findBySourceOrderidEmailAddressid(@Bind(value="source") String var1, @Bind(value="orderid") Integer var2, @Bind(value="email") String var3, @Bind(value="addressid") Long var4);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.id = :id")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.id = :id")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.source = :source")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.source = :source")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.orderid = :orderid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findByOrderid(@Bind(value="orderid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.orderid = :orderid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByOrderid(@Bind(value="orderid") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.orderid = :orderid")
    public long findListByOrderidCount(@Bind(value="orderid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.orderid = :orderid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByOrderid(@Bind(value="orderid") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.email = :email")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.email = :email")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.email = :email")
    public long findListByEmailCount(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.email = :email ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByEmail(@Bind(value="email") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.addressid = :addressid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findByAddressid(@Bind(value="addressid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.addressid = :addressid")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByAddressid(@Bind(value="addressid") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.addressid = :addressid")
    public long findListByAddressidCount(@Bind(value="addressid") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.addressid = :addressid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByAddressid(@Bind(value="addressid") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public SeqAddressDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM fc.seq_address p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.source, p.orderid, p.email, p.addressid, p.date_created FROM fc.seq_address p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SeqAddressMapper.class)
    public List<SeqAddressDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO fc.seq_address (id, uid, source, orderid, email, addressid, date_created) VALUES (:id, :uid, :source, :orderid, :email, :addressid, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="source") String var3, @Bind(value="orderid") Integer var4, @Bind(value="email") String var5, @Bind(value="addressid") Integer var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO fc.seq_address (source, orderid, email, addressid, date_created) VALUES (:e.source, :e.orderid, :e.email, :e.addressid, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SeqAddressDomain var1);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE orderid = :byOrderid")
    public int updateByOrderid(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byOrderid") Integer var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE email = :byEmail")
    public int updateByEmail(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byEmail") String var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE addressid = :byAddressid")
    public int updateByAddressid(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byAddressid") Integer var2);

    @SqlUpdate(value="UPDATE fc.seq_address SET id = :e.id, uid = :e.uid, source = :e.source, orderid = :e.orderid, email = :e.email, addressid = :e.addressid, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SeqAddressDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE orderid = :orderid")
    public int deleteByOrderid(@Bind(value="orderid") Integer var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE email = :email")
    public int deleteByEmail(@Bind(value="email") String var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE addressid = :addressid")
    public int deleteByAddressid(@Bind(value="addressid") Integer var1);

    @SqlUpdate(value="DELETE FROM fc.seq_address WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

