/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.SalesRequestMapper;
import cz.airtoy.airshop.domains.SalesRequestDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SalesRequestDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.status,\n\t\tp.store_id,\n\t\tp.name,\n\t\tp.description,\n\t\tp.order_id,\n\t\tp.partner_id,\n\t\tp.date_for,\n\t\tp.date_planned_receive,\n\t\tp.date_received,\n\t\tp.date_finished,\n\t\tp.updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.sales_request p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.sales_request p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.store_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.order_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.date_for::text ~* :mask \n\tOR \n\t\tp.date_planned_receive::text ~* :mask \n\tOR \n\t\tp.date_received::text ~* :mask \n\tOR \n\t\tp.date_finished::text ~* :mask \n\tOR \n\t\tp.updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  ")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.id = :id")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.id = :id")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.status = :status")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.status = :status")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.store_id = :storeId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByStoreId(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.store_id = :storeId")
    public long findListByStoreIdCount(@Bind(value="storeId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.store_id = :storeId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByStoreId(@Bind(value="storeId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.name = :name")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.name = :name")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.description = :description")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.description = :description")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.order_id = :orderId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByOrderId(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.order_id = :orderId")
    public long findListByOrderIdCount(@Bind(value="orderId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.order_id = :orderId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByOrderId(@Bind(value="orderId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_for = :dateFor")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDateFor(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_for = :dateFor")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateFor(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.date_for = :dateFor")
    public long findListByDateForCount(@Bind(value="dateFor") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_for = :dateFor ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateFor(@Bind(value="dateFor") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_planned_receive = :datePlannedReceive")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_planned_receive = :datePlannedReceive")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.date_planned_receive = :datePlannedReceive")
    public long findListByDatePlannedReceiveCount(@Bind(value="datePlannedReceive") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_planned_receive = :datePlannedReceive ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_received = :dateReceived")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.date_received = :dateReceived")
    public long findListByDateReceivedCount(@Bind(value="dateReceived") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_received = :dateReceived ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateReceived(@Bind(value="dateReceived") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_finished = :dateFinished")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.date_finished = :dateFinished")
    public long findListByDateFinishedCount(@Bind(value="dateFinished") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_finished = :dateFinished ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateFinished(@Bind(value="dateFinished") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.updated = :updated")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByUpdated(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.updated = :updated")
    public long findListByUpdatedCount(@Bind(value="updated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.updated = :updated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByUpdated(@Bind(value="updated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.note = :note")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.note = :note")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public SalesRequestDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.sales_request p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.status, p.store_id, p.name, p.description, p.order_id, p.partner_id, p.date_for, p.date_planned_receive, p.date_received, p.date_finished, p.updated, p.note, p.date_created FROM abra.sales_request p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SalesRequestMapper.class)
    public List<SalesRequestDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.sales_request (id, uid, status, store_id, name, description, order_id, partner_id, date_for, date_planned_receive, date_received, date_finished, updated, note, date_created) VALUES (:id, :uid, :status, :storeId, :name, :description, :orderId, :partnerId, :dateFor, :datePlannedReceive, :dateReceived, :dateFinished, :updated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="status") String var3, @Bind(value="storeId") Long var4, @Bind(value="name") String var5, @Bind(value="description") String var6, @Bind(value="orderId") Long var7, @Bind(value="partnerId") Long var8, @Bind(value="dateFor") Date var9, @Bind(value="datePlannedReceive") Date var10, @Bind(value="dateReceived") Date var11, @Bind(value="dateFinished") Date var12, @Bind(value="updated") Date var13, @Bind(value="note") String var14, @Bind(value="dateCreated") Date var15);

    @SqlUpdate(value="INSERT INTO abra.sales_request (status, store_id, name, description, order_id, partner_id, date_for, date_planned_receive, date_received, date_finished, updated, note, date_created) VALUES (:e.status, :e.storeId, :e.name, :e.description, :e.orderId, :e.partnerId, :e.dateFor, :e.datePlannedReceive, :e.dateReceived, :e.dateFinished, :e.updated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SalesRequestDomain var1);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE store_id = :byStoreId")
    public int updateByStoreId(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byStoreId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE order_id = :byOrderId")
    public int updateByOrderId(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byOrderId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_for = :byDateFor")
    public int updateByDateFor(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDateFor") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_planned_receive = :byDatePlannedReceive")
    public int updateByDatePlannedReceive(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDatePlannedReceive") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_received = :byDateReceived")
    public int updateByDateReceived(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDateReceived") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_finished = :byDateFinished")
    public int updateByDateFinished(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDateFinished") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE updated = :byUpdated")
    public int updateByUpdated(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byUpdated") Date var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.sales_request SET id = :e.id, uid = :e.uid, status = :e.status, store_id = :e.storeId, name = :e.name, description = :e.description, order_id = :e.orderId, partner_id = :e.partnerId, date_for = :e.dateFor, date_planned_receive = :e.datePlannedReceive, date_received = :e.dateReceived, date_finished = :e.dateFinished, updated = :e.updated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SalesRequestDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE store_id = :storeId")
    public int deleteByStoreId(@Bind(value="storeId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE order_id = :orderId")
    public int deleteByOrderId(@Bind(value="orderId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE date_for = :dateFor")
    public int deleteByDateFor(@Bind(value="dateFor") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE date_planned_receive = :datePlannedReceive")
    public int deleteByDatePlannedReceive(@Bind(value="datePlannedReceive") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE date_received = :dateReceived")
    public int deleteByDateReceived(@Bind(value="dateReceived") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE date_finished = :dateFinished")
    public int deleteByDateFinished(@Bind(value="dateFinished") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE updated = :updated")
    public int deleteByUpdated(@Bind(value="updated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.sales_request WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

