/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import com.codahale.metrics.health.HealthCheckRegistry;
import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import io.dropwizard.db.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PostgreSqlDS {
    private static final Logger log = LoggerFactory.getLogger(PostgreSqlDS.class);
    private static final int MAX_POOL_SIZE = 10;
    private static final DataSourceFactory sqlConfig = new DataSourceFactory();

    public static HikariDataSource getDataSource(String jdbc) {
        try {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDriverClassName("org.postgresql.Driver");
            config.setJdbcUrl(jdbc);
            return new HikariDataSource(config);
        }
        catch (Exception e) {
            log.error("Cannot connect to PostgreSQL DB " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public static HikariDataSource getDataSource(String jdbc, HealthCheckRegistry healthCheckRegistry) {
        try {
            HikariConfig config = new HikariConfig();
            config.setMaximumPoolSize(10);
            config.setDriverClassName("org.postgresql.Driver");
            config.setJdbcUrl(jdbc);
            config.setHealthCheckRegistry((Object)healthCheckRegistry);
            config.addHealthCheckProperty("connectivityCheckTimeoutMs", "1000");
            config.addHealthCheckProperty("expected99thPercentileMs", "10");
            return new HikariDataSource(config);
        }
        catch (Exception e) {
            log.error("Cannot connect to PostgreSQL DB " + e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

