/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration.common;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(BaseIntegration.class);

    public static String convertId(JsonObject data) {
        return BaseIntegration.getAsString(data, "ID");
    }

    public static String getAsString(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return el.getAsString();
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as String " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static JsonObject getAsObject(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return el.getAsJsonObject();
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as JsonObject " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static JsonArray getAsObjectArray(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return el.getAsJsonArray();
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as JsonArray " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Long getAsLong(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return Long.parseLong(el.getAsString());
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Long " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Integer getAsInt(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return Integer.parseInt(el.getAsString());
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Integer " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Double getAsDouble(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return Double.parseDouble(el.getAsString());
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Integer " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Float getAsFloat(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return Float.valueOf(Float.parseFloat(el.getAsString()));
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Float " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static BigDecimal getAsBigDecimal(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return new BigDecimal(el.getAsString());
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as BigDecimal " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Boolean getAsBoolean(JsonObject data, String field) {
        JsonElement el;
        if (field != null && (el = data.get(field)) != null && !el.isJsonNull()) {
            try {
                return Boolean.parseBoolean(el.getAsString());
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Boolean " + e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    protected static Date getAsTimestamp(JsonObject data, String field) {
        String str;
        JsonElement el;
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS");
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd.MM.yyyy");
        if (!(field == null || (el = data.get(field)) == null || el.isJsonNull() || (str = el.getAsString()) == null || "\"\"".equalsIgnoreCase(str) || str.isEmpty())) {
            try {
                return formatter.parse(str);
            }
            catch (Exception e) {
                log.error("Cannot return " + field + " as Timestamp " + e.getMessage());
                try {
                    return formatter1.parse(str);
                }
                catch (Exception e1) {
                    log.error("Cannot return " + field + " as Timestamp1 " + e1.getMessage());
                }
            }
        }
        return null;
    }
}

