/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.vectron;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.vectron.VectronPosCommandLogMapper;
import cz.airtoy.airshop.domains.vectron.VectronPosCommandLogDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface VectronPosCommandLogDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.cash_register_id,\n\t\tp.vectron_pos_sales_id,\n\t\tp.ident,\n\t\tp.payment_type,\n\t\tp.order_source,\n\t\tp.username,\n\t\tp.amount,\n\t\tp.payment_reference_number,\n\t\tp.point_of_sale,\n\t\tp.point_of_sale_timestamp,\n\t\tp.user_input,\n\t\tp.date_created\n FROM \n\t\tvectron.vectron_pos_command_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.cash_register_id::text ~* :mask \n\tOR \n\t\tp.vectron_pos_sales_id::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.order_source::text ~* :mask \n\tOR \n\t\tp.username::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_reference_number::text ~* :mask \n\tOR \n\t\tp.point_of_sale::text ~* :mask \n\tOR \n\t\tp.point_of_sale_timestamp::text ~* :mask \n\tOR \n\t\tp.user_input::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tvectron.vectron_pos_command_log p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.cash_register_id::text ~* :mask \n\tOR \n\t\tp.vectron_pos_sales_id::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.order_source::text ~* :mask \n\tOR \n\t\tp.username::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_reference_number::text ~* :mask \n\tOR \n\t\tp.point_of_sale::text ~* :mask \n\tOR \n\t\tp.point_of_sale_timestamp::text ~* :mask \n\tOR \n\t\tp.user_input::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId AND p.vectron_pos_sales_id IS NULL")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByCashRegisterIdNoPosSaleId(@Bind(value="cashRegisterId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId AND p.vectron_pos_sales_id IS NULL AND p.point_of_sale_timestamp::DATE = :dateFor")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByCashRegisterIdNoPosSaleId(@Bind(value="cashRegisterId") Long var1, @Bind(value="dateFor") Date var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId AND p.vectron_pos_sales_id IS NULL AND p.point_of_sale_timestamp::DATE = :dateFor LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByCashRegisterIdNoPosSaleId(@Bind(value="cashRegisterId") Long var1, @Bind(value="dateFor") Date var2, @Bind(value="limit") int var3);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  ")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p WHERE p.point_of_sale_timestamp::DATE = NOW()::DATE ")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListAllToday();

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p WHERE p.point_of_sale_timestamp::DATE = :pointOfSaleTimestamp ")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListAllFor(@Bind(value="pointOfSaleTimestamp") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.id = :id")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByCashRegisterId(@Bind(value="cashRegisterId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByCashRegisterId(@Bind(value="cashRegisterId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId")
    public long findListByCashRegisterIdCount(@Bind(value="cashRegisterId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.cash_register_id = :cashRegisterId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByCashRegisterId(@Bind(value="cashRegisterId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.vectron_pos_sales_id = :vectronPosSalesId")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByVectronPosSalesId(@Bind(value="vectronPosSalesId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.vectron_pos_sales_id = :vectronPosSalesId")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByVectronPosSalesId(@Bind(value="vectronPosSalesId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.vectron_pos_sales_id = :vectronPosSalesId")
    public long findListByVectronPosSalesIdCount(@Bind(value="vectronPosSalesId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.vectron_pos_sales_id = :vectronPosSalesId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByVectronPosSalesId(@Bind(value="vectronPosSalesId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.payment_type = :paymentType")
    public long findListByPaymentTypeCount(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_type = :paymentType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPaymentType(@Bind(value="paymentType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.order_source = :orderSource")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByOrderSource(@Bind(value="orderSource") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.order_source = :orderSource")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByOrderSource(@Bind(value="orderSource") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.order_source = :orderSource")
    public long findListByOrderSourceCount(@Bind(value="orderSource") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.order_source = :orderSource ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByOrderSource(@Bind(value="orderSource") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.username = :username")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByUsername(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.username = :username")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByUsername(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.username = :username")
    public long findListByUsernameCount(@Bind(value="username") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.username = :username ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByUsername(@Bind(value="username") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.amount = :amount")
    public long findListByAmountCount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.amount = :amount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByAmount(@Bind(value="amount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_reference_number = :paymentReferenceNumber")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByPaymentReferenceNumber(@Bind(value="paymentReferenceNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_reference_number = :paymentReferenceNumber")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPaymentReferenceNumber(@Bind(value="paymentReferenceNumber") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.payment_reference_number = :paymentReferenceNumber")
    public long findListByPaymentReferenceNumberCount(@Bind(value="paymentReferenceNumber") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.payment_reference_number = :paymentReferenceNumber ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPaymentReferenceNumber(@Bind(value="paymentReferenceNumber") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale = :pointOfSale")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByPointOfSale(@Bind(value="pointOfSale") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale = :pointOfSale")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPointOfSale(@Bind(value="pointOfSale") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale = :pointOfSale")
    public long findListByPointOfSaleCount(@Bind(value="pointOfSale") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale = :pointOfSale ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPointOfSale(@Bind(value="pointOfSale") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale_timestamp = :pointOfSaleTimestamp")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByPointOfSaleTimestamp(@Bind(value="pointOfSaleTimestamp") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale_timestamp = :pointOfSaleTimestamp")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPointOfSaleTimestamp(@Bind(value="pointOfSaleTimestamp") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale_timestamp = :pointOfSaleTimestamp")
    public long findListByPointOfSaleTimestampCount(@Bind(value="pointOfSaleTimestamp") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.point_of_sale_timestamp = :pointOfSaleTimestamp ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByPointOfSaleTimestamp(@Bind(value="pointOfSaleTimestamp") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public VectronPosCommandLogDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM vectron.vectron_pos_command_log p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.cash_register_id, p.vectron_pos_sales_id, p.ident, p.payment_type, p.order_source, p.username, p.amount, p.payment_reference_number, p.point_of_sale, p.point_of_sale_timestamp, p.user_input, p.date_created FROM vectron.vectron_pos_command_log p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=VectronPosCommandLogMapper.class)
    public List<VectronPosCommandLogDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO vectron.vectron_pos_command_log (id, uid, cash_register_id, vectron_pos_sales_id, ident, payment_type, order_source, username, amount, payment_reference_number, point_of_sale, point_of_sale_timestamp, date_created) VALUES (:id, :uid, :cashRegisterId, :vectronPosSalesId, :ident, :paymentType, :orderSource, :username, :amount, :paymentReferenceNumber, :pointOfSale, :pointOfSaleTimestamp, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="cashRegisterId") Long var3, @Bind(value="vectronPosSalesId") Long var4, @Bind(value="ident") String var5, @Bind(value="paymentType") String var6, @Bind(value="orderSource") String var7, @Bind(value="username") String var8, @Bind(value="amount") Double var9, @Bind(value="paymentReferenceNumber") String var10, @Bind(value="pointOfSale") String var11, @Bind(value="pointOfSaleTimestamp") Date var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO vectron.vectron_pos_command_log (cash_register_id, vectron_pos_sales_id, ident, payment_type, order_source, username, amount, payment_reference_number, point_of_sale, point_of_sale_timestamp, user_input, date_created) VALUES (:e.cashRegisterId, :e.vectronPosSalesId, :e.ident, :e.paymentType, :e.orderSource, :e.username, :e.amount, :e.paymentReferenceNumber, :e.pointOfSale, :e.pointOfSaleTimestamp, :e.userInput, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") VectronPosCommandLogDomain var1);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE cash_register_id = :byCashRegisterId")
    public int updateByCashRegisterId(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byCashRegisterId") Long var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE vectron_pos_sales_id = :byVectronPosSalesId")
    public int updateByVectronPosSalesId(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byVectronPosSalesId") Long var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE payment_type = :byPaymentType")
    public int updateByPaymentType(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byPaymentType") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE order_source = :byOrderSource")
    public int updateByOrderSource(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byOrderSource") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE username = :byUsername")
    public int updateByUsername(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byUsername") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE amount = :byAmount")
    public int updateByAmount(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byAmount") Double var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE payment_reference_number = :byPaymentReferenceNumber")
    public int updateByPaymentReferenceNumber(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byPaymentReferenceNumber") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE point_of_sale = :byPointOfSale")
    public int updateByPointOfSale(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byPointOfSale") String var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE point_of_sale_timestamp = :byPointOfSaleTimestamp")
    public int updateByPointOfSaleTimestamp(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byPointOfSaleTimestamp") Date var2);

    @SqlUpdate(value="UPDATE vectron.vectron_pos_command_log SET id = :e.id, uid = :e.uid, cash_register_id = :e.cashRegisterId, vectron_pos_sales_id = :e.vectronPosSalesId, ident = :e.ident, payment_type = :e.paymentType, order_source = :e.orderSource, username = :e.username, amount = :e.amount, payment_reference_number = :e.paymentReferenceNumber, point_of_sale = :e.pointOfSale, point_of_sale_timestamp = :e.pointOfSaleTimestamp, user_input = :e.userInput, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") VectronPosCommandLogDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE cash_register_id = :cashRegisterId")
    public int deleteByCashRegisterId(@Bind(value="cashRegisterId") Long var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE vectron_pos_sales_id = :vectronPosSalesId")
    public int deleteByVectronPosSalesId(@Bind(value="vectronPosSalesId") Long var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE payment_type = :paymentType")
    public int deleteByPaymentType(@Bind(value="paymentType") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE order_source = :orderSource")
    public int deleteByOrderSource(@Bind(value="orderSource") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE username = :username")
    public int deleteByUsername(@Bind(value="username") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE amount = :amount")
    public int deleteByAmount(@Bind(value="amount") Double var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE payment_reference_number = :paymentReferenceNumber")
    public int deleteByPaymentReferenceNumber(@Bind(value="paymentReferenceNumber") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE point_of_sale = :pointOfSale")
    public int deleteByPointOfSale(@Bind(value="pointOfSale") String var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE point_of_sale_timestamp = :pointOfSaleTimestamp")
    public int deleteByPointOfSaleTimestamp(@Bind(value="pointOfSaleTimestamp") Date var1);

    @SqlUpdate(value="DELETE FROM vectron.vectron_pos_command_log WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

