/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.upgates;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.upgates.ProductDescriptionsMapper;
import cz.airtoy.airshop.domains.upgates.ProductDescriptionsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ProductDescriptionsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.product_id = :productId AND p.language = :language")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByProductIdLanguage(@Bind(value="productId") Long var1, @Bind(value="language") String var2);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgatesdeli.product_descriptions p  WHERE p.product_id = :productId AND p.language = :language")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findDeliByProductIdLanguage(@Bind(value="productId") Long var1, @Bind(value="language") String var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.product_id,\n\t\tp.language,\n\t\tp.title,\n\t\tp.short_description,\n\t\tp.long_description,\n\t\tp.url,\n\t\tp.seo_title,\n\t\tp.seo_description,\n\t\tp.seo_url,\n\t\tp.unit,\n\t\tp.source,\n\t\tp.date_changed,\n\t\tp.date_created,\n\t\tp.version\n FROM \n\t\tupgates.product_descriptions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.product_id::text ~* :mask \n\tOR \n\t\tp.language::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.short_description::text ~* :mask \n\tOR \n\t\tp.long_description::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.seo_title::text ~* :mask \n\tOR \n\t\tp.seo_description::text ~* :mask \n\tOR \n\t\tp.seo_url::text ~* :mask \n\tOR \n\t\tp.unit::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tupgates.product_descriptions p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.product_id::text ~* :mask \n\tOR \n\t\tp.language::text ~* :mask \n\tOR \n\t\tp.title::text ~* :mask \n\tOR \n\t\tp.short_description::text ~* :mask \n\tOR \n\t\tp.long_description::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.seo_title::text ~* :mask \n\tOR \n\t\tp.seo_description::text ~* :mask \n\tOR \n\t\tp.seo_url::text ~* :mask \n\tOR \n\t\tp.unit::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  ")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.id = :id")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.id = :id")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.product_id = :productId")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByProductId(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.product_id = :productId")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByProductId(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.product_id = :productId")
    public long findListByProductIdCount(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.product_id = :productId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByProductId(@Bind(value="productId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.language = :language")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByLanguage(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.language = :language")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByLanguage(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.language = :language")
    public long findListByLanguageCount(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.language = :language ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByLanguage(@Bind(value="language") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.title = :title")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.title = :title")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByTitle(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.title = :title")
    public long findListByTitleCount(@Bind(value="title") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.title = :title ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByTitle(@Bind(value="title") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.short_description = :shortDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByShortDescription(@Bind(value="shortDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.short_description = :shortDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByShortDescription(@Bind(value="shortDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.short_description = :shortDescription")
    public long findListByShortDescriptionCount(@Bind(value="shortDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.short_description = :shortDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByShortDescription(@Bind(value="shortDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.long_description = :longDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByLongDescription(@Bind(value="longDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.long_description = :longDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByLongDescription(@Bind(value="longDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.long_description = :longDescription")
    public long findListByLongDescriptionCount(@Bind(value="longDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.long_description = :longDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByLongDescription(@Bind(value="longDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.url = :url")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.url = :url")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.url = :url")
    public long findListByUrlCount(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.url = :url ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByUrl(@Bind(value="url") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_title = :seoTitle")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findBySeoTitle(@Bind(value="seoTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_title = :seoTitle")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoTitle(@Bind(value="seoTitle") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.seo_title = :seoTitle")
    public long findListBySeoTitleCount(@Bind(value="seoTitle") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_title = :seoTitle ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoTitle(@Bind(value="seoTitle") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_description = :seoDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findBySeoDescription(@Bind(value="seoDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_description = :seoDescription")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoDescription(@Bind(value="seoDescription") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.seo_description = :seoDescription")
    public long findListBySeoDescriptionCount(@Bind(value="seoDescription") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_description = :seoDescription ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoDescription(@Bind(value="seoDescription") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_url = :seoUrl")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findBySeoUrl(@Bind(value="seoUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_url = :seoUrl")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoUrl(@Bind(value="seoUrl") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.seo_url = :seoUrl")
    public long findListBySeoUrlCount(@Bind(value="seoUrl") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.seo_url = :seoUrl ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySeoUrl(@Bind(value="seoUrl") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.unit = :unit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByUnit(@Bind(value="unit") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.unit = :unit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByUnit(@Bind(value="unit") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.unit = :unit")
    public long findListByUnitCount(@Bind(value="unit") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.unit = :unit ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByUnit(@Bind(value="unit") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.source = :source")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.source = :source")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.version = :version")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public ProductDescriptionsDomain findByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.version = :version")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_descriptions p  WHERE p.version = :version")
    public long findListByVersionCount(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.language, p.title, p.short_description, p.long_description, p.url, p.seo_title, p.seo_description, p.seo_url, p.unit, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_descriptions p  WHERE p.version = :version ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductDescriptionsMapper.class)
    public List<ProductDescriptionsDomain> findListByVersion(@Bind(value="version") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO upgates.product_descriptions (id, product_id, language, title, short_description, long_description, url, seo_title, seo_description, seo_url, unit, source, date_changed, date_created, version) VALUES (:id, :productId, :language, :title, :shortDescription, :longDescription, :url, :seoTitle, :seoDescription, :seoUrl, :unit, :source, :dateChanged, :dateCreated, :version)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="productId") Long var2, @Bind(value="language") String var3, @Bind(value="title") String var4, @Bind(value="shortDescription") String var5, @Bind(value="longDescription") String var6, @Bind(value="url") String var7, @Bind(value="seoTitle") String var8, @Bind(value="seoDescription") String var9, @Bind(value="seoUrl") String var10, @Bind(value="unit") String var11, @Bind(value="source") String var12, @Bind(value="dateChanged") Date var13, @Bind(value="dateCreated") Date var14, @Bind(value="version") Integer var15);

    @SqlUpdate(value="INSERT INTO upgates.product_descriptions (product_id, language, title, short_description, long_description, url, seo_title, seo_description, seo_url, unit, source, date_changed, date_created, version) VALUES (:e.productId, :e.language, :e.title, :e.shortDescription, :e.longDescription, :e.url, :e.seoTitle, :e.seoDescription, :e.seoUrl, :e.unit, :e.source, :e.dateChanged, :e.dateCreated, :e.version)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ProductDescriptionsDomain var1);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE id = :byId")
    public int updateById(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE product_id = :byProductId")
    public int updateByProductId(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byProductId") Long var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE language = :byLanguage")
    public int updateByLanguage(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byLanguage") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE title = :byTitle")
    public int updateByTitle(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byTitle") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE short_description = :byShortDescription")
    public int updateByShortDescription(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byShortDescription") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE long_description = :byLongDescription")
    public int updateByLongDescription(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byLongDescription") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE url = :byUrl")
    public int updateByUrl(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byUrl") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE seo_title = :bySeoTitle")
    public int updateBySeoTitle(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="bySeoTitle") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE seo_description = :bySeoDescription")
    public int updateBySeoDescription(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="bySeoDescription") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE seo_url = :bySeoUrl")
    public int updateBySeoUrl(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="bySeoUrl") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE unit = :byUnit")
    public int updateByUnit(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byUnit") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_descriptions SET id = :e.id, product_id = :e.productId, language = :e.language, title = :e.title, short_description = :e.shortDescription, long_description = :e.longDescription, url = :e.url, seo_title = :e.seoTitle, seo_description = :e.seoDescription, seo_url = :e.seoUrl, unit = :e.unit, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE version = :byVersion")
    public int updateByVersion(@BindBean(value="e") ProductDescriptionsDomain var1, @Bind(value="byVersion") Integer var2);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE product_id = :productId")
    public int deleteByProductId(@Bind(value="productId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE language = :language")
    public int deleteByLanguage(@Bind(value="language") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE title = :title")
    public int deleteByTitle(@Bind(value="title") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE short_description = :shortDescription")
    public int deleteByShortDescription(@Bind(value="shortDescription") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE long_description = :longDescription")
    public int deleteByLongDescription(@Bind(value="longDescription") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE url = :url")
    public int deleteByUrl(@Bind(value="url") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE seo_title = :seoTitle")
    public int deleteBySeoTitle(@Bind(value="seoTitle") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE seo_description = :seoDescription")
    public int deleteBySeoDescription(@Bind(value="seoDescription") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE seo_url = :seoUrl")
    public int deleteBySeoUrl(@Bind(value="seoUrl") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE unit = :unit")
    public int deleteByUnit(@Bind(value="unit") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_descriptions WHERE version = :version")
    public int deleteByVersion(@Bind(value="version") Integer var1);
}

