/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.shops;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.shops.BeerShopInfoMapper;
import cz.airtoy.airshop.domains.shops.BeerShopInfoDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface BeerShopInfoDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.shop_code,\n\t\tp.beer_id,\n\t\tp.ord,\n\t\tp.visible,\n\t\tp.date_visible_from,\n\t\tp.date_visible_to,\n\t\tp.status,\n\t\tp.volume,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tshops.beer_shop_info p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.shop_code::text ~* :mask \n\tOR \n\t\tp.beer_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.visible::text ~* :mask \n\tOR \n\t\tp.date_visible_from::text ~* :mask \n\tOR \n\t\tp.date_visible_to::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tshops.beer_shop_info p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.shop_code::text ~* :mask \n\tOR \n\t\tp.beer_id::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.visible::text ~* :mask \n\tOR \n\t\tp.date_visible_from::text ~* :mask \n\tOR \n\t\tp.date_visible_to::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.volume::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  ")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.shop_code = :shopCode")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByShopCode(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.shop_code = :shopCode")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByShopCode(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.shop_code = :shopCode")
    public long findListByShopCodeCount(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.shop_code = :shopCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByShopCode(@Bind(value="shopCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.beer_id = :beerId")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByBeerId(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.beer_id = :beerId")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByBeerId(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.beer_id = :beerId")
    public long findListByBeerIdCount(@Bind(value="beerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.beer_id = :beerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByBeerId(@Bind(value="beerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.visible = :visible")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByVisible(@Bind(value="visible") Integer var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.visible = :visible")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByVisible(@Bind(value="visible") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.visible = :visible")
    public long findListByVisibleCount(@Bind(value="visible") Integer var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.visible = :visible ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByVisible(@Bind(value="visible") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_from = :dateVisibleFrom")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByDateVisibleFrom(@Bind(value="dateVisibleFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_from = :dateVisibleFrom")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateVisibleFrom(@Bind(value="dateVisibleFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.date_visible_from = :dateVisibleFrom")
    public long findListByDateVisibleFromCount(@Bind(value="dateVisibleFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_from = :dateVisibleFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateVisibleFrom(@Bind(value="dateVisibleFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_to = :dateVisibleTo")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByDateVisibleTo(@Bind(value="dateVisibleTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_to = :dateVisibleTo")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateVisibleTo(@Bind(value="dateVisibleTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.date_visible_to = :dateVisibleTo")
    public long findListByDateVisibleToCount(@Bind(value="dateVisibleTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_visible_to = :dateVisibleTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateVisibleTo(@Bind(value="dateVisibleTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.status = :status")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.status = :status")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.volume = :volume")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByVolume(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.volume = :volume")
    public long findListByVolumeCount(@Bind(value="volume") Double var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.volume = :volume ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByVolume(@Bind(value="volume") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public BeerShopInfoDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_info p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.shop_code, p.beer_id, p.ord, p.visible, p.date_visible_from, p.date_visible_to, p.status, p.volume, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_info p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopInfoMapper.class)
    public List<BeerShopInfoDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO shops.beer_shop_info (id, shop_code, beer_id, ord, visible, date_visible_from, date_visible_to, status, volume, date_changed, user_changed, note, date_created) VALUES (:id, :shopCode, :beerId, :ord, :visible, :dateVisibleFrom, :dateVisibleTo, :status, :volume, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="shopCode") String var2, @Bind(value="beerId") Long var3, @Bind(value="ord") Integer var4, @Bind(value="visible") Integer var5, @Bind(value="dateVisibleFrom") Date var6, @Bind(value="dateVisibleTo") Date var7, @Bind(value="status") String var8, @Bind(value="volume") Double var9, @Bind(value="dateChanged") Date var10, @Bind(value="userChanged") String var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO shops.beer_shop_info (shop_code, beer_id, ord, visible, date_visible_from, date_visible_to, status, volume, date_changed, user_changed, note, date_created) VALUES (:e.shopCode, :e.beerId, :e.ord, :e.visible, :e.dateVisibleFrom, :e.dateVisibleTo, :e.status, :e.volume, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") BeerShopInfoDomain var1);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE shop_code = :byShopCode")
    public int updateByShopCode(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byShopCode") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE beer_id = :byBeerId")
    public int updateByBeerId(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byBeerId") Long var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE visible = :byVisible")
    public int updateByVisible(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byVisible") Integer var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_visible_from = :byDateVisibleFrom")
    public int updateByDateVisibleFrom(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byDateVisibleFrom") Date var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_visible_to = :byDateVisibleTo")
    public int updateByDateVisibleTo(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byDateVisibleTo") Date var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE volume = :byVolume")
    public int updateByVolume(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byVolume") Double var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_info SET id = :e.id, shop_code = :e.shopCode, beer_id = :e.beerId, ord = :e.ord, visible = :e.visible, date_visible_from = :e.dateVisibleFrom, date_visible_to = :e.dateVisibleTo, status = :e.status, volume = :e.volume, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") BeerShopInfoDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE shop_code = :shopCode")
    public int deleteByShopCode(@Bind(value="shopCode") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE beer_id = :beerId")
    public int deleteByBeerId(@Bind(value="beerId") Long var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE visible = :visible")
    public int deleteByVisible(@Bind(value="visible") Integer var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE date_visible_from = :dateVisibleFrom")
    public int deleteByDateVisibleFrom(@Bind(value="dateVisibleFrom") Date var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE date_visible_to = :dateVisibleTo")
    public int deleteByDateVisibleTo(@Bind(value="dateVisibleTo") Date var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE volume = :volume")
    public int deleteByVolume(@Bind(value="volume") Double var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_info WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

