/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.ReservationMapper;
import cz.airtoy.airshop.domains.renting.ReservationDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ReservationDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.customer_id,\n\t\tp.partner_id,\n\t\tp.deposit_id,\n\t\tp.date_from,\n\t\tp.date_to,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.reservation p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.deposit_id::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.reservation p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.deposit_id::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  ")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.id = :id")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.id = :id")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.customer_id = :customerId")
    public long findListByCustomerIdCount(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.customer_id = :customerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByCustomerId(@Bind(value="customerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.deposit_id = :depositId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByDepositId(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.deposit_id = :depositId")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDepositId(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.deposit_id = :depositId")
    public long findListByDepositIdCount(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.deposit_id = :depositId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDepositId(@Bind(value="depositId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_from = :dateFrom")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_from = :dateFrom")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.date_from = :dateFrom")
    public long findListByDateFromCount(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_from = :dateFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateFrom(@Bind(value="dateFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_to = :dateTo")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByDateTo(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_to = :dateTo")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateTo(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.date_to = :dateTo")
    public long findListByDateToCount(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_to = :dateTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateTo(@Bind(value="dateTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.note = :note")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.note = :note")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ReservationMapper.class)
    public ReservationDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.reservation p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.customer_id, p.partner_id, p.deposit_id, p.date_from, p.date_to, p.date_updated, p.note, p.date_created FROM renting.reservation p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ReservationMapper.class)
    public List<ReservationDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.reservation (id, uid, customer_id, partner_id, deposit_id, date_from, date_to, date_updated, note, date_created) VALUES (:id, :uid, :customerId, :partnerId, :depositId, :dateFrom, :dateTo, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="customerId") Long var3, @Bind(value="partnerId") Long var4, @Bind(value="depositId") Long var5, @Bind(value="dateFrom") Date var6, @Bind(value="dateTo") Date var7, @Bind(value="dateUpdated") Date var8, @Bind(value="note") String var9, @Bind(value="dateCreated") Date var10);

    @SqlUpdate(value="INSERT INTO renting.reservation (customer_id, partner_id, deposit_id, date_from, date_to, date_updated, note, date_created) VALUES (:e.customerId, :e.partnerId, :e.depositId, :e.dateFrom, :e.dateTo, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ReservationDomain var1);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ReservationDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ReservationDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE customer_id = :byCustomerId")
    public int updateByCustomerId(@BindBean(value="e") ReservationDomain var1, @Bind(value="byCustomerId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") ReservationDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE deposit_id = :byDepositId")
    public int updateByDepositId(@BindBean(value="e") ReservationDomain var1, @Bind(value="byDepositId") Long var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_from = :byDateFrom")
    public int updateByDateFrom(@BindBean(value="e") ReservationDomain var1, @Bind(value="byDateFrom") Date var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_to = :byDateTo")
    public int updateByDateTo(@BindBean(value="e") ReservationDomain var1, @Bind(value="byDateTo") Date var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") ReservationDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ReservationDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.reservation SET id = :e.id, uid = :e.uid, customer_id = :e.customerId, partner_id = :e.partnerId, deposit_id = :e.depositId, date_from = :e.dateFrom, date_to = :e.dateTo, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ReservationDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE customer_id = :customerId")
    public int deleteByCustomerId(@Bind(value="customerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE deposit_id = :depositId")
    public int deleteByDepositId(@Bind(value="depositId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE date_from = :dateFrom")
    public int deleteByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE date_to = :dateTo")
    public int deleteByDateTo(@Bind(value="dateTo") Date var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.reservation WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

