/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.SubscriptionItemsMapper;
import cz.airtoy.airshop.domains.SubscriptionItemsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface SubscriptionItemsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.subscription_id,\n\t\tp.store_cards_id,\n\t\tp.name,\n\t\tp.index,\n\t\tp.ord,\n\t\tp.quantity,\n\t\tp.img,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tabra.subscription_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.subscription_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.subscription_items p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.subscription_id::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.index::text ~* :mask \n\tOR \n\t\tp.ord::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.img::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.subscription_id = :subscriptionId AND p.index = :index")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findBySubscriptionIdIndex(@Bind(value="subscriptionId") Long var1, @Bind(value="index") Integer var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  ")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.id = :id")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.subscription_id = :subscriptionId")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.subscription_id = :subscriptionId")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.subscription_id = :subscriptionId")
    public long findListBySubscriptionIdCount(@Bind(value="subscriptionId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.subscription_id = :subscriptionId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListBySubscriptionId(@Bind(value="subscriptionId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.name = :name")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.name = :name")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.index = :index")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.index = :index")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByIndex(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.index = :index")
    public long findListByIndexCount(@Bind(value="index") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.index = :index ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByIndex(@Bind(value="index") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.ord = :ord")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByOrd(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.ord = :ord")
    public long findListByOrdCount(@Bind(value="ord") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.ord = :ord ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByOrd(@Bind(value="ord") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByQuantity(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByQuantity(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByQuantity(@Bind(value="quantity") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.img = :img")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.img = :img")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByImg(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.img = :img")
    public long findListByImgCount(@Bind(value="img") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.img = :img ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByImg(@Bind(value="img") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.note = :note")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public SubscriptionItemsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.subscription_items p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.subscription_id, p.store_cards_id, p.name, p.index, p.ord, p.quantity, p.img, p.note, p.date_created FROM abra.subscription_items p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=SubscriptionItemsMapper.class)
    public List<SubscriptionItemsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.subscription_items (id, uid, subscription_id, store_cards_id, name, index, ord, quantity, img, note, date_created) VALUES (:id, :uid, :subscriptionId, :storeCardsId, :name, :index, :ord, :quantity, :img, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="subscriptionId") Long var3, @Bind(value="storeCardsId") Long var4, @Bind(value="name") String var5, @Bind(value="index") Integer var6, @Bind(value="ord") Integer var7, @Bind(value="quantity") Integer var8, @Bind(value="img") String var9, @Bind(value="note") String var10, @Bind(value="dateCreated") Date var11);

    @SqlUpdate(value="INSERT INTO abra.subscription_items (subscription_id, store_cards_id, name, index, ord, quantity, img, note, date_created) VALUES (:e.subscriptionId, :e.storeCardsId, :e.name, :e.index, :e.ord, :e.quantity, :e.img, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") SubscriptionItemsDomain var1);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE subscription_id = :bySubscriptionId")
    public int updateBySubscriptionId(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="bySubscriptionId") Long var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE index = :byIndex")
    public int updateByIndex(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byIndex") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE ord = :byOrd")
    public int updateByOrd(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byOrd") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byQuantity") Integer var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE img = :byImg")
    public int updateByImg(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byImg") String var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE abra.subscription_items SET id = :e.id, uid = :e.uid, subscription_id = :e.subscriptionId, store_cards_id = :e.storeCardsId, name = :e.name, index = :e.index, ord = :e.ord, quantity = :e.quantity, img = :e.img, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") SubscriptionItemsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE subscription_id = :subscriptionId")
    public int deleteBySubscriptionId(@Bind(value="subscriptionId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE index = :index")
    public int deleteByIndex(@Bind(value="index") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE ord = :ord")
    public int deleteByOrd(@Bind(value="ord") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE img = :img")
    public int deleteByImg(@Bind(value="img") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM abra.subscription_items WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

