/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.PrintersMapper;
import cz.airtoy.airshop.domains.PrintersDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface PrintersDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.print_server_id,\n\t\tp.type,\n\t\tp.ident,\n\t\tp.print_queue,\n\t\tp.name,\n\t\tp.description,\n\t\tp.location,\n\t\tp.driver,\n\t\tp.connection,\n\t\tp.defaults,\n\t\tp.status,\n\t\tp.date_last_print,\n\t\tp.date_created\n FROM \n\t\tsystem.printers p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.print_server_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.print_queue::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.location::text ~* :mask \n\tOR \n\t\tp.driver::text ~* :mask \n\tOR \n\t\tp.connection::text ~* :mask \n\tOR \n\t\tp.defaults::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_last_print::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tsystem.printers p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.print_server_id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tOR \n\t\tp.print_queue::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.description::text ~* :mask \n\tOR \n\t\tp.location::text ~* :mask \n\tOR \n\t\tp.driver::text ~* :mask \n\tOR \n\t\tp.connection::text ~* :mask \n\tOR \n\t\tp.defaults::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_last_print::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.ident = :ident AND p.name = :name")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByIdentName(@Bind(value="ident") String var1, @Bind(value="name") String var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.id = :id")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.id = :id")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_server_id = :printServerId")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByPrintServerId(@Bind(value="printServerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_server_id = :printServerId")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByPrintServerId(@Bind(value="printServerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.print_server_id = :printServerId")
    public long findListByPrintServerIdCount(@Bind(value="printServerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_server_id = :printServerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByPrintServerId(@Bind(value="printServerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.type = :type")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.type = :type")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_queue = :printQueue")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByPrintQueue(@Bind(value="printQueue") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_queue = :printQueue")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByPrintQueue(@Bind(value="printQueue") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.print_queue = :printQueue")
    public long findListByPrintQueueCount(@Bind(value="printQueue") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.print_queue = :printQueue ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByPrintQueue(@Bind(value="printQueue") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.name = :name")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.name = :name")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.description = :description")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.description = :description")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDescription(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.description = :description")
    public long findListByDescriptionCount(@Bind(value="description") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.description = :description ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDescription(@Bind(value="description") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.location = :location")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByLocation(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.location = :location")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByLocation(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.location = :location")
    public long findListByLocationCount(@Bind(value="location") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.location = :location ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByLocation(@Bind(value="location") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.driver = :driver")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByDriver(@Bind(value="driver") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.driver = :driver")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDriver(@Bind(value="driver") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.driver = :driver")
    public long findListByDriverCount(@Bind(value="driver") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.driver = :driver ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDriver(@Bind(value="driver") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.connection = :connection")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByConnection(@Bind(value="connection") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.connection = :connection")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByConnection(@Bind(value="connection") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.connection = :connection")
    public long findListByConnectionCount(@Bind(value="connection") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.connection = :connection ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByConnection(@Bind(value="connection") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.defaults = :defaults")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByDefaults(@Bind(value="defaults") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.defaults = :defaults")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDefaults(@Bind(value="defaults") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.defaults = :defaults")
    public long findListByDefaultsCount(@Bind(value="defaults") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.defaults = :defaults ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDefaults(@Bind(value="defaults") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.status = :status")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.status = :status")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_last_print = :dateLastPrint")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByDateLastPrint(@Bind(value="dateLastPrint") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_last_print = :dateLastPrint")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDateLastPrint(@Bind(value="dateLastPrint") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.date_last_print = :dateLastPrint")
    public long findListByDateLastPrintCount(@Bind(value="dateLastPrint") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_last_print = :dateLastPrint ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDateLastPrint(@Bind(value="dateLastPrint") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PrintersMapper.class)
    public PrintersDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM system.printers p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.print_server_id, p.type, p.ident, p.print_queue, p.name, p.description, p.location, p.driver, p.connection, p.defaults, p.status, p.date_last_print, p.date_created FROM system.printers p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=PrintersMapper.class)
    public List<PrintersDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO system.printers (id, uid, print_server_id, type, ident, print_queue, name, description, location, driver, connection, defaults, status, date_last_print, date_created) VALUES (:id, :uid, :printServerId, :type, :ident, :printQueue, :name, :description, :location, :driver, :connection, :defaults, :status, :dateLastPrint, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="printServerId") Long var3, @Bind(value="type") String var4, @Bind(value="ident") String var5, @Bind(value="printQueue") String var6, @Bind(value="name") String var7, @Bind(value="description") String var8, @Bind(value="location") String var9, @Bind(value="driver") String var10, @Bind(value="connection") String var11, @Bind(value="defaults") String var12, @Bind(value="status") String var13, @Bind(value="dateLastPrint") Date var14, @Bind(value="dateCreated") Date var15);

    @SqlUpdate(value="INSERT INTO system.printers (print_server_id, type, ident, print_queue, name, description, location, driver, connection, defaults, status, date_last_print, date_created) VALUES (:e.printServerId, :e.type, :e.ident, :e.printQueue, :e.name, :e.description, :e.location, :e.driver, :e.connection, :e.defaults, :e.status, :e.dateLastPrint, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") PrintersDomain var1);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") PrintersDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") PrintersDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE print_server_id = :byPrintServerId")
    public int updateByPrintServerId(@BindBean(value="e") PrintersDomain var1, @Bind(value="byPrintServerId") Long var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") PrintersDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") PrintersDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE print_queue = :byPrintQueue")
    public int updateByPrintQueue(@BindBean(value="e") PrintersDomain var1, @Bind(value="byPrintQueue") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE name = :byName")
    public int updateByName(@BindBean(value="e") PrintersDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE description = :byDescription")
    public int updateByDescription(@BindBean(value="e") PrintersDomain var1, @Bind(value="byDescription") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE location = :byLocation")
    public int updateByLocation(@BindBean(value="e") PrintersDomain var1, @Bind(value="byLocation") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE driver = :byDriver")
    public int updateByDriver(@BindBean(value="e") PrintersDomain var1, @Bind(value="byDriver") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE connection = :byConnection")
    public int updateByConnection(@BindBean(value="e") PrintersDomain var1, @Bind(value="byConnection") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE defaults = :byDefaults")
    public int updateByDefaults(@BindBean(value="e") PrintersDomain var1, @Bind(value="byDefaults") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") PrintersDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE date_last_print = :byDateLastPrint")
    public int updateByDateLastPrint(@BindBean(value="e") PrintersDomain var1, @Bind(value="byDateLastPrint") Date var2);

    @SqlUpdate(value="UPDATE system.printers SET id = :e.id, uid = :e.uid, print_server_id = :e.printServerId, type = :e.type, ident = :e.ident, print_queue = :e.printQueue, name = :e.name, description = :e.description, location = :e.location, driver = :e.driver, connection = :e.connection, defaults = :e.defaults, status = :e.status, date_last_print = :e.dateLastPrint, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") PrintersDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM system.printers WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE print_server_id = :printServerId")
    public int deleteByPrintServerId(@Bind(value="printServerId") Long var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE print_queue = :printQueue")
    public int deleteByPrintQueue(@Bind(value="printQueue") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE description = :description")
    public int deleteByDescription(@Bind(value="description") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE location = :location")
    public int deleteByLocation(@Bind(value="location") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE driver = :driver")
    public int deleteByDriver(@Bind(value="driver") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE connection = :connection")
    public int deleteByConnection(@Bind(value="connection") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE defaults = :defaults")
    public int deleteByDefaults(@Bind(value="defaults") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE date_last_print = :dateLastPrint")
    public int deleteByDateLastPrint(@Bind(value="dateLastPrint") Date var1);

    @SqlUpdate(value="DELETE FROM system.printers WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

