/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.domains.codecs.system;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import cz.airtoy.airshop.domains.system.SystemOrdersDomain;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.eventbus.MessageCodec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemOrdersDomainCodec
implements MessageCodec<SystemOrdersDomain, SystemOrdersDomain> {
    private static final Logger log = LoggerFactory.getLogger(SystemOrdersDomainCodec.class);

    public void encodeToWire(Buffer buffer, SystemOrdersDomain ordersDomain) {
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        String jsonToStr = gson.toJson((Object)ordersDomain);
        int length = jsonToStr.getBytes().length;
        buffer.appendInt(length);
        buffer.appendString(jsonToStr);
    }

    public SystemOrdersDomain decodeFromWire(int position, Buffer buffer) {
        int _pos = position;
        int length = buffer.getInt(_pos);
        String jsonStr = buffer.getString(_pos += 4, _pos += length);
        GsonBuilder gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSSSS");
        Gson gson = gsonBuilder.create();
        return (SystemOrdersDomain)gson.fromJson(jsonStr, SystemOrdersDomain.class);
    }

    public SystemOrdersDomain transform(SystemOrdersDomain ordersDomain) {
        return ordersDomain;
    }

    public String name() {
        return this.getClass().getSimpleName();
    }

    public byte systemCodecID() {
        return -1;
    }
}

