/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.system.help;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.dao.mappers.system.BeersMapper;
import cz.airtoy.airshop.domains.system.WebsiteBeersDomain;
import cz.airtoy.airshop.domains.system.help.BeerWithInfoDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeersWithWebsitesMapper
extends BaseMapper
implements RowMapper<BeerWithInfoDomain> {
    private static final Logger log = LoggerFactory.getLogger(BeersWithWebsitesMapper.class);

    public BeerWithInfoDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        BeerWithInfoDomain d = new BeerWithInfoDomain();
        BeersMapper.processRowMapper(resultSet, d);
        BeersWithWebsitesMapper.addWebsites(resultSet, d);
        return d;
    }

    public static void addWebsites(ResultSet resultSet, BeerWithInfoDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String websites = BeersWithWebsitesMapper.getString(resultSet, "websites");
            if (websites != null && !websites.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(websites, new TypeToken<List<WebsiteBeersDomain>>(){}.getType())) != null) {
                d.setWebsites(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }
}

