/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.mappers.renting.full;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import cz.airtoy.airshop.dao.mappers.common.BaseMapper;
import cz.airtoy.airshop.dao.mappers.renting.RentalPortfolioMapper;
import cz.airtoy.airshop.dao.mappers.renting.ReservationItemsMapper;
import cz.airtoy.airshop.domains.data.TargetCommodityDomain;
import cz.airtoy.airshop.domains.renting.full.ReservationItemsFullDomain;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReservationItemsFullMapper
extends BaseMapper
implements RowMapper<ReservationItemsFullDomain> {
    private static final Logger log = LoggerFactory.getLogger(ReservationItemsFullMapper.class);

    public ReservationItemsFullDomain map(ResultSet resultSet, StatementContext ctx) throws SQLException {
        ReservationItemsFullDomain d = new ReservationItemsFullDomain();
        ReservationItemsMapper.process(resultSet, d);
        RentalPortfolioMapper.process(resultSet, d.getRentalPortfolioDomain(), "renpor_");
        ReservationItemsFullMapper.addTargetCommodities(resultSet, d);
        return d;
    }

    public static void addTargetCommodities(ResultSet resultSet, ReservationItemsFullDomain d) throws SQLException {
        try {
            GsonBuilder gsonBuilder;
            Gson gson;
            List list;
            String targetCommodities = ReservationItemsFullMapper.getString(resultSet, "targetCommodities");
            if (targetCommodities != null && !targetCommodities.isEmpty() && (list = (List)(gson = (gsonBuilder = new GsonBuilder().setDateFormat("yyyy-MM-dd'T'HH:mm:ss")).create()).fromJson(targetCommodities, new TypeToken<List<TargetCommodityDomain>>(){}.getType())) != null) {
                d.setTargetCommodities(list);
            }
        }
        catch (SQLException e) {
            log.error(String.format("SQL Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (JsonSyntaxException e) {
            log.error(String.format("JSON Exception: %s", e.getMessage()), (Throwable)e);
        }
        catch (Exception e) {
            log.error(String.format("Exception: %s", e.getMessage()), (Throwable)e);
        }
    }
}

