/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.upgates;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.upgates.ProductLabelsMapper;
import cz.airtoy.airshop.domains.upgates.ProductLabelsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ProductLabelsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.product_id = :productId AND p.label_id = :labelId AND (p.active_from IS NULL OR NOW() > p.active_from) AND (p.active_to IS NULL OR NOW() <= p.active_to) ")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByProductIdLabelIdActive(@Bind(value="productId") Long var1, @Bind(value="labelId") Integer var2);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgatesdeli.product_labels p  WHERE p.product_id = :productId AND p.label_id = :labelId AND (p.active_from IS NULL OR NOW() > p.active_from) AND (p.active_to IS NULL OR NOW() <= p.active_to) ")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findDeliByProductIdLabelIdActive(@Bind(value="productId") Long var1, @Bind(value="labelId") Integer var2);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.product_id,\n\t\tp.label_id,\n\t\tp.name,\n\t\tp.active_currently_yn,\n\t\tp.active_yn,\n\t\tp.active_from,\n\t\tp.active_to,\n\t\tp.source,\n\t\tp.date_changed,\n\t\tp.date_created,\n\t\tp.version\n FROM \n\t\tupgates.product_labels p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.product_id::text ~* :mask \n\tOR \n\t\tp.label_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.active_currently_yn::text ~* :mask \n\tOR \n\t\tp.active_yn::text ~* :mask \n\tOR \n\t\tp.active_from::text ~* :mask \n\tOR \n\t\tp.active_to::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tupgates.product_labels p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.product_id::text ~* :mask \n\tOR \n\t\tp.label_id::text ~* :mask \n\tOR \n\t\tp.name::text ~* :mask \n\tOR \n\t\tp.active_currently_yn::text ~* :mask \n\tOR \n\t\tp.active_yn::text ~* :mask \n\tOR \n\t\tp.active_from::text ~* :mask \n\tOR \n\t\tp.active_to::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  ")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.id = :id")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.id = :id")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.product_id = :productId")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByProductId(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.product_id = :productId")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByProductId(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.product_id = :productId")
    public long findListByProductIdCount(@Bind(value="productId") Long var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.product_id = :productId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByProductId(@Bind(value="productId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.label_id = :labelId")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByLabelId(@Bind(value="labelId") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.label_id = :labelId")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByLabelId(@Bind(value="labelId") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.label_id = :labelId")
    public long findListByLabelIdCount(@Bind(value="labelId") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.label_id = :labelId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByLabelId(@Bind(value="labelId") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.name = :name")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.name = :name")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByName(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.name = :name")
    public long findListByNameCount(@Bind(value="name") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.name = :name ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByName(@Bind(value="name") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_currently_yn = :activeCurrentlyYn")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByActiveCurrentlyYn(@Bind(value="activeCurrentlyYn") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_currently_yn = :activeCurrentlyYn")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveCurrentlyYn(@Bind(value="activeCurrentlyYn") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.active_currently_yn = :activeCurrentlyYn")
    public long findListByActiveCurrentlyYnCount(@Bind(value="activeCurrentlyYn") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_currently_yn = :activeCurrentlyYn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveCurrentlyYn(@Bind(value="activeCurrentlyYn") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_yn = :activeYn")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByActiveYn(@Bind(value="activeYn") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_yn = :activeYn")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveYn(@Bind(value="activeYn") Boolean var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.active_yn = :activeYn")
    public long findListByActiveYnCount(@Bind(value="activeYn") Boolean var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_yn = :activeYn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveYn(@Bind(value="activeYn") Boolean var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_from = :activeFrom")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByActiveFrom(@Bind(value="activeFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_from = :activeFrom")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveFrom(@Bind(value="activeFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.active_from = :activeFrom")
    public long findListByActiveFromCount(@Bind(value="activeFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_from = :activeFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveFrom(@Bind(value="activeFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_to = :activeTo")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByActiveTo(@Bind(value="activeTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_to = :activeTo")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveTo(@Bind(value="activeTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.active_to = :activeTo")
    public long findListByActiveToCount(@Bind(value="activeTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.active_to = :activeTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByActiveTo(@Bind(value="activeTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.source = :source")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.source = :source")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.version = :version")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public ProductLabelsDomain findByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.version = :version")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.product_labels p  WHERE p.version = :version")
    public long findListByVersionCount(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.product_id, p.label_id, p.name, p.active_currently_yn, p.active_yn, p.active_from, p.active_to, p.source, p.date_changed, p.date_created, p.version FROM upgates.product_labels p  WHERE p.version = :version ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ProductLabelsMapper.class)
    public List<ProductLabelsDomain> findListByVersion(@Bind(value="version") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO upgates.product_labels (id, product_id, label_id, name, active_currently_yn, active_yn, active_from, active_to, source, date_changed, date_created, version) VALUES (:id, :productId, :labelId, :name, :activeCurrentlyYn, :activeYn, :activeFrom, :activeTo, :source, :dateChanged, :dateCreated, :version)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="productId") Long var2, @Bind(value="labelId") Integer var3, @Bind(value="name") String var4, @Bind(value="activeCurrentlyYn") Boolean var5, @Bind(value="activeYn") Boolean var6, @Bind(value="activeFrom") Date var7, @Bind(value="activeTo") Date var8, @Bind(value="source") String var9, @Bind(value="dateChanged") Date var10, @Bind(value="dateCreated") Date var11, @Bind(value="version") Integer var12);

    @SqlUpdate(value="INSERT INTO upgates.product_labels (product_id, label_id, name, active_currently_yn, active_yn, active_from, active_to, source, date_changed, date_created, version) VALUES (:e.productId, :e.labelId, :e.name, :e.activeCurrentlyYn, :e.activeYn, :e.activeFrom, :e.activeTo, :e.source, :e.dateChanged, :e.dateCreated, :e.version)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ProductLabelsDomain var1);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE id = :byId")
    public int updateById(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE product_id = :byProductId")
    public int updateByProductId(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byProductId") Long var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE label_id = :byLabelId")
    public int updateByLabelId(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byLabelId") Integer var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE name = :byName")
    public int updateByName(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byName") String var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE active_currently_yn = :byActiveCurrentlyYn")
    public int updateByActiveCurrentlyYn(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byActiveCurrentlyYn") Boolean var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE active_yn = :byActiveYn")
    public int updateByActiveYn(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byActiveYn") Boolean var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE active_from = :byActiveFrom")
    public int updateByActiveFrom(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byActiveFrom") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE active_to = :byActiveTo")
    public int updateByActiveTo(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byActiveTo") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE upgates.product_labels SET id = :e.id, product_id = :e.productId, label_id = :e.labelId, name = :e.name, active_currently_yn = :e.activeCurrentlyYn, active_yn = :e.activeYn, active_from = :e.activeFrom, active_to = :e.activeTo, source = :e.source, date_changed = :e.dateChanged, date_created = :e.dateCreated, version = :e.version WHERE version = :byVersion")
    public int updateByVersion(@BindBean(value="e") ProductLabelsDomain var1, @Bind(value="byVersion") Integer var2);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE product_id = :productId")
    public int deleteByProductId(@Bind(value="productId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE label_id = :labelId")
    public int deleteByLabelId(@Bind(value="labelId") Integer var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE name = :name")
    public int deleteByName(@Bind(value="name") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE active_currently_yn = :activeCurrentlyYn")
    public int deleteByActiveCurrentlyYn(@Bind(value="activeCurrentlyYn") Boolean var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE active_yn = :activeYn")
    public int deleteByActiveYn(@Bind(value="activeYn") Boolean var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE active_from = :activeFrom")
    public int deleteByActiveFrom(@Bind(value="activeFrom") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE active_to = :activeTo")
    public int deleteByActiveTo(@Bind(value="activeTo") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.product_labels WHERE version = :version")
    public int deleteByVersion(@Bind(value="version") Integer var1);
}

