/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.app;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.app.TranslationsMapper;
import cz.airtoy.airshop.domains.app.TranslationsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface TranslationsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.language,\n\t\tp.key,\n\t\tp.value,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tapp.translations p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.language::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tapp.translations p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.language::text ~* :mask \n\tOR \n\t\tp.key::text ~* :mask \n\tOR \n\t\tp.value::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  ")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.id = :id")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.id = :id")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.language = :language")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByLanguage(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.language = :language")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByLanguage(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.language = :language")
    public long findListByLanguageCount(@Bind(value="language") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.language = :language ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByLanguage(@Bind(value="language") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.key = :key")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.key = :key")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByKey(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.key = :key")
    public long findListByKeyCount(@Bind(value="key") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.key = :key ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByKey(@Bind(value="key") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.value = :value")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.value = :value")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByValue(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.value = :value")
    public long findListByValueCount(@Bind(value="value") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.value = :value ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByValue(@Bind(value="value") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.note = :note")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.note = :note")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public TranslationsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM app.translations p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.language, p.key, p.value, p.note, p.date_created FROM app.translations p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=TranslationsMapper.class)
    public List<TranslationsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO app.translations (id, uid, language, key, value, note, date_created) VALUES (:id, :uid, :language, :key, :value, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="language") String var3, @Bind(value="key") String var4, @Bind(value="value") String var5, @Bind(value="note") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO app.translations (language, key, value, note, date_created) VALUES (:e.language, :e.key, :e.value, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") TranslationsDomain var1);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE language = :byLanguage")
    public int updateByLanguage(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byLanguage") String var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE key = :byKey")
    public int updateByKey(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byKey") String var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE value = :byValue")
    public int updateByValue(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byValue") String var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE app.translations SET id = :e.id, uid = :e.uid, language = :e.language, key = :e.key, value = :e.value, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") TranslationsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM app.translations WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE language = :language")
    public int deleteByLanguage(@Bind(value="language") String var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE key = :key")
    public int deleteByKey(@Bind(value="key") String var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE value = :value")
    public int deleteByValue(@Bind(value="value") String var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM app.translations WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

