/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.utils;

import cz.airtoy.airshop.dao.dbi.AbraCommandsDbiDao;
import cz.airtoy.airshop.domains.AbraCommandsDomain;
import org.apache.log4j.Logger;
import org.postgresql.util.PSQLException;

public class AbraCommandsUtils {
    private static final Logger log = Logger.getLogger(AbraCommandsUtils.class);

    public static AbraCommandsDomain addAbraCommand(AbraCommandsDbiDao abraCommandsDbiDao, String url, String commands, String object, String method, String resultType, String addr, String id, String payload, Long objectId, Long partnerId) {
        AbraCommandsDomain abraCommandsDomain = AbraCommandsUtils.prepareAbraCommandsDomain(url, commands, object, method, resultType, addr, id);
        abraCommandsDomain.setPayload(payload);
        abraCommandsDomain.setObjectId(objectId);
        abraCommandsDomain.setPartnerId(partnerId);
        if (AbraCommandsUtils.insert(abraCommandsDbiDao, abraCommandsDomain)) {
            return abraCommandsDomain;
        }
        return null;
    }

    public static AbraCommandsDomain addAbraCommand(AbraCommandsDbiDao abraCommandsDbiDao, String url, String commands, String object, String method, String resultType, String addr, String id, String payload, Long objectId, Long partnerId, String source) {
        AbraCommandsDomain abraCommandsDomain = AbraCommandsUtils.prepareAbraCommandsDomain(url, commands, object, method, resultType, addr, id);
        abraCommandsDomain.setPayload(payload);
        abraCommandsDomain.setObjectId(objectId);
        abraCommandsDomain.setPartnerId(partnerId);
        abraCommandsDomain.setSource(source);
        if (AbraCommandsUtils.insert(abraCommandsDbiDao, abraCommandsDomain)) {
            return abraCommandsDomain;
        }
        return null;
    }

    public static void update(AbraCommandsDbiDao abraCommandsDbiDao, AbraCommandsDomain abraCommandsDomain) {
        block4: {
            try {
                AbraCommandsUtils.attemptUpdate(abraCommandsDbiDao, abraCommandsDomain);
            }
            catch (PSQLException e) {
                log.warn((Object)("Unexpected database error when updating AbraCommandsDomain - repeat: " + e.getMessage()), (Throwable)e);
                if (!AbraCommandsUtils.isDuplicateKeyViolation(e)) break block4;
                try {
                    AbraCommandsUtils.attemptUpdate(abraCommandsDbiDao, abraCommandsDomain);
                }
                catch (PSQLException ex) {
                    log.error((Object)("Repeated unexpected database error when updating AbraCommandsDomain: " + e.getMessage()), (Throwable)e);
                }
            }
        }
    }

    private static void attemptUpdate(AbraCommandsDbiDao abraCommandsDbiDao, AbraCommandsDomain abraCommandsDomain) throws PSQLException {
        if (abraCommandsDbiDao.updateById2(abraCommandsDomain, abraCommandsDomain.getId()) > 0) {
            log.debug((Object)("AbraCommandsDomain successfully updated: " + abraCommandsDomain));
        } else {
            log.error((Object)("Cannot update AbraCommandsDomain: " + abraCommandsDomain));
        }
    }

    private static boolean insert(AbraCommandsDbiDao abraCommandsDbiDao, AbraCommandsDomain abraCommandsDomain) {
        try {
            return AbraCommandsUtils.attemptInsert(abraCommandsDbiDao, abraCommandsDomain);
        }
        catch (PSQLException e) {
            log.warn((Object)("Unexpected database error when inserting AbraCommandsDomain - repeat: " + e.getMessage()), (Throwable)e);
            if (AbraCommandsUtils.isDuplicateKeyViolation(e)) {
                try {
                    return AbraCommandsUtils.attemptInsert(abraCommandsDbiDao, abraCommandsDomain);
                }
                catch (PSQLException ex) {
                    log.error((Object)("Repeated unexpected database error when inserting AbraCommandsDomain: " + e.getMessage()), (Throwable)e);
                }
            }
            return false;
        }
    }

    private static boolean attemptInsert(AbraCommandsDbiDao abraCommandsDbiDao, AbraCommandsDomain abraCommandsDomain) throws PSQLException {
        long idCommand = abraCommandsDbiDao.insert(abraCommandsDomain);
        if (idCommand > 0L) {
            abraCommandsDomain.setId(idCommand);
            log.info((Object)("AbraCommandsDomain successfully inserted: " + abraCommandsDomain));
            return true;
        }
        log.error((Object)("Failed to insert AbraCommandsDomain: " + abraCommandsDomain));
        return false;
    }

    private static boolean isDuplicateKeyViolation(PSQLException e) {
        return e.getMessage().contains("ERROR: duplicate key value violates unique constraint") && e.getMessage().contains("_uid");
    }

    private static AbraCommandsDomain prepareAbraCommandsDomain(String url, String commands, String object, String method, String resultType, String addr, String id) {
        AbraCommandsDomain abraCommandsDomain = new AbraCommandsDomain();
        abraCommandsDomain.setUrl(url);
        abraCommandsDomain.setCommand(commands);
        abraCommandsDomain.setObject(object);
        abraCommandsDomain.setMethod(method);
        abraCommandsDomain.setResultType(resultType);
        abraCommandsDomain.setEbAddr(addr);
        abraCommandsDomain.setAbraId(id);
        return abraCommandsDomain;
    }
}

