/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.rest.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonPrimitive;
import cz.airtoy.airshop.annotations.AuthDenyAllIn;
import cz.airtoy.airshop.annotations.AuthDenyAllOut;
import cz.airtoy.airshop.annotations.AuthPermitAllIn;
import cz.airtoy.airshop.annotations.AuthPermitAllOut;
import cz.airtoy.airshop.annotations.AuthRolesAllowedIn;
import cz.airtoy.airshop.annotations.AuthRolesAllowedOut;
import cz.airtoy.airshop.configuration.ApplicationConfig;
import cz.airtoy.airshop.configuration.Setup;
import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.dbi.AbraCallsDbiDao;
import cz.airtoy.airshop.dao.dbi.AirshopNotificationsDbiDao;
import cz.airtoy.airshop.dao.dbi.PartnersDbiDao;
import cz.airtoy.airshop.domains.AbraCallsDomain;
import cz.airtoy.airshop.domains.AirshopNotificationsDomain;
import cz.airtoy.airshop.domains.PartnersDomain;
import cz.airtoy.airshop.domains.commons.DomainRolesAuth;
import cz.airtoy.airshop.domains.help.SyncIdRequest;
import cz.airtoy.airshop.domains.help.SyncResponse;
import cz.airtoy.airshop.rest.common.ErrorResponse;
import cz.airtoy.airshop.rest.common.OkResponse;
import cz.airtoy.airshop.rest.common.OkResponseValue;
import cz.airtoy.airshop.support.DaoSupport;
import cz.airtoy.airshop.utils.InternalApiCallResponse;
import cz.airtoy.airshop.utils.InternalApiCallResponseReturn;
import cz.airtoy.airshop.utils.InternalApiCallResponseType;
import cz.airtoy.airshop.utils.VertxCompletableFuture;
import io.vertx.core.Vertx;
import io.vertx.core.eventbus.DeliveryOptions;
import io.vertx.core.eventbus.Message;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.json.Json;
import javax.json.JsonArrayBuilder;
import javax.json.JsonObjectBuilder;
import javax.json.JsonValue;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.apache.commons.lang.StringUtils;
import org.keycloak.KeycloakSecurityContext;
import org.keycloak.representations.AccessToken;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicResource<E, P extends BaseDao> {
    private static final Logger log = LoggerFactory.getLogger(BasicResource.class);
    private static HashMap<String, Method> settersCache = new HashMap();
    private static HashMap<String, Method> gettersCache = new HashMap();
    protected DaoSupport ds;
    protected P dao;
    protected AirshopNotificationsDbiDao airshopNotificationsDbiDao;

    public BasicResource(DaoSupport ds) {
        this.ds = ds;
    }

    public BasicResource(P dao) {
        this.dao = dao;
    }

    protected void logPostRequestBodyToAbraCalls(RoutingContext routingContext, AbraCallsDbiDao abraCallsDbiDao, String body) {
        HttpServerRequest request = routingContext.request();
        String uri = request.uri();
        if (uri != null) {
            log.debug("Seeking for abraCallsDomain by [" + request.method().toString() + "] [" + uri + "] [%127.0.0.1%] [%" + body.length() + "%]");
            AbraCallsDomain abraCallsDomain = abraCallsDbiDao.findByBodyIsNullMethodUriRemoteAddressLikeHeaderLikeLast10min(request.method().toString(), uri, "%127.0.0.1%", body != null ? String.format("%%%d%%", body.length()) : "%");
            if (abraCallsDomain != null) {
                log.debug("Found " + abraCallsDomain);
                abraCallsDomain.setBody(body);
                if (abraCallsDbiDao.updateById(abraCallsDomain, abraCallsDomain.getId()) > 0) {
                    log.info("POST Body updated successfully for id " + abraCallsDomain.getId());
                } else {
                    log.error("Cannot update POST Body for id " + abraCallsDomain.getId());
                }
            } else {
                log.warn("AbraCallsDomain not found, adding new");
                abraCallsDomain = new AbraCallsDomain();
                abraCallsDomain.setMethod(request.method().toString());
                abraCallsDomain.setPath(request.path());
                abraCallsDomain.setUri(uri);
                abraCallsDomain.setRemoteAddress(request.remoteAddress().toString());
                abraCallsDomain.setHeaders(request.headers().toString());
                abraCallsDomain.setBody(body);
                long acId = abraCallsDbiDao.insert(abraCallsDomain);
                if (acId > 0L) {
                    abraCallsDomain.setId(acId);
                    log.info("Abra call successfully inserted " + abraCallsDomain);
                }
            }
        } else {
            log.error("URI is NULL");
        }
    }

    protected InternalApiCallResponseReturn sendApiCallRequest(SyncIdRequest syncIdRequest, String addr, String deliverTimeoutPlaceholder, String timeoutPlaceholder, Vertx vertx, Setup setup, String location) {
        VertxCompletableFuture eventBusCallFuture = new VertxCompletableFuture();
        eventBusCallFuture.exceptionally(e -> {
            log.error("Future exception [" + addr + "]: " + e.getMessage());
            return null;
        });
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout((long)setup.getAsInteger(deliverTimeoutPlaceholder, 5000).intValue());
        vertx.eventBus().request(addr, (Object)syncIdRequest, deliveryOptions, a -> {
            if (a.succeeded()) {
                Message result = (Message)a.result();
                if (result != null) {
                    InternalApiCallResponse callResponse = (InternalApiCallResponse)result.body();
                    eventBusCallFuture.complete(callResponse);
                }
            } else {
                log.error("Problem receiving answer - probably delay: " + a.cause());
            }
        });
        try {
            InternalApiCallResponse callResponse = (InternalApiCallResponse)eventBusCallFuture.get(setup.getAsInteger(timeoutPlaceholder, 5000).intValue(), TimeUnit.MILLISECONDS);
            if (callResponse != null) {
                if (InternalApiCallResponseType.OK.equals((Object)callResponse.getType())) {
                    return new InternalApiCallResponseReturn(callResponse, Response.ok(this.returnStatusOk((E)callResponse), (String)"application/json").header("Location", (Object)location).build());
                }
                return new InternalApiCallResponseReturn(callResponse, Response.ok((Object)this.returnStatusError(callResponse), (String)"application/json").header("Location", (Object)location).build());
            }
        }
        catch (TimeoutException e2) {
            log.error("AbraApiResponse TimeoutException - " + e2.getMessage());
        }
        catch (Exception e3) {
            log.error("Exception AbraApiResponse - " + e3.getMessage());
        }
        return null;
    }

    protected InternalApiCallResponseReturn sendApiCallRequest(InternalApiCallResponse callResponseRequest, String addr, String deliverTimeoutPlaceholder, String timeoutPlaceholder, Vertx vertx, Setup setup, String location) {
        VertxCompletableFuture eventBusCallFuture = new VertxCompletableFuture();
        eventBusCallFuture.exceptionally(e -> {
            log.error("Future exception [" + addr + "]: " + e.getMessage());
            return null;
        });
        DeliveryOptions deliveryOptions = new DeliveryOptions();
        deliveryOptions.setSendTimeout((long)setup.getAsInteger(deliverTimeoutPlaceholder, 5000).intValue());
        vertx.eventBus().request(addr, (Object)callResponseRequest, deliveryOptions, a -> {
            if (a.succeeded()) {
                Message result = (Message)a.result();
                if (result != null) {
                    InternalApiCallResponse callResponse = (InternalApiCallResponse)result.body();
                    eventBusCallFuture.complete(callResponse);
                }
            } else {
                log.error("Problem receiving answer - probably delay: " + a.cause());
            }
        });
        try {
            InternalApiCallResponse callResponse = (InternalApiCallResponse)eventBusCallFuture.get(setup.getAsInteger(timeoutPlaceholder, 5000).intValue(), TimeUnit.MILLISECONDS);
            if (callResponse != null) {
                if (InternalApiCallResponseType.OK.equals((Object)callResponse.getType())) {
                    return new InternalApiCallResponseReturn(callResponse, Response.ok(this.returnStatusOk((E)callResponse), (String)"application/json").header("Location", (Object)location).build());
                }
                return new InternalApiCallResponseReturn(callResponse, Response.ok((Object)this.returnStatusError(callResponse), (String)"application/json").header("Location", (Object)location).build());
            }
        }
        catch (TimeoutException e2) {
            log.error("AbraApiResponse TimeoutException - " + e2.getMessage());
        }
        catch (Exception e3) {
            log.error("Exception AbraApiResponse - " + e3.getMessage());
        }
        return null;
    }

    protected ErrorResponse returnStatusError(InternalApiCallResponse callResponse) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus("ERROR");
        errorResponse.setTitle(callResponse.getTitle());
        errorResponse.setErrorCode(callResponse.getErrorCode());
        errorResponse.setStatusCode(callResponse.getStatusCode());
        errorResponse.setMessages(callResponse.getMessages());
        errorResponse.setDateCreated(callResponse.getDateCreated());
        errorResponse.setDateFinished(callResponse.getDateFinished());
        errorResponse.setTimeInterval(callResponse.getTimeInterval());
        return errorResponse;
    }

    protected OkResponse<E> returnStatusOk(InternalApiCallResponse callResponse) {
        OkResponse okResponse = new OkResponse();
        okResponse.setStatus("OK");
        okResponse.setTitle(callResponse.getTitle());
        okResponse.setErrorCode(callResponse.getErrorCode());
        okResponse.setStatusCode(callResponse.getStatusCode());
        okResponse.setMessages(callResponse.getMessages());
        okResponse.setDateCreated(callResponse.getDateCreated());
        okResponse.setDateFinished(callResponse.getDateFinished());
        okResponse.setTimeInterval(callResponse.getTimeInterval());
        return okResponse;
    }

    protected JsonObjectBuilder returnJsonStatusErrorOpen(String message) {
        JsonObjectBuilder builder = Json.createObjectBuilder();
        builder.add("status", "ERROR");
        JsonArrayBuilder a = Json.createArrayBuilder();
        a.add(message);
        builder.add("messages", (JsonValue)a.build());
        return builder;
    }

    protected String returnJsonStatusError(List<String> messages) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus("ERROR");
        errorResponse.setMessages(messages);
        return this.getGson().toJson((Object)errorResponse);
    }

    protected ErrorResponse returnStatusError(List<String> messages) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus("ERROR");
        errorResponse.setMessages(messages);
        return errorResponse;
    }

    protected String returnJsonStatusError(String message) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus("ERROR");
        errorResponse.setMessages(Collections.singletonList(message));
        return this.getGson().toJson((Object)errorResponse);
    }

    protected ErrorResponse returnStatusError(String message) {
        ErrorResponse errorResponse = new ErrorResponse();
        errorResponse.setStatus("ERROR");
        errorResponse.setMessages(Collections.singletonList(message));
        return errorResponse;
    }

    protected String returnJsonStatusOk() {
        OkResponse okResponse = new OkResponse();
        okResponse.setStatus("OK");
        return this.getGson().toJson(okResponse);
    }

    protected OkResponse<E> returnStatusOk() {
        OkResponse okResponse = new OkResponse();
        okResponse.setStatus("OK");
        return okResponse;
    }

    protected String returnJsonStatusOk(long val) {
        OkResponseValue okResponse = new OkResponseValue();
        okResponse.setStatus("OK");
        okResponse.setData(val);
        return this.getGson().toJson((Object)okResponse);
    }

    protected OkResponseValue returnStatusOk(long val) {
        OkResponseValue okResponse = new OkResponseValue();
        okResponse.setStatus("OK");
        okResponse.setData(val);
        return okResponse;
    }

    protected OkResponseValue returnStatusOk(SyncResponse val) {
        OkResponseValue okResponse = new OkResponseValue();
        okResponse.setStatus("OK");
        okResponse.setData(val);
        return okResponse;
    }

    protected String returnJsonStatusOk(String message) {
        OkResponse okResponse = new OkResponse();
        okResponse.setStatus("OK");
        okResponse.setMessages(Collections.singletonList(message));
        return this.getGson().toJson(okResponse);
    }

    protected OkResponse<E> returnStatusOk(String message) {
        OkResponse okResponse = new OkResponse();
        okResponse.setStatus("OK");
        okResponse.setMessages(Collections.singletonList(message));
        return okResponse;
    }

    protected String returnJsonStatusOk(E object) {
        OkResponse<E> okResponse = new OkResponse<E>();
        okResponse.setStatus("OK");
        okResponse.setData(object);
        return this.getGson().toJson(okResponse);
    }

    protected OkResponse<E> returnStatusOk(E object) {
        OkResponse<E> okResponse = new OkResponse<E>();
        okResponse.setStatus("OK");
        okResponse.setData(object);
        return okResponse;
    }

    public Gson getGson() {
        return new GsonBuilder().disableHtmlEscaping().registerTypeAdapter(java.util.Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(java.util.Date.class, (json, typeOfT, context) -> json == null ? null : new java.util.Date(json.getAsLong())).registerTypeAdapter(Date.class, (src, typeOfSrc, context) -> src == null ? null : new JsonPrimitive((Number)src.getTime())).registerTypeAdapter(Date.class, (json, typeOfT, context) -> json == null ? null : new java.util.Date(json.getAsLong())).serializeNulls().excludeFieldsWithoutExposeAnnotation().create();
    }

    protected E filterAuth(HttpServletRequest httpServletRequest, E domain) {
        List<String> userRoles = DomainRolesAuth.getAllUserRoles(httpServletRequest);
        try {
            Arrays.asList(domain.getClass().getDeclaredFields()).forEach(field -> {
                if (!field.getName().equalsIgnoreCase("serialVersionUID")) {
                    Arrays.asList(field.getAnnotations()).forEach(annotation -> {
                        Class<? extends Annotation> type = annotation.annotationType();
                        if (!annotation.annotationType().equals(AuthPermitAllOut.class)) {
                            if (annotation.annotationType().equals(AuthRolesAllowedOut.class)) {
                                boolean found = false;
                                for (String value : Arrays.asList(((AuthRolesAllowedOut)annotation).value())) {
                                    if (!userRoles.contains(value)) continue;
                                    found = true;
                                }
                                if (!found) {
                                    this.callSetterNull(domain, (Field)field);
                                }
                            } else if (annotation.annotationType().equals(AuthDenyAllOut.class)) {
                                this.callSetterNull(domain, (Field)field);
                            }
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return domain;
    }

    protected E copyAuth(HttpServletRequest httpServletRequest, E targetDomain, E sourceDomain) {
        List<String> userRoles = DomainRolesAuth.getAllUserRoles(httpServletRequest);
        try {
            Arrays.asList(sourceDomain.getClass().getDeclaredFields()).forEach(field -> {
                if (!field.getName().equalsIgnoreCase("serialVersionUID")) {
                    Arrays.asList(field.getAnnotations()).forEach(annotation -> {
                        Class<? extends Annotation> type = annotation.annotationType();
                        if (annotation.annotationType().equals(AuthPermitAllIn.class)) {
                            this.callSetter(targetDomain, (Field)field, this.callGetter(sourceDomain, (Field)field));
                        } else if (annotation.annotationType().equals(AuthRolesAllowedIn.class)) {
                            boolean found = false;
                            for (String value : Arrays.asList(((AuthRolesAllowedIn)annotation).value())) {
                                if (!userRoles.contains(value)) continue;
                                found = true;
                            }
                            if (found) {
                                this.callSetter(targetDomain, (Field)field, this.callGetter(sourceDomain, (Field)field));
                            }
                        } else if (annotation.annotationType().equals(AuthDenyAllIn.class)) {
                            // empty if block
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return targetDomain;
    }

    protected E copySimple(E targetDomain, E sourceDomain) {
        try {
            Arrays.asList(sourceDomain.getClass().getDeclaredFields()).forEach(field -> {
                if (!(field.getName().equalsIgnoreCase("serialVersionUID") || field.getName().equalsIgnoreCase("id") || field.getName().equalsIgnoreCase("uid"))) {
                    Arrays.asList(field.getAnnotations()).forEach(annotation -> this.callSetter(targetDomain, (Field)field, this.callGetter(sourceDomain, (Field)field)));
                }
            });
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return targetDomain;
    }

    protected E copySimple(E targetDomain, E sourceDomain, List<String> avoidFields) {
        try {
            Arrays.asList(sourceDomain.getClass().getDeclaredFields()).forEach(field -> {
                if (!(field.getName().equalsIgnoreCase("serialVersionUID") || field.getName().equalsIgnoreCase("id") || field.getName().equalsIgnoreCase("uid") || avoidFields.contains(field.getName()))) {
                    Arrays.asList(field.getAnnotations()).forEach(annotation -> this.callSetter(targetDomain, (Field)field, this.callGetter(sourceDomain, (Field)field)));
                }
            });
        }
        catch (Exception e) {
            log.error("E: " + e.getMessage());
        }
        return targetDomain;
    }

    private void callSetter(E domain, Field field, Object value) {
        Method nameSetter = this.getSetterMethod(domain, field);
        if (nameSetter != null) {
            try {
                nameSetter.invoke(domain, value);
            }
            catch (Exception e) {
                log.error("E " + domain.getClass().getName() + " / " + field.getName() + " / " + nameSetter.getName() + " : " + e.getMessage());
            }
        }
    }

    private void callSetterNull(E domain, Field field) {
        Method nameSetter = this.getSetterMethod(domain, field);
        if (nameSetter != null) {
            try {
                nameSetter.invoke(domain, new Object[]{null});
            }
            catch (Exception e) {
                log.error("E " + domain.getClass().getName() + " / " + field.getName() + " / " + nameSetter.getName() + " : " + e.getMessage());
            }
        }
    }

    private Object callGetter(E domain, Field field) {
        Method nameGetter = this.getGetterMethod(domain, field);
        if (nameGetter != null) {
            try {
                return nameGetter.invoke(domain, new Object[0]);
            }
            catch (Exception e) {
                log.error("E " + domain.getClass().getName() + " / " + field.getName() + " / " + nameGetter.getName() + " : " + e.getMessage());
            }
        }
        return null;
    }

    private Method getGetterMethod(E domain, Field field) {
        Method nameGetter = null;
        try {
            String name = "get" + StringUtils.capitalize((String)field.getName());
            nameGetter = domain.getClass().getMethod(name, new Class[0]);
        }
        catch (NoSuchMethodException e) {
            log.error("No such method: " + e.getMessage());
        }
        return nameGetter;
    }

    private Method getSetterMethod(E domain, Field field) {
        Method nameSetter = null;
        try {
            String name = "set" + StringUtils.capitalize((String)field.getName());
            nameSetter = domain.getClass().getMethod(name, field.getType());
        }
        catch (NoSuchMethodException e) {
            log.error("No such method: " + e.getMessage());
        }
        return nameSetter;
    }

    public PartnersDomain getLoggedUser(@Context HttpServletRequest httpServletRequest, PartnersDbiDao partnersDbiDao) {
        AccessToken token;
        KeycloakSecurityContext session;
        PartnersDomain partnersDomain = null;
        HttpSession httpSession = httpServletRequest.getSession();
        try {
            if (partnersDomain == null) {
                Long id;
                Object attr1;
                Object attr = httpSession.getAttribute(ApplicationConfig.IDENTITY_ATTRIBUTE);
                if (attr != null && (partnersDomain = (PartnersDomain)attr) != null) {
                    log.debug("Logged partner from session partnerId[" + partnersDomain.getId() + "]");
                }
                if (partnersDomain != null && partnersDomain.getId() == null && (attr1 = httpSession.getAttribute(ApplicationConfig.USER_ID)) != null && (id = (Long)attr1) != null) {
                    log.debug("Logged partner from session ID[" + id + "]");
                    partnersDomain.setId(id);
                }
            }
        }
        catch (Exception e) {
            log.error("E sess: " + e.getMessage());
        }
        if (partnersDomain == null && (session = (KeycloakSecurityContext)httpServletRequest.getAttribute(KeycloakSecurityContext.class.getName())) != null && (token = session.getToken()) != null && (partnersDomain = partnersDbiDao.findByEmail(token.getEmail())) != null) {
            log.debug("Logged partner from keycloak[" + partnersDomain.getId() + "]");
        }
        return partnersDomain;
    }

    protected void addAirshopNotification(SyncIdRequest syncIdRequest) {
        AirshopNotificationsDomain airshopNotificationsDomain = new AirshopNotificationsDomain(syncIdRequest);
        try {
            long id = this.airshopNotificationsDbiDao.insert(airshopNotificationsDomain);
            if (id > 0L) {
                airshopNotificationsDomain.setId(id);
                log.info("Airshop notification added successfully. " + airshopNotificationsDomain);
            } else {
                log.error("Cannot add Airshop notification. " + airshopNotificationsDomain);
            }
        }
        catch (Exception e) {
            log.error("Exception adding airshop notification: " + e.getMessage() + " / " + airshopNotificationsDomain, (Throwable)e);
        }
    }

    public DaoSupport getDs() {
        return this.ds;
    }

    public P getDao() {
        return this.dao;
    }

    public AirshopNotificationsDbiDao getAirshopNotificationsDbiDao() {
        return this.airshopNotificationsDbiDao;
    }

    public void setDs(DaoSupport ds) {
        this.ds = ds;
    }

    public void setDao(P dao) {
        this.dao = dao;
    }

    public void setAirshopNotificationsDbiDao(AirshopNotificationsDbiDao airshopNotificationsDbiDao) {
        this.airshopNotificationsDbiDao = airshopNotificationsDbiDao;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicResource)) {
            return false;
        }
        BasicResource other = (BasicResource)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DaoSupport this$ds = this.getDs();
        DaoSupport other$ds = other.getDs();
        if (this$ds == null ? other$ds != null : !this$ds.equals(other$ds)) {
            return false;
        }
        P this$dao = this.getDao();
        P other$dao = other.getDao();
        if (this$dao == null ? other$dao != null : !this$dao.equals(other$dao)) {
            return false;
        }
        AirshopNotificationsDbiDao this$airshopNotificationsDbiDao = this.getAirshopNotificationsDbiDao();
        AirshopNotificationsDbiDao other$airshopNotificationsDbiDao = other.getAirshopNotificationsDbiDao();
        return !(this$airshopNotificationsDbiDao == null ? other$airshopNotificationsDbiDao != null : !this$airshopNotificationsDbiDao.equals(other$airshopNotificationsDbiDao));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BasicResource;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DaoSupport $ds = this.getDs();
        result = result * 59 + ($ds == null ? 43 : $ds.hashCode());
        P $dao = this.getDao();
        result = result * 59 + ($dao == null ? 43 : $dao.hashCode());
        AirshopNotificationsDbiDao $airshopNotificationsDbiDao = this.getAirshopNotificationsDbiDao();
        result = result * 59 + ($airshopNotificationsDbiDao == null ? 43 : $airshopNotificationsDbiDao.hashCode());
        return result;
    }

    public String toString() {
        return "BasicResource(ds=" + this.getDs() + ", dao=" + this.getDao() + ", airshopNotificationsDbiDao=" + this.getAirshopNotificationsDbiDao() + ")";
    }
}

