/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration;

import com.google.gson.JsonObject;
import cz.airtoy.airshop.domains.OrderProcessItemsDomain;
import cz.airtoy.airshop.integration.common.BaseIntegration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderProcessItemsIntegration
extends BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(OrderProcessItemsIntegration.class);

    public static OrderProcessItemsDomain convert(JsonObject data) {
        OrderProcessItemsDomain d = new OrderProcessItemsDomain();
        d.setId(OrderProcessItemsIntegration.getAsLong(data, "order_process_items.id"));
        d.setUid(OrderProcessItemsIntegration.getAsString(data, "UID"));
        d.setOrderProcessId(OrderProcessItemsIntegration.getAsLong(data, "Order process reference"));
        d.setOrderItemsId(OrderProcessItemsIntegration.getAsLong(data, "Order items reference"));
        d.setShadowOrderItemId(OrderProcessItemsIntegration.getAsLong(data, "Shadow order items reference"));
        d.setStorecardId(OrderProcessItemsIntegration.getAsString(data, "storecard_id"));
        d.setEan(OrderProcessItemsIntegration.getAsString(data, "Hlavn\u00ed EAN = \u010d\u00e1rov\u00fd k\u00f3d"));
        d.setQuantity(OrderProcessItemsIntegration.getAsDouble(data, "actual quantity"));
        d.setColor(OrderProcessItemsIntegration.getAsString(data, "color"));
        d.setStatus(OrderProcessItemsIntegration.getAsString(data, "status"));
        d.setApproved(OrderProcessItemsIntegration.getAsBoolean(data, "approved"));
        d.setExpanded(OrderProcessItemsIntegration.getAsBoolean(data, "expanded"));
        d.setDateUpdated(OrderProcessItemsIntegration.getAsTimestamp(data, "updated"));
        d.setNote(OrderProcessItemsIntegration.getAsString(data, "note"));
        d.setDateCreated(OrderProcessItemsIntegration.getAsTimestamp(data, "order_process_items.date_created"));
        return d;
    }
}

