/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.upgates;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.upgates.WarehouseStoreCardsSumMapper;
import cz.airtoy.airshop.domains.upgates.WarehouseStoreCardsSumDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface WarehouseStoreCardsSumDbiDao
extends BaseDao {
    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET date_synced = NULL, date_changed = NOW(), ident = NULL WHERE storecard_code = :byStorecardCode")
    public int updateForceSyncBeerByStorecardCode(@Bind(value="byStorecardCode") String var1);

    @SqlUpdate(value="UPDATE upgatesdeli.warehouse_store_cards_sum SET date_synced = NULL, date_changed = NOW(), ident = NULL WHERE storecard_code = :byStorecardCode")
    public int updateForceSyncDeliByStorecardCode(@Bind(value="byStorecardCode") String var1);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.storecard_id,\n\t\tp.storecard_code,\n\t\tp.store_cards_id,\n\t\tp.quantity,\n\t\tp.date_synced,\n\t\tp.date_changed,\n\t\tp.date_updated,\n\t\tp.date_created,\n\t\tp.version,\n\t\tp.ident\n FROM \n\t\tupgates.warehouse_store_cards_sum p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.storecard_code::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tupgates.warehouse_store_cards_sum p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.storecard_id::text ~* :mask \n\tOR \n\t\tp.storecard_code::text ~* :mask \n\tOR \n\t\tp.store_cards_id::text ~* :mask \n\tOR \n\t\tp.quantity::text ~* :mask \n\tOR \n\t\tp.date_synced::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.version::text ~* :mask \n\tOR \n\t\tp.ident::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  ")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.id = :id")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_id = :storecardId")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStorecardId(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_id = :storecardId")
    public long findListByStorecardIdCount(@Bind(value="storecardId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_id = :storecardId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStorecardId(@Bind(value="storecardId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_code = :storecardCode")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_code = :storecardCode")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_code = :storecardCode")
    public long findListByStorecardCodeCount(@Bind(value="storecardCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.storecard_code = :storecardCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStorecardCode(@Bind(value="storecardCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.store_cards_id = :storeCardsId")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.store_cards_id = :storeCardsId")
    public long findListByStoreCardsIdCount(@Bind(value="storeCardsId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.store_cards_id = :storeCardsId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByStoreCardsId(@Bind(value="storeCardsId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.quantity = :quantity")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByQuantity(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.quantity = :quantity")
    public long findListByQuantityCount(@Bind(value="quantity") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.quantity = :quantity ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByQuantity(@Bind(value="quantity") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_synced = :dateSynced")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.date_synced = :dateSynced")
    public long findListByDateSyncedCount(@Bind(value="dateSynced") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_synced = :dateSynced ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateSynced(@Bind(value="dateSynced") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.version = :version")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByVersion(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.version = :version")
    public long findListByVersionCount(@Bind(value="version") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.version = :version ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByVersion(@Bind(value="version") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public WarehouseStoreCardsSumDomain findByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.ident = :ident")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByIdent(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM upgates.warehouse_store_cards_sum p  WHERE p.ident = :ident")
    public long findListByIdentCount(@Bind(value="ident") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.storecard_id, p.storecard_code, p.store_cards_id, p.quantity, p.date_synced, p.date_changed, p.date_updated, p.date_created, p.version, p.ident FROM upgates.warehouse_store_cards_sum p  WHERE p.ident = :ident ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=WarehouseStoreCardsSumMapper.class)
    public List<WarehouseStoreCardsSumDomain> findListByIdent(@Bind(value="ident") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards_sum (id, uid, storecard_id, storecard_code, store_cards_id, quantity, date_synced, date_changed, date_updated, date_created, version, ident) VALUES (:id, :uid, :storecardId, :storecardCode, :storeCardsId, :quantity, :dateSynced, :dateChanged, :dateUpdated, :dateCreated, :version, :ident)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="storecardId") String var3, @Bind(value="storecardCode") String var4, @Bind(value="storeCardsId") Long var5, @Bind(value="quantity") Double var6, @Bind(value="dateSynced") Date var7, @Bind(value="dateChanged") Date var8, @Bind(value="dateUpdated") Date var9, @Bind(value="dateCreated") Date var10, @Bind(value="version") Integer var11, @Bind(value="ident") String var12);

    @SqlUpdate(value="INSERT INTO upgates.warehouse_store_cards_sum (storecard_id, storecard_code, store_cards_id, quantity, date_synced, date_changed, date_updated, date_created, version, ident) VALUES (:e.storecardId, :e.storecardCode, :e.storeCardsId, :e.quantity, :e.dateSynced, :e.dateChanged, :e.dateUpdated, :e.dateCreated, :e.version, :e.ident)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") WarehouseStoreCardsSumDomain var1);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE id = :byId")
    public int updateById(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE storecard_id = :byStorecardId")
    public int updateByStorecardId(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byStorecardId") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE storecard_code = :byStorecardCode")
    public int updateByStorecardCode(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byStorecardCode") String var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE store_cards_id = :byStoreCardsId")
    public int updateByStoreCardsId(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byStoreCardsId") Long var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE quantity = :byQuantity")
    public int updateByQuantity(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byQuantity") Double var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_synced = :byDateSynced")
    public int updateByDateSynced(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byDateSynced") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE version = :byVersion")
    public int updateByVersion(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byVersion") Integer var2);

    @SqlUpdate(value="UPDATE upgates.warehouse_store_cards_sum SET id = :e.id, uid = :e.uid, storecard_id = :e.storecardId, storecard_code = :e.storecardCode, store_cards_id = :e.storeCardsId, quantity = :e.quantity, date_synced = :e.dateSynced, date_changed = :e.dateChanged, date_updated = :e.dateUpdated, date_created = :e.dateCreated, version = :e.version, ident = :e.ident WHERE ident = :byIdent")
    public int updateByIdent(@BindBean(value="e") WarehouseStoreCardsSumDomain var1, @Bind(value="byIdent") String var2);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE storecard_id = :storecardId")
    public int deleteByStorecardId(@Bind(value="storecardId") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE storecard_code = :storecardCode")
    public int deleteByStorecardCode(@Bind(value="storecardCode") String var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE store_cards_id = :storeCardsId")
    public int deleteByStoreCardsId(@Bind(value="storeCardsId") Long var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE quantity = :quantity")
    public int deleteByQuantity(@Bind(value="quantity") Double var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE date_synced = :dateSynced")
    public int deleteByDateSynced(@Bind(value="dateSynced") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE version = :version")
    public int deleteByVersion(@Bind(value="version") Integer var1);

    @SqlUpdate(value="DELETE FROM upgates.warehouse_store_cards_sum WHERE ident = :ident")
    public int deleteByIdent(@Bind(value="ident") String var1);
}

