/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.shops;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.shops.BeerShopOrderMapper;
import cz.airtoy.airshop.domains.shops.BeerShopOrderDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface BeerShopOrderDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.shop_code,\n\t\tp.firstname,\n\t\tp.middlename,\n\t\tp.lastname,\n\t\tp.phone,\n\t\tp.email,\n\t\tp.status,\n\t\tp.date_changed,\n\t\tp.user_changed,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tshops.beer_shop_order p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.shop_code::text ~* :mask \n\tOR \n\t\tp.firstname::text ~* :mask \n\tOR \n\t\tp.middlename::text ~* :mask \n\tOR \n\t\tp.lastname::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tshops.beer_shop_order p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.shop_code::text ~* :mask \n\tOR \n\t\tp.firstname::text ~* :mask \n\tOR \n\t\tp.middlename::text ~* :mask \n\tOR \n\t\tp.lastname::text ~* :mask \n\tOR \n\t\tp.phone::text ~* :mask \n\tOR \n\t\tp.email::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.date_changed::text ~* :mask \n\tOR \n\t\tp.user_changed::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  ")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.id = :id")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.shop_code = :shopCode")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByShopCode(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.shop_code = :shopCode")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByShopCode(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.shop_code = :shopCode")
    public long findListByShopCodeCount(@Bind(value="shopCode") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.shop_code = :shopCode ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByShopCode(@Bind(value="shopCode") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.firstname = :firstname")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByFirstname(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.firstname = :firstname")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByFirstname(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.firstname = :firstname")
    public long findListByFirstnameCount(@Bind(value="firstname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.firstname = :firstname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByFirstname(@Bind(value="firstname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.middlename = :middlename")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByMiddlename(@Bind(value="middlename") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.middlename = :middlename")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByMiddlename(@Bind(value="middlename") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.middlename = :middlename")
    public long findListByMiddlenameCount(@Bind(value="middlename") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.middlename = :middlename ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByMiddlename(@Bind(value="middlename") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.lastname = :lastname")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByLastname(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.lastname = :lastname")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByLastname(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.lastname = :lastname")
    public long findListByLastnameCount(@Bind(value="lastname") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.lastname = :lastname ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByLastname(@Bind(value="lastname") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.phone = :phone")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByPhone(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.phone = :phone")
    public long findListByPhoneCount(@Bind(value="phone") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.phone = :phone ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByPhone(@Bind(value="phone") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.email = :email")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.email = :email")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByEmail(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.email = :email")
    public long findListByEmailCount(@Bind(value="email") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.email = :email ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByEmail(@Bind(value="email") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.status = :status")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.status = :status")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_changed = :dateChanged")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.date_changed = :dateChanged")
    public long findListByDateChangedCount(@Bind(value="dateChanged") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_changed = :dateChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByDateChanged(@Bind(value="dateChanged") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.user_changed = :userChanged")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByUserChanged(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.user_changed = :userChanged")
    public long findListByUserChangedCount(@Bind(value="userChanged") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.user_changed = :userChanged ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByUserChanged(@Bind(value="userChanged") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.note = :note")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public BeerShopOrderDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM shops.beer_shop_order p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.shop_code, p.firstname, p.middlename, p.lastname, p.phone, p.email, p.status, p.date_changed, p.user_changed, p.note, p.date_created FROM shops.beer_shop_order p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=BeerShopOrderMapper.class)
    public List<BeerShopOrderDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO shops.beer_shop_order (id, uid, shop_code, firstname, middlename, lastname, phone, email, status, date_changed, user_changed, note, date_created) VALUES (:id, :uid, :shopCode, :firstname, :middlename, :lastname, :phone, :email, :status, :dateChanged, :userChanged, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="shopCode") String var3, @Bind(value="firstname") String var4, @Bind(value="middlename") String var5, @Bind(value="lastname") String var6, @Bind(value="phone") String var7, @Bind(value="email") String var8, @Bind(value="status") String var9, @Bind(value="dateChanged") Date var10, @Bind(value="userChanged") String var11, @Bind(value="note") String var12, @Bind(value="dateCreated") Date var13);

    @SqlUpdate(value="INSERT INTO shops.beer_shop_order (shop_code, firstname, middlename, lastname, phone, email, status, date_changed, user_changed, note, date_created) VALUES (:e.shopCode, :e.firstname, :e.middlename, :e.lastname, :e.phone, :e.email, :e.status, :e.dateChanged, :e.userChanged, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") BeerShopOrderDomain var1);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE shop_code = :byShopCode")
    public int updateByShopCode(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byShopCode") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE firstname = :byFirstname")
    public int updateByFirstname(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byFirstname") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE middlename = :byMiddlename")
    public int updateByMiddlename(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byMiddlename") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE lastname = :byLastname")
    public int updateByLastname(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byLastname") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE phone = :byPhone")
    public int updateByPhone(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byPhone") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE email = :byEmail")
    public int updateByEmail(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byEmail") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_changed = :byDateChanged")
    public int updateByDateChanged(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byDateChanged") Date var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE user_changed = :byUserChanged")
    public int updateByUserChanged(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byUserChanged") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE shops.beer_shop_order SET id = :e.id, uid = :e.uid, shop_code = :e.shopCode, firstname = :e.firstname, middlename = :e.middlename, lastname = :e.lastname, phone = :e.phone, email = :e.email, status = :e.status, date_changed = :e.dateChanged, user_changed = :e.userChanged, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") BeerShopOrderDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE shop_code = :shopCode")
    public int deleteByShopCode(@Bind(value="shopCode") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE firstname = :firstname")
    public int deleteByFirstname(@Bind(value="firstname") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE middlename = :middlename")
    public int deleteByMiddlename(@Bind(value="middlename") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE lastname = :lastname")
    public int deleteByLastname(@Bind(value="lastname") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE phone = :phone")
    public int deleteByPhone(@Bind(value="phone") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE email = :email")
    public int deleteByEmail(@Bind(value="email") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE date_changed = :dateChanged")
    public int deleteByDateChanged(@Bind(value="dateChanged") Date var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE user_changed = :userChanged")
    public int deleteByUserChanged(@Bind(value="userChanged") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM shops.beer_shop_order WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

