/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.renting;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.renting.ContractMapper;
import cz.airtoy.airshop.domains.renting.ContractDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface ContractDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.type,\n\t\tp.customer_id,\n\t\tp.reservation_id,\n\t\tp.partner_id,\n\t\tp.deposit_id,\n\t\tp.status,\n\t\tp.variable_symbol,\n\t\tp.deposit_amount,\n\t\tp.amount,\n\t\tp.payment_type,\n\t\tp.date_from,\n\t\tp.date_to,\n\t\tp.date_rent,\n\t\tp.date_return,\n\t\tp.date_reminder,\n\t\tp.return_note,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.contract p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.reservation_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.deposit_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.variable_symbol::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_rent::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.date_reminder::text ~* :mask \n\tOR \n\t\tp.return_note::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.type,\n\t\tp.customer_id,\n\t\tp.reservation_id,\n\t\tp.partner_id,\n\t\tp.deposit_id,\n\t\tp.status,\n\t\tp.variable_symbol,\n\t\tp.deposit_amount,\n\t\tp.amount,\n\t\tp.payment_type,\n\t\tp.date_from,\n\t\tp.date_to,\n\t\tp.date_rent,\n\t\tp.date_return,\n\t\tp.date_reminder,\n\t\tp.return_note,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\trenting.contract p\n\t\tINNER JOIN renting.customer c ON (p.customer_id = c.id) \n\t\n\tWHERE \n\t  (CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = p.status END) \n AND \t(\t\t\tp.id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.variable_symbol::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_rent::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.date_reminder::text ~* :mask \n\tOR \n\t\tp.return_note::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tc.phone::text ~* :mask \n\tOR \n\t\tc.email::text ~* :mask \n\tOR \n\t\tc.username::text ~* :mask \n\tOR \n\t\tc.nickname::text ~* :mask \n\tOR \n\t\tc.firstname::text ~* :mask \n\tOR \n\t\tc.middlename::text ~* :mask \n\tOR \n\t\tc.lastname::text ~* :mask \n\tOR \n\t\tc.identity_card_number::text ~* :mask \n\tOR \n\t\tc.date_birthday::text ~* :mask \n\tOR \n\t\tc.street::text ~* :mask \n\tOR \n\t\tc.street_nr::text ~* :mask \n\tOR \n\t\tc.zip::text ~* :mask \n\tOR \n\t\tc.city::text ~* :mask \n\tOR \n\t\tc.country::text ~* :mask \n\tOR \n\t\tc.company::text ~* :mask \n\tOR \n\t\tc.company_id::text ~* :mask \n\tOR \n\t\tc.company_vat::text ~* :mask \n\tOR \n\t\tc.invoice_street::text ~* :mask \n\tOR \n\t\tc.invoice_street_nr::text ~* :mask \n\tOR \n\t\tc.invoice_zip::text ~* :mask \n\tOR \n\t\tc.invoice_city::text ~* :mask \n\tOR \n\t\tc.invoice_country::text ~* :mask \n\t) \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findByMaskFilter(@Bind(value="status") String var1, @Bind(value="mask") String var2, @Bind(value="offset") int var3, @Bind(value="limit") int var4, @Define(value="order") String var5, @Define(value="sort") String var6);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.contract p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.customer_id::text ~* :mask \n\tOR \n\t\tp.reservation_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.deposit_id::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.variable_symbol::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_rent::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.date_reminder::text ~* :mask \n\tOR \n\t\tp.return_note::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\trenting.contract p\n\t\tINNER JOIN renting.customer c ON (p.customer_id = c.id) \n\t\n\tWHERE \n\t  (CASE WHEN :status = 'ALL' THEN TRUE ELSE :status = p.status END) \n AND \t(\t\t\tp.id::text ~* :mask \n\tOR \n\t\tp.type::text ~* :mask \n\tOR \n\t\tp.status::text ~* :mask \n\tOR \n\t\tp.variable_symbol::text ~* :mask \n\tOR \n\t\tp.deposit_amount::text ~* :mask \n\tOR \n\t\tp.amount::text ~* :mask \n\tOR \n\t\tp.payment_type::text ~* :mask \n\tOR \n\t\tp.date_from::text ~* :mask \n\tOR \n\t\tp.date_to::text ~* :mask \n\tOR \n\t\tp.date_rent::text ~* :mask \n\tOR \n\t\tp.date_return::text ~* :mask \n\tOR \n\t\tp.date_reminder::text ~* :mask \n\tOR \n\t\tp.return_note::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tc.phone::text ~* :mask \n\tOR \n\t\tc.email::text ~* :mask \n\tOR \n\t\tc.username::text ~* :mask \n\tOR \n\t\tc.nickname::text ~* :mask \n\tOR \n\t\tc.firstname::text ~* :mask \n\tOR \n\t\tc.middlename::text ~* :mask \n\tOR \n\t\tc.lastname::text ~* :mask \n\tOR \n\t\tc.identity_card_number::text ~* :mask \n\tOR \n\t\tc.date_birthday::text ~* :mask \n\tOR \n\t\tc.street::text ~* :mask \n\tOR \n\t\tc.street_nr::text ~* :mask \n\tOR \n\t\tc.zip::text ~* :mask \n\tOR \n\t\tc.city::text ~* :mask \n\tOR \n\t\tc.country::text ~* :mask \n\tOR \n\t\tc.company::text ~* :mask \n\tOR \n\t\tc.company_id::text ~* :mask \n\tOR \n\t\tc.company_vat::text ~* :mask \n\tOR \n\t\tc.invoice_street::text ~* :mask \n\tOR \n\t\tc.invoice_street_nr::text ~* :mask \n\tOR \n\t\tc.invoice_zip::text ~* :mask \n\tOR \n\t\tc.invoice_city::text ~* :mask \n\tOR \n\t\tc.invoice_country::text ~* :mask \n ) \n")
    public long findByMaskFilterCount(@Bind(value="status") String var1, @Bind(value="mask") String var2);

    @SqlQuery(value="SELECT nextval('renting.contract_variable_symbol')")
    public Long getNextValContractVariableSymbol();

    @SqlUpdate(value="UPDATE renting.contract SET \t\tstatus = \t\t    (CASE WHEN ( (date_from < now() ) AND (date_to > now()) AND (date_return IS NULL) ) THEN           'RENT'        ELSE \t    \t    (CASE WHEN ( (date_to < now()) AND (date_return IS NULL) ) THEN               'OVERDUE'            ELSE \t    \t        (CASE WHEN ( (date_return IS NOT NULL) ) THEN                   'RETURN'                ELSE    \t    \t        (CASE WHEN ( date_from > now() ) THEN                       'OPEN'                    ELSE                       'QUEUED'                    END)                END)            END)        END) WHERE id IN (SELECT contract_id FROM renting.contract_document) ")
    public int updateStatusByRules();

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  ")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.id = :id")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.id = :id")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.type = :type")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.type = :type")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByType(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.type = :type")
    public long findListByTypeCount(@Bind(value="type") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.type = :type ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByType(@Bind(value="type") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.customer_id = :customerId")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByCustomerId(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.customer_id = :customerId")
    public long findListByCustomerIdCount(@Bind(value="customerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.customer_id = :customerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByCustomerId(@Bind(value="customerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.reservation_id = :reservationId")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByReservationId(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.reservation_id = :reservationId")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByReservationId(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.reservation_id = :reservationId")
    public long findListByReservationIdCount(@Bind(value="reservationId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.reservation_id = :reservationId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByReservationId(@Bind(value="reservationId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_id = :depositId")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDepositId(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_id = :depositId")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDepositId(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.deposit_id = :depositId")
    public long findListByDepositIdCount(@Bind(value="depositId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_id = :depositId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDepositId(@Bind(value="depositId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.status = :status")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.status = :status")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByStatus(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.status = :status")
    public long findListByStatusCount(@Bind(value="status") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.status = :status ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByStatus(@Bind(value="status") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.variable_symbol = :variableSymbol")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByVariableSymbol(@Bind(value="variableSymbol") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.variable_symbol = :variableSymbol")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByVariableSymbol(@Bind(value="variableSymbol") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.variable_symbol = :variableSymbol")
    public long findListByVariableSymbolCount(@Bind(value="variableSymbol") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.variable_symbol = :variableSymbol ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByVariableSymbol(@Bind(value="variableSymbol") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_amount = :depositAmount")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.deposit_amount = :depositAmount")
    public long findListByDepositAmountCount(@Bind(value="depositAmount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.deposit_amount = :depositAmount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDepositAmount(@Bind(value="depositAmount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.amount = :amount")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByAmount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.amount = :amount")
    public long findListByAmountCount(@Bind(value="amount") Double var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.amount = :amount ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByAmount(@Bind(value="amount") Double var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.payment_type = :paymentType")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByPaymentType(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.payment_type = :paymentType")
    public long findListByPaymentTypeCount(@Bind(value="paymentType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.payment_type = :paymentType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByPaymentType(@Bind(value="paymentType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_from = :dateFrom")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_from = :dateFrom")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_from = :dateFrom")
    public long findListByDateFromCount(@Bind(value="dateFrom") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_from = :dateFrom ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateFrom(@Bind(value="dateFrom") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_to = :dateTo")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateTo(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_to = :dateTo")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateTo(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_to = :dateTo")
    public long findListByDateToCount(@Bind(value="dateTo") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_to = :dateTo ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateTo(@Bind(value="dateTo") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_rent = :dateRent")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateRent(@Bind(value="dateRent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_rent = :dateRent")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateRent(@Bind(value="dateRent") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_rent = :dateRent")
    public long findListByDateRentCount(@Bind(value="dateRent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_rent = :dateRent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateRent(@Bind(value="dateRent") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_return = :dateReturn")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_return = :dateReturn")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_return = :dateReturn")
    public long findListByDateReturnCount(@Bind(value="dateReturn") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_return = :dateReturn ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateReturn(@Bind(value="dateReturn") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_reminder = :dateReminder")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateReminder(@Bind(value="dateReminder") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_reminder = :dateReminder")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateReminder(@Bind(value="dateReminder") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_reminder = :dateReminder")
    public long findListByDateReminderCount(@Bind(value="dateReminder") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_reminder = :dateReminder ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateReminder(@Bind(value="dateReminder") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.return_note = :returnNote")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByReturnNote(@Bind(value="returnNote") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.return_note = :returnNote")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByReturnNote(@Bind(value="returnNote") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.return_note = :returnNote")
    public long findListByReturnNoteCount(@Bind(value="returnNote") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.return_note = :returnNote ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByReturnNote(@Bind(value="returnNote") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.note = :note")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.note = :note")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ContractMapper.class)
    public ContractDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM renting.contract p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.type, p.customer_id, p.reservation_id, p.partner_id, p.deposit_id, p.status, p.variable_symbol, p.deposit_amount, p.amount, p.payment_type, p.date_from, p.date_to, p.date_rent, p.date_return, p.date_reminder, p.return_note, p.date_updated, p.note, p.date_created FROM renting.contract p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=ContractMapper.class)
    public List<ContractDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO renting.contract (id, uid, type, customer_id, reservation_id, partner_id, deposit_id, status, variable_symbol, deposit_amount, amount, payment_type, date_from, date_to, date_rent, date_return, date_reminder, return_note, date_updated, note, date_created) VALUES (:id, :uid, :type, :customerId, :reservationId, :partnerId, :depositId, :status, :variableSymbol, :depositAmount, :amount, :paymentType, :dateFrom, :dateTo, :dateRent, :dateReturn, :dateReminder, :returnNote, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="type") String var3, @Bind(value="customerId") Long var4, @Bind(value="reservationId") Long var5, @Bind(value="partnerId") Long var6, @Bind(value="depositId") Long var7, @Bind(value="status") String var8, @Bind(value="variableSymbol") String var9, @Bind(value="depositAmount") Double var10, @Bind(value="amount") Double var11, @Bind(value="paymentType") String var12, @Bind(value="dateFrom") Date var13, @Bind(value="dateTo") Date var14, @Bind(value="dateRent") Date var15, @Bind(value="dateReturn") Date var16, @Bind(value="dateReminder") Date var17, @Bind(value="returnNote") String var18, @Bind(value="dateUpdated") Date var19, @Bind(value="note") String var20, @Bind(value="dateCreated") Date var21);

    @SqlUpdate(value="INSERT INTO renting.contract (type, customer_id, reservation_id, partner_id, deposit_id, status, variable_symbol, deposit_amount, amount, payment_type, date_from, date_to, date_rent, date_return, date_reminder, return_note, date_updated, note, date_created) VALUES (:e.type, :e.customerId, :e.reservationId, :e.partnerId, :e.depositId, :e.status, :e.variableSymbol, :e.depositAmount, :e.amount, :e.paymentType, :e.dateFrom, :e.dateTo, :e.dateRent, :e.dateReturn, :e.dateReminder, :e.returnNote, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") ContractDomain var1);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") ContractDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") ContractDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE type = :byType")
    public int updateByType(@BindBean(value="e") ContractDomain var1, @Bind(value="byType") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE customer_id = :byCustomerId")
    public int updateByCustomerId(@BindBean(value="e") ContractDomain var1, @Bind(value="byCustomerId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE reservation_id = :byReservationId")
    public int updateByReservationId(@BindBean(value="e") ContractDomain var1, @Bind(value="byReservationId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") ContractDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE deposit_id = :byDepositId")
    public int updateByDepositId(@BindBean(value="e") ContractDomain var1, @Bind(value="byDepositId") Long var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE status = :byStatus")
    public int updateByStatus(@BindBean(value="e") ContractDomain var1, @Bind(value="byStatus") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE variable_symbol = :byVariableSymbol")
    public int updateByVariableSymbol(@BindBean(value="e") ContractDomain var1, @Bind(value="byVariableSymbol") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE deposit_amount = :byDepositAmount")
    public int updateByDepositAmount(@BindBean(value="e") ContractDomain var1, @Bind(value="byDepositAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE amount = :byAmount")
    public int updateByAmount(@BindBean(value="e") ContractDomain var1, @Bind(value="byAmount") Double var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE payment_type = :byPaymentType")
    public int updateByPaymentType(@BindBean(value="e") ContractDomain var1, @Bind(value="byPaymentType") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_from = :byDateFrom")
    public int updateByDateFrom(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateFrom") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_to = :byDateTo")
    public int updateByDateTo(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateTo") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_rent = :byDateRent")
    public int updateByDateRent(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateRent") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_return = :byDateReturn")
    public int updateByDateReturn(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateReturn") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_reminder = :byDateReminder")
    public int updateByDateReminder(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateReminder") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE return_note = :byReturnNote")
    public int updateByReturnNote(@BindBean(value="e") ContractDomain var1, @Bind(value="byReturnNote") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") ContractDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE renting.contract SET id = :e.id, uid = :e.uid, type = :e.type, customer_id = :e.customerId, reservation_id = :e.reservationId, partner_id = :e.partnerId, deposit_id = :e.depositId, status = :e.status, variable_symbol = :e.variableSymbol, deposit_amount = :e.depositAmount, amount = :e.amount, payment_type = :e.paymentType, date_from = :e.dateFrom, date_to = :e.dateTo, date_rent = :e.dateRent, date_return = :e.dateReturn, date_reminder = :e.dateReminder, return_note = :e.returnNote, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") ContractDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE type = :type")
    public int deleteByType(@Bind(value="type") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE customer_id = :customerId")
    public int deleteByCustomerId(@Bind(value="customerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE reservation_id = :reservationId")
    public int deleteByReservationId(@Bind(value="reservationId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE deposit_id = :depositId")
    public int deleteByDepositId(@Bind(value="depositId") Long var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE status = :status")
    public int deleteByStatus(@Bind(value="status") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE variable_symbol = :variableSymbol")
    public int deleteByVariableSymbol(@Bind(value="variableSymbol") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE deposit_amount = :depositAmount")
    public int deleteByDepositAmount(@Bind(value="depositAmount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE amount = :amount")
    public int deleteByAmount(@Bind(value="amount") Double var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE payment_type = :paymentType")
    public int deleteByPaymentType(@Bind(value="paymentType") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_from = :dateFrom")
    public int deleteByDateFrom(@Bind(value="dateFrom") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_to = :dateTo")
    public int deleteByDateTo(@Bind(value="dateTo") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_rent = :dateRent")
    public int deleteByDateRent(@Bind(value="dateRent") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_return = :dateReturn")
    public int deleteByDateReturn(@Bind(value="dateReturn") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_reminder = :dateReminder")
    public int deleteByDateReminder(@Bind(value="dateReminder") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE return_note = :returnNote")
    public int deleteByReturnNote(@Bind(value="returnNote") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM renting.contract WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

