/*
 * Decompiled with CFR 0.152.
 */
package vectron.domains;

import cz.airtoy.airshop.utils.MD5Builder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import vectron.domains.VectronRowItem;
import vectron.domains.VectronRowPart;
import vectron.domains.enums.VectronPaymentType;

public class VectronCommand {
    private static final Logger log = LoggerFactory.getLogger(VectronCommand.class);
    public static final SimpleDateFormat dateFormat = new SimpleDateFormat("dd.MM.yy HH:mm:ss");
    private List<VectronRowItem> items = new ArrayList<VectronRowItem>();
    private VectronPaymentType paymentType = VectronPaymentType.CASH;
    private String paymentReferenceNumber = null;
    private String userInput = null;
    private String pointOfSale = null;
    private Date pointOfSaleTimestamp = null;
    private String orderSource = null;
    private String username = null;
    private Double amount = null;

    public void addItem(VectronRowItem vri) {
        this.items.add(vri);
    }

    public void setPointOfSaleTimestampStr(String pointOfSaleTimestampStr) {
        try {
            this.pointOfSaleTimestamp = dateFormat.parse(pointOfSaleTimestampStr);
        }
        catch (ParseException e) {
            log.error("Cannot parse date [" + pointOfSaleTimestampStr + "]: " + e.getMessage(), (Throwable)e);
        }
    }

    public String getPartValueByType(String lineType, String type) {
        if (lineType != null && type != null && this.items != null) {
            for (VectronRowItem item : this.items) {
                if (!item.getCommandType().equalsIgnoreCase(lineType) || item.getDataParts() == null) continue;
                for (VectronRowPart dataPart : item.getDataParts()) {
                    if (dataPart.getType() == null || !dataPart.getType().equalsIgnoreCase(type)) continue;
                    return dataPart.getValue();
                }
            }
        }
        return null;
    }

    public String getPartStrValueByType(String lineType, String type) {
        String partValueByType = this.getPartValueByType(lineType, type);
        if (partValueByType != null) {
            return partValueByType.replaceAll("'", "");
        }
        return null;
    }

    public String getIdent() {
        return MD5Builder.apply(String.format("%s:%s:%s:%s:%s", this.paymentType.toString(), this.paymentReferenceNumber, this.pointOfSale, this.username, dateFormat.format(this.pointOfSaleTimestamp)));
    }

    public List<VectronRowItem> getItems() {
        return this.items;
    }

    public VectronPaymentType getPaymentType() {
        return this.paymentType;
    }

    public String getPaymentReferenceNumber() {
        return this.paymentReferenceNumber;
    }

    public String getUserInput() {
        return this.userInput;
    }

    public String getPointOfSale() {
        return this.pointOfSale;
    }

    public Date getPointOfSaleTimestamp() {
        return this.pointOfSaleTimestamp;
    }

    public String getOrderSource() {
        return this.orderSource;
    }

    public String getUsername() {
        return this.username;
    }

    public Double getAmount() {
        return this.amount;
    }

    public void setItems(List<VectronRowItem> items) {
        this.items = items;
    }

    public void setPaymentType(VectronPaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public void setPaymentReferenceNumber(String paymentReferenceNumber) {
        this.paymentReferenceNumber = paymentReferenceNumber;
    }

    public void setUserInput(String userInput) {
        this.userInput = userInput;
    }

    public void setPointOfSale(String pointOfSale) {
        this.pointOfSale = pointOfSale;
    }

    public void setPointOfSaleTimestamp(Date pointOfSaleTimestamp) {
        this.pointOfSaleTimestamp = pointOfSaleTimestamp;
    }

    public void setOrderSource(String orderSource) {
        this.orderSource = orderSource;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setAmount(Double amount) {
        this.amount = amount;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VectronCommand)) {
            return false;
        }
        VectronCommand other = (VectronCommand)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<VectronRowItem> this$items = this.getItems();
        List<VectronRowItem> other$items = other.getItems();
        if (this$items == null ? other$items != null : !((Object)this$items).equals(other$items)) {
            return false;
        }
        VectronPaymentType this$paymentType = this.getPaymentType();
        VectronPaymentType other$paymentType = other.getPaymentType();
        if (this$paymentType == null ? other$paymentType != null : !((Object)((Object)this$paymentType)).equals((Object)other$paymentType)) {
            return false;
        }
        String this$paymentReferenceNumber = this.getPaymentReferenceNumber();
        String other$paymentReferenceNumber = other.getPaymentReferenceNumber();
        if (this$paymentReferenceNumber == null ? other$paymentReferenceNumber != null : !this$paymentReferenceNumber.equals(other$paymentReferenceNumber)) {
            return false;
        }
        String this$userInput = this.getUserInput();
        String other$userInput = other.getUserInput();
        if (this$userInput == null ? other$userInput != null : !this$userInput.equals(other$userInput)) {
            return false;
        }
        String this$pointOfSale = this.getPointOfSale();
        String other$pointOfSale = other.getPointOfSale();
        if (this$pointOfSale == null ? other$pointOfSale != null : !this$pointOfSale.equals(other$pointOfSale)) {
            return false;
        }
        Date this$pointOfSaleTimestamp = this.getPointOfSaleTimestamp();
        Date other$pointOfSaleTimestamp = other.getPointOfSaleTimestamp();
        if (this$pointOfSaleTimestamp == null ? other$pointOfSaleTimestamp != null : !((Object)this$pointOfSaleTimestamp).equals(other$pointOfSaleTimestamp)) {
            return false;
        }
        String this$orderSource = this.getOrderSource();
        String other$orderSource = other.getOrderSource();
        if (this$orderSource == null ? other$orderSource != null : !this$orderSource.equals(other$orderSource)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        Double this$amount = this.getAmount();
        Double other$amount = other.getAmount();
        return !(this$amount == null ? other$amount != null : !((Object)this$amount).equals(other$amount));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VectronCommand;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<VectronRowItem> $items = this.getItems();
        result = result * 59 + ($items == null ? 43 : ((Object)$items).hashCode());
        VectronPaymentType $paymentType = this.getPaymentType();
        result = result * 59 + ($paymentType == null ? 43 : ((Object)((Object)$paymentType)).hashCode());
        String $paymentReferenceNumber = this.getPaymentReferenceNumber();
        result = result * 59 + ($paymentReferenceNumber == null ? 43 : $paymentReferenceNumber.hashCode());
        String $userInput = this.getUserInput();
        result = result * 59 + ($userInput == null ? 43 : $userInput.hashCode());
        String $pointOfSale = this.getPointOfSale();
        result = result * 59 + ($pointOfSale == null ? 43 : $pointOfSale.hashCode());
        Date $pointOfSaleTimestamp = this.getPointOfSaleTimestamp();
        result = result * 59 + ($pointOfSaleTimestamp == null ? 43 : ((Object)$pointOfSaleTimestamp).hashCode());
        String $orderSource = this.getOrderSource();
        result = result * 59 + ($orderSource == null ? 43 : $orderSource.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        Double $amount = this.getAmount();
        result = result * 59 + ($amount == null ? 43 : ((Object)$amount).hashCode());
        return result;
    }

    public String toString() {
        return "VectronCommand(items=" + this.getItems() + ", paymentType=" + this.getPaymentType() + ", paymentReferenceNumber=" + this.getPaymentReferenceNumber() + ", userInput=" + this.getUserInput() + ", pointOfSale=" + this.getPointOfSale() + ", pointOfSaleTimestamp=" + this.getPointOfSaleTimestamp() + ", orderSource=" + this.getOrderSource() + ", username=" + this.getUsername() + ", amount=" + this.getAmount() + ")";
    }
}

