/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.integration;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import cz.airtoy.airshop.domains.FirmOfficesDomain;
import cz.airtoy.airshop.integration.AddressesIntegration;
import cz.airtoy.airshop.integration.common.BaseIntegration;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FirmOfficesIntegration
extends BaseIntegration {
    private static final Logger log = LoggerFactory.getLogger(FirmOfficesIntegration.class);

    public static FirmOfficesDomain convert(JsonObject data) {
        FirmOfficesDomain d = new FirmOfficesDomain();
        d.setAbraId(FirmOfficesIntegration.getAsString(data, "id"));
        d.setAddress(AddressesIntegration.convert(FirmOfficesIntegration.getAsObject(data, "address_id")));
        d.setAddressId(d.getAddress() != null ? d.getAddress().getAbraId() : null);
        d.setCheckcredit(FirmOfficesIntegration.getAsBoolean(data, "checkcredit"));
        d.setClassid(FirmOfficesIntegration.getAsString(data, "classid"));
        d.setCredit(FirmOfficesIntegration.getAsDouble(data, "credit"));
        d.setDealercategoryId(FirmOfficesIntegration.getAsString(data, "dealercategory_id"));
        d.setDisplayname(FirmOfficesIntegration.getAsString(data, "displayname"));
        d.setElectronicaddress(AddressesIntegration.convert(FirmOfficesIntegration.getAsObject(data, "electronicaddress_id")));
        d.setElectronicaddressId(d.getElectronicaddress() != null ? d.getElectronicaddress().getAbraId() : null);
        d.setLastchildId(FirmOfficesIntegration.getAsString(data, "lastchild_id"));
        d.setMasscorrespondence(FirmOfficesIntegration.getAsBoolean(data, "masscorrespondence"));
        d.setName(FirmOfficesIntegration.getAsString(data, "name"));
        d.setObjversion(FirmOfficesIntegration.getAsInt(data, "objversion"));
        d.setOfficeidentnumber(FirmOfficesIntegration.getAsString(data, "officeidentnumber"));
        d.setOfficeuniqueId(FirmOfficesIntegration.getAsString(data, "officeunique_id"));
        d.setParentId(FirmOfficesIntegration.getAsString(data, "parent_id"));
        d.setPosindex(FirmOfficesIntegration.getAsInt(data, "posindex"));
        d.setStoreId(FirmOfficesIntegration.getAsString(data, "store_id"));
        d.setSynchronizeaddress(FirmOfficesIntegration.getAsBoolean(data, "synchronizeaddress"));
        return d;
    }

    public static List<FirmOfficesDomain> convert(JsonArray data) {
        ArrayList<FirmOfficesDomain> list = new ArrayList<FirmOfficesDomain>();
        for (JsonElement jsonElement : data) {
            JsonObject obj = jsonElement.getAsJsonObject();
            list.add(FirmOfficesIntegration.convert(obj));
        }
        return list;
    }

    public static FirmOfficesDomain convertFromOrder(String prefix, JsonObject data) {
        FirmOfficesDomain d = new FirmOfficesDomain();
        d.setAbraId(FirmOfficesIntegration.getAsString(data, "firmoffice_id"));
        d.setName(FirmOfficesIntegration.getAsString(data, prefix + ".name"));
        d.setAddressId(FirmOfficesIntegration.getAsString(data, prefix + ".address_id"));
        d.setAddress(AddressesIntegration.convertFromOrder(prefix + ".address_id", data));
        return d;
    }
}

