/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi.data;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.data.CommodityTargetMapper;
import cz.airtoy.airshop.domains.data.CommodityTargetDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface CommodityTargetDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.commodity_id,\n\t\tp.target_id,\n\t\tp.date_updated,\n\t\tp.note,\n\t\tp.date_created\n FROM \n\t\tdata.commodity_target p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.target_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tdata.commodity_target p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.commodity_id::text ~* :mask \n\tOR \n\t\tp.target_id::text ~* :mask \n\tOR \n\t\tp.date_updated::text ~* :mask \n\tOR \n\t\tp.note::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  ")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListAll();

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.id = :id")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.commodity_id = :commodityId")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.commodity_id = :commodityId")
    public long findListByCommodityIdCount(@Bind(value="commodityId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.commodity_id = :commodityId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByCommodityId(@Bind(value="commodityId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.target_id = :targetId")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByTargetId(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.target_id = :targetId")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByTargetId(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.target_id = :targetId")
    public long findListByTargetIdCount(@Bind(value="targetId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.target_id = :targetId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByTargetId(@Bind(value="targetId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_updated = :dateUpdated")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.date_updated = :dateUpdated")
    public long findListByDateUpdatedCount(@Bind(value="dateUpdated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_updated = :dateUpdated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByDateUpdated(@Bind(value="dateUpdated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.note = :note")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByNote(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.note = :note")
    public long findListByNoteCount(@Bind(value="note") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.note = :note ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByNote(@Bind(value="note") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public CommodityTargetDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM data.commodity_target p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.commodity_id, p.target_id, p.date_updated, p.note, p.date_created FROM data.commodity_target p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=CommodityTargetMapper.class)
    public List<CommodityTargetDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO data.commodity_target (id, uid, commodity_id, target_id, date_updated, note, date_created) VALUES (:id, :uid, :commodityId, :targetId, :dateUpdated, :note, :dateCreated)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="commodityId") Long var3, @Bind(value="targetId") Long var4, @Bind(value="dateUpdated") Date var5, @Bind(value="note") String var6, @Bind(value="dateCreated") Date var7);

    @SqlUpdate(value="INSERT INTO data.commodity_target (commodity_id, target_id, date_updated, note, date_created) VALUES (:e.commodityId, :e.targetId, :e.dateUpdated, :e.note, :e.dateCreated)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") CommodityTargetDomain var1);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE id = :byId")
    public int updateById(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE commodity_id = :byCommodityId")
    public int updateByCommodityId(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byCommodityId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE target_id = :byTargetId")
    public int updateByTargetId(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byTargetId") Long var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_updated = :byDateUpdated")
    public int updateByDateUpdated(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byDateUpdated") Date var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE note = :byNote")
    public int updateByNote(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byNote") String var2);

    @SqlUpdate(value="UPDATE data.commodity_target SET id = :e.id, uid = :e.uid, commodity_id = :e.commodityId, target_id = :e.targetId, date_updated = :e.dateUpdated, note = :e.note, date_created = :e.dateCreated WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") CommodityTargetDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE commodity_id = :commodityId")
    public int deleteByCommodityId(@Bind(value="commodityId") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE target_id = :targetId")
    public int deleteByTargetId(@Bind(value="targetId") Long var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE date_updated = :dateUpdated")
    public int deleteByDateUpdated(@Bind(value="dateUpdated") Date var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE note = :note")
    public int deleteByNote(@Bind(value="note") String var1);

    @SqlUpdate(value="DELETE FROM data.commodity_target WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);
}

