/*
 * Decompiled with CFR 0.152.
 */
package cz.airtoy.airshop.dao.dbi;

import cz.airtoy.airshop.dao.commons.BaseDao;
import cz.airtoy.airshop.dao.mappers.AbraCommandsMapper;
import cz.airtoy.airshop.domains.AbraCommandsDomain;
import java.util.Date;
import java.util.List;
import org.jdbi.v3.sqlobject.config.RegisterRowMapper;
import org.jdbi.v3.sqlobject.customizer.Bind;
import org.jdbi.v3.sqlobject.customizer.BindBean;
import org.jdbi.v3.sqlobject.customizer.Define;
import org.jdbi.v3.sqlobject.statement.GetGeneratedKeys;
import org.jdbi.v3.sqlobject.statement.SqlQuery;
import org.jdbi.v3.sqlobject.statement.SqlUpdate;

public interface AbraCommandsDbiDao
extends BaseDao {
    @SqlQuery(value="SELECT \n\tp.id,\n\t\tp.uid,\n\t\tp.url,\n\t\tp.command,\n\t\tp.object,\n\t\tp.object_id,\n\t\tp.partner_id,\n\t\tp.method,\n\t\tp.result_type,\n\t\tp.eb_addr,\n\t\tp.attempts,\n\t\tp.abra_id,\n\t\tp.payload,\n\t\tp.date_sent,\n\t\tp.date_repeat,\n\t\tp.date_processed,\n\t\tp.date_confirmed,\n\t\tp.date_created,\n\t\tp.progress,\n\t\tp.source\n FROM \n\t\tabra.abra_commands p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.command::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.method::text ~* :mask \n\tOR \n\t\tp.result_type::text ~* :mask \n\tOR \n\t\tp.eb_addr::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.payload::text ~* :mask \n\tOR \n\t\tp.date_sent::text ~* :mask \n\tOR \n\t\tp.date_repeat::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_confirmed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.progress::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\tORDER BY \n\t\t<order> <sort> \n\tOFFSET \n\t\t:offset \n\tLIMIT \n\t\t:limit \n")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findByMask(@Bind(value="mask") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT \n\t\tCOUNT(p.*) AS cnt \n FROM \n\t\tabra.abra_commands p\n\t\n\t\tWHERE \n\t\tp.id::text ~* :mask \n\tOR \n\t\tp.uid::text ~* :mask \n\tOR \n\t\tp.url::text ~* :mask \n\tOR \n\t\tp.command::text ~* :mask \n\tOR \n\t\tp.object::text ~* :mask \n\tOR \n\t\tp.object_id::text ~* :mask \n\tOR \n\t\tp.partner_id::text ~* :mask \n\tOR \n\t\tp.method::text ~* :mask \n\tOR \n\t\tp.result_type::text ~* :mask \n\tOR \n\t\tp.eb_addr::text ~* :mask \n\tOR \n\t\tp.attempts::text ~* :mask \n\tOR \n\t\tp.abra_id::text ~* :mask \n\tOR \n\t\tp.payload::text ~* :mask \n\tOR \n\t\tp.date_sent::text ~* :mask \n\tOR \n\t\tp.date_repeat::text ~* :mask \n\tOR \n\t\tp.date_processed::text ~* :mask \n\tOR \n\t\tp.date_confirmed::text ~* :mask \n\tOR \n\t\tp.date_created::text ~* :mask \n\tOR \n\t\tp.progress::text ~* :mask \n\tOR \n\t\tp.source::text ~* :mask \n\n")
    public long findByMaskCount(@Bind(value="mask") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p WHERE p.date_processed IS NULL ORDER BY p.id ASC LIMIT 20")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListUnprocessed20();

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.id = :id")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.id = :id")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListById(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.id = :id")
    public long findListByIdCount(@Bind(value="id") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.id = :id ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListById(@Bind(value="id") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.uid = :uid")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByUid(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.uid = :uid")
    public long findListByUidCount(@Bind(value="uid") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.uid = :uid ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByUid(@Bind(value="uid") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.url = :url")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.url = :url")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByUrl(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.url = :url")
    public long findListByUrlCount(@Bind(value="url") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.url = :url ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByUrl(@Bind(value="url") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.command = :command")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByCommand(@Bind(value="command") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.command = :command")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByCommand(@Bind(value="command") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.command = :command")
    public long findListByCommandCount(@Bind(value="command") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.command = :command ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByCommand(@Bind(value="command") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object = :object")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object = :object")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByObject(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.object = :object")
    public long findListByObjectCount(@Bind(value="object") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object = :object ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByObject(@Bind(value="object") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.command = :command AND p.object_id = :objectId AND p.date_processed IS NULL")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByCommandObjectIdNotProcessed(@Bind(value="command") String var1, @Bind(value="objectId") Long var2);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object_id = :objectId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByObjectId(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.object_id = :objectId")
    public long findListByObjectIdCount(@Bind(value="objectId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.object_id = :objectId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByObjectId(@Bind(value="objectId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.partner_id = :partnerId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.partner_id = :partnerId")
    public long findListByPartnerIdCount(@Bind(value="partnerId") Long var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.partner_id = :partnerId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByPartnerId(@Bind(value="partnerId") Long var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.method = :method")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByMethod(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.method = :method")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByMethod(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.method = :method")
    public long findListByMethodCount(@Bind(value="method") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.method = :method ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByMethod(@Bind(value="method") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.result_type = :resultType")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByResultType(@Bind(value="resultType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.result_type = :resultType")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByResultType(@Bind(value="resultType") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.result_type = :resultType")
    public long findListByResultTypeCount(@Bind(value="resultType") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.result_type = :resultType ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByResultType(@Bind(value="resultType") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.eb_addr = :ebAddr")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.eb_addr = :ebAddr")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.eb_addr = :ebAddr")
    public long findListByEbAddrCount(@Bind(value="ebAddr") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.eb_addr = :ebAddr ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByEbAddr(@Bind(value="ebAddr") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.attempts = :attempts")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByAttempts(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.attempts = :attempts")
    public long findListByAttemptsCount(@Bind(value="attempts") Integer var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.attempts = :attempts ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByAttempts(@Bind(value="attempts") Integer var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.abra_id = :abraId")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByAbraId(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.abra_id = :abraId")
    public long findListByAbraIdCount(@Bind(value="abraId") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.abra_id = :abraId ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByAbraId(@Bind(value="abraId") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.payload = :payload")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByPayload(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.payload = :payload")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByPayload(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.payload = :payload")
    public long findListByPayloadCount(@Bind(value="payload") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.payload = :payload ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByPayload(@Bind(value="payload") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_sent = :dateSent")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByDateSent(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_sent = :dateSent")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateSent(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.date_sent = :dateSent")
    public long findListByDateSentCount(@Bind(value="dateSent") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_sent = :dateSent ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateSent(@Bind(value="dateSent") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_repeat = :dateRepeat")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_repeat = :dateRepeat")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.date_repeat = :dateRepeat")
    public long findListByDateRepeatCount(@Bind(value="dateRepeat") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_repeat = :dateRepeat ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateRepeat(@Bind(value="dateRepeat") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_processed = :dateProcessed")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.date_processed = :dateProcessed")
    public long findListByDateProcessedCount(@Bind(value="dateProcessed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_processed = :dateProcessed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateProcessed(@Bind(value="dateProcessed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_confirmed = :dateConfirmed")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_confirmed = :dateConfirmed")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.date_confirmed = :dateConfirmed")
    public long findListByDateConfirmedCount(@Bind(value="dateConfirmed") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_confirmed = :dateConfirmed ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateConfirmed(@Bind(value="dateConfirmed") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_created = :dateCreated")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.date_created = :dateCreated")
    public long findListByDateCreatedCount(@Bind(value="dateCreated") Date var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.date_created = :dateCreated ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByDateCreated(@Bind(value="dateCreated") Date var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.progress = :progress")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findByProgress(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.progress = :progress")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByProgress(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.progress = :progress")
    public long findListByProgressCount(@Bind(value="progress") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.progress = :progress ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListByProgress(@Bind(value="progress") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.source = :source")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public AbraCommandsDomain findBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.source = :source")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListBySource(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT COUNT(p.*) AS cnt FROM abra.abra_commands p  WHERE p.source = :source")
    public long findListBySourceCount(@Bind(value="source") String var1);

    @SqlQuery(value="SELECT p.id, p.uid, p.url, p.command, p.object, p.object_id, p.partner_id, p.method, p.result_type, p.eb_addr, p.attempts, p.abra_id, p.payload, p.date_sent, p.date_repeat, p.date_processed, p.date_confirmed, p.date_created, p.progress, p.source FROM abra.abra_commands p  WHERE p.source = :source ORDER BY <order> <sort> OFFSET :offset LIMIT :limit")
    @RegisterRowMapper(value=AbraCommandsMapper.class)
    public List<AbraCommandsDomain> findListBySource(@Bind(value="source") String var1, @Bind(value="offset") int var2, @Bind(value="limit") int var3, @Define(value="order") String var4, @Define(value="sort") String var5);

    @SqlUpdate(value="INSERT INTO abra.abra_commands (id, uid, url, command, object, object_id, partner_id, method, result_type, eb_addr, attempts, abra_id, payload, date_sent, date_repeat, date_processed, date_confirmed, date_created, progress, source) VALUES (:id, :uid, :url, :command, :object, :objectId, :partnerId, :method, :resultType, :ebAddr, :attempts, :abraId, :payload, :dateSent, :dateRepeat, :dateProcessed, :dateConfirmed, :dateCreated, :progress, :source)")
    @GetGeneratedKeys
    public long insert(@Bind(value="id") Long var1, @Bind(value="uid") String var2, @Bind(value="url") String var3, @Bind(value="command") String var4, @Bind(value="object") String var5, @Bind(value="objectId") Long var6, @Bind(value="partnerId") Long var7, @Bind(value="method") String var8, @Bind(value="resultType") String var9, @Bind(value="ebAddr") String var10, @Bind(value="attempts") Integer var11, @Bind(value="abraId") String var12, @Bind(value="payload") String var13, @Bind(value="dateSent") Date var14, @Bind(value="dateRepeat") Date var15, @Bind(value="dateProcessed") Date var16, @Bind(value="dateConfirmed") Date var17, @Bind(value="dateCreated") Date var18, @Bind(value="progress") String var19, @Bind(value="source") String var20);

    @SqlUpdate(value="INSERT INTO abra.abra_commands (url, command, object, object_id, partner_id, method, result_type, eb_addr, attempts, abra_id, payload, date_sent, date_repeat, date_processed, date_confirmed, date_created, progress, source) VALUES (:e.url, :e.command, :e.object, :e.objectId, :e.partnerId, :e.method, :e.resultType, :e.ebAddr, :e.attempts, :e.abraId, :e.payload, :e.dateSent, :e.dateRepeat, :e.dateProcessed, :e.dateConfirmed, :e.dateCreated, :e.progress, :e.source)")
    @GetGeneratedKeys
    public long insert(@BindBean(value="e") AbraCommandsDomain var1);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE id = :byId")
    public int updateById(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE id = :byId")
    public int updateById2(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE uid = :byUid")
    public int updateByUid(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byUid") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE url = :byUrl")
    public int updateByUrl(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byUrl") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE command = :byCommand")
    public int updateByCommand(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byCommand") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE object = :byObject")
    public int updateByObject(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byObject") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE object_id = :byObjectId")
    public int updateByObjectId(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byObjectId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE partner_id = :byPartnerId")
    public int updateByPartnerId(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byPartnerId") Long var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE method = :byMethod")
    public int updateByMethod(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byMethod") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE result_type = :byResultType")
    public int updateByResultType(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byResultType") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE eb_addr = :byEbAddr")
    public int updateByEbAddr(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byEbAddr") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE attempts = :byAttempts")
    public int updateByAttempts(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byAttempts") Integer var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE abra_id = :byAbraId")
    public int updateByAbraId(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byAbraId") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE payload = :byPayload")
    public int updateByPayload(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byPayload") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE date_sent = :byDateSent")
    public int updateByDateSent(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byDateSent") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE date_repeat = :byDateRepeat")
    public int updateByDateRepeat(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byDateRepeat") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE date_processed = :byDateProcessed")
    public int updateByDateProcessed(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byDateProcessed") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE date_confirmed = :byDateConfirmed")
    public int updateByDateConfirmed(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byDateConfirmed") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE date_created = :byDateCreated")
    public int updateByDateCreated(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byDateCreated") Date var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE progress = :byProgress")
    public int updateByProgress(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="byProgress") String var2);

    @SqlUpdate(value="UPDATE abra.abra_commands SET id = :e.id, uid = :e.uid, url = :e.url, command = :e.command, object = :e.object, object_id = :e.objectId, partner_id = :e.partnerId, method = :e.method, result_type = :e.resultType, eb_addr = :e.ebAddr, attempts = :e.attempts, abra_id = :e.abraId, payload = :e.payload, date_sent = :e.dateSent, date_repeat = :e.dateRepeat, date_processed = :e.dateProcessed, date_confirmed = :e.dateConfirmed, date_created = :e.dateCreated, progress = :e.progress, source = :e.source WHERE source = :bySource")
    public int updateBySource(@BindBean(value="e") AbraCommandsDomain var1, @Bind(value="bySource") String var2);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE id = :id")
    public int deleteById(@Bind(value="id") Long var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE uid = :uid")
    public int deleteByUid(@Bind(value="uid") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE url = :url")
    public int deleteByUrl(@Bind(value="url") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE command = :command")
    public int deleteByCommand(@Bind(value="command") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE object = :object")
    public int deleteByObject(@Bind(value="object") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE object_id = :objectId")
    public int deleteByObjectId(@Bind(value="objectId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE partner_id = :partnerId")
    public int deleteByPartnerId(@Bind(value="partnerId") Long var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE method = :method")
    public int deleteByMethod(@Bind(value="method") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE result_type = :resultType")
    public int deleteByResultType(@Bind(value="resultType") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE eb_addr = :ebAddr")
    public int deleteByEbAddr(@Bind(value="ebAddr") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE attempts = :attempts")
    public int deleteByAttempts(@Bind(value="attempts") Integer var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE abra_id = :abraId")
    public int deleteByAbraId(@Bind(value="abraId") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE payload = :payload")
    public int deleteByPayload(@Bind(value="payload") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE date_sent = :dateSent")
    public int deleteByDateSent(@Bind(value="dateSent") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE date_repeat = :dateRepeat")
    public int deleteByDateRepeat(@Bind(value="dateRepeat") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE date_processed = :dateProcessed")
    public int deleteByDateProcessed(@Bind(value="dateProcessed") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE date_confirmed = :dateConfirmed")
    public int deleteByDateConfirmed(@Bind(value="dateConfirmed") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE date_created = :dateCreated")
    public int deleteByDateCreated(@Bind(value="dateCreated") Date var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE progress = :progress")
    public int deleteByProgress(@Bind(value="progress") String var1);

    @SqlUpdate(value="DELETE FROM abra.abra_commands WHERE source = :source")
    public int deleteBySource(@Bind(value="source") String var1);
}

